/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;

public class HC128Engine
implements StreamCipher {
    private int[] p = new int[512];
    private int[] q = new int[512];
    private int cnt = 0;
    private byte[] key;
    private byte[] iv;
    private boolean initialised;
    private byte[] buf = new byte[4];
    private int idx = 0;

    private static int f1(int n) {
        return HC128Engine.rotateRight(n, 7) ^ HC128Engine.rotateRight(n, 18) ^ n >>> 3;
    }

    private static int f2(int n) {
        return HC128Engine.rotateRight(n, 17) ^ HC128Engine.rotateRight(n, 19) ^ n >>> 10;
    }

    private int g1(int n, int n2, int n3) {
        return (HC128Engine.rotateRight(n, 10) ^ HC128Engine.rotateRight(n3, 23)) + HC128Engine.rotateRight(n2, 8);
    }

    private int g2(int n, int n2, int n3) {
        return (HC128Engine.rotateLeft(n, 10) ^ HC128Engine.rotateLeft(n3, 23)) + HC128Engine.rotateLeft(n2, 8);
    }

    private static int rotateLeft(int n, int n2) {
        return n << n2 | n >>> -n2;
    }

    private static int rotateRight(int n, int n2) {
        return n >>> n2 | n << -n2;
    }

    private int h1(int n) {
        Object object = ((HC128Engine)object).q;
        return ((HC128Engine)object).q[n & 0xFF] + object[(n >> 16 & 0xFF) + 256];
    }

    private int h2(int n) {
        Object object = ((HC128Engine)object).p;
        return ((HC128Engine)object).p[n & 0xFF] + object[(n >> 16 & 0xFF) + 256];
    }

    private static int mod1024(int n) {
        return n & 0x3FF;
    }

    private static int mod512(int n) {
        return n & 0x1FF;
    }

    private static int dim(int n, int n2) {
        return HC128Engine.mod512(n - n2);
    }

    private int step() {
        int n;
        HC128Engine hC128Engine = this;
        int n2 = HC128Engine.mod512(hC128Engine.cnt);
        if (hC128Engine.cnt < 512) {
            HC128Engine hC128Engine2 = this;
            int[] nArray = hC128Engine2.p;
            HC128Engine hC128Engine3 = this;
            int n3 = hC128Engine3.p[HC128Engine.dim(n2, 10)];
            hC128Engine2.p[n2] = nArray[n2] + this.g1(nArray[HC128Engine.dim(n2, 3)], n3, hC128Engine3.p[HC128Engine.dim(n2, 511)]);
            n = hC128Engine2.h1(hC128Engine2.p[HC128Engine.dim(n2, 12)]) ^ this.p[n2];
        } else {
            HC128Engine hC128Engine4 = this;
            int[] nArray = hC128Engine4.q;
            HC128Engine hC128Engine5 = this;
            int n4 = hC128Engine5.q[HC128Engine.dim(n2, 10)];
            hC128Engine4.q[n2] = nArray[n2] + this.g2(nArray[HC128Engine.dim(n2, 3)], n4, hC128Engine5.q[HC128Engine.dim(n2, 511)]);
            n = hC128Engine4.h2(hC128Engine4.q[HC128Engine.dim(n2, 12)]) ^ this.q[n2];
        }
        this.cnt = HC128Engine.mod1024(this.cnt + 1);
        return n;
    }

    private void init() {
        if (this.key.length == 16) {
            int n;
            int n2;
            HC128Engine hC128Engine = this;
            hC128Engine.idx = 0;
            hC128Engine.cnt = 0;
            int[] nArray = new int[1280];
            for (n2 = 0; n2 < 16; ++n2) {
                int n3 = n2 >> 2;
                nArray[n3] = nArray[n3] | (this.key[n2] & 0xFF) << (n2 & 3) * 8;
            }
            System.arraycopy(nArray, 0, nArray, 4, 4);
            n2 = 0;
            while (true) {
                byte[] byArray = this.iv;
                if (n2 >= this.iv.length || n2 >= 16) break;
                int n4 = (n2 >> 2) + 8;
                nArray[n4] = nArray[n4] | (byArray[n2] & 0xFF) << (n2 & 3) * 8;
                ++n2;
            }
            System.arraycopy(nArray, 8, nArray, 12, 4);
            for (n2 = 16; n2 < 1280; ++n2) {
                nArray[n2] = HC128Engine.f2(nArray[n2 - 2]) + nArray[n2 - 7] + HC128Engine.f1(nArray[n2 - 15]) + nArray[n2 - 16] + n2;
            }
            System.arraycopy(nArray, 256, this.p, 0, 512);
            System.arraycopy(nArray, 768, this.q, 0, 512);
            for (n = 0; n < 512; ++n) {
                this.p[n] = this.step();
            }
            for (n = 0; n < 512; ++n) {
                this.q[n] = this.step();
            }
            this.cnt = 0;
            return;
        }
        throw new IllegalArgumentException("The key must be 128 bits long");
    }

    private byte getByte() {
        int n;
        if (this.idx == 0) {
            HC128Engine hC128Engine = this;
            n = hC128Engine.step();
            byte[] byArray = hC128Engine.buf;
            byArray[0] = (byte)(n & 0xFF);
            int n2 = n >> 8;
            byArray[1] = (byte)(n2 & 0xFF);
            int n3 = n2 >> 8;
            byArray[2] = (byte)(n3 & 0xFF);
            hC128Engine.buf[3] = (byte)(n3 >> 8 & 0xFF);
        }
        n = this.idx;
        this.idx = n + 1 & 3;
        return this.buf[n];
    }

    @Override
    public String getAlgorithmName() {
        return "HC-128";
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        CipherParameters cipherParameters2;
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            this.iv = parametersWithIV.getIV();
            cipherParameters2 = parametersWithIV.getParameters();
        } else {
            this.iv = new byte[0];
            cipherParameters2 = cipherParameters;
        }
        if (cipherParameters2 instanceof KeyParameter) {
            this.key = ((KeyParameter)cipherParameters2).getKey();
            this.init();
            this.initialised = true;
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a("Invalid parameter passed to HC128 init - ")));
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (this.initialised) {
            if (n + n2 <= byArray.length) {
                if (n3 + n2 <= byArray2.length) {
                    for (int k = 0; k < n2; ++k) {
                        int n4 = n3 + k;
                        byArray2[n4] = (byte)(byArray[n + k] ^ this.getByte());
                    }
                    return n2;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }

    @Override
    public void reset() {
        this.init();
    }

    @Override
    public byte returnByte(byte by) {
        return (byte)(by ^ this.getByte());
    }
}

