/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Xof;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.CSHAKEDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.XofUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;

public class KMAC
implements Mac,
Xof {
    private static final byte[] padding = new byte[100];
    private final CSHAKEDigest cshake;
    private final int bitLength;
    private final int outputLength;
    private byte[] key;
    private boolean initialised;
    private boolean firstOutput;

    public KMAC(int n, byte[] byArray) {
        this.cshake = new CSHAKEDigest(n, Strings.toByteArray("KMAC"), byArray);
        this.bitLength = n;
        this.outputLength = n * 2 / 8;
    }

    private void bytePad(byte[] byArray, int n) {
        byte[] byArray2 = byArray;
        byArray = XofUtils.leftEncode(n);
        this.update(byArray, 0, byArray.length);
        byte[] byArray3 = KMAC.encode(byArray2);
        this.update(byArray3, 0, byArray3.length);
        int n2 = n - (byArray.length + byArray3.length) % n;
        if (n2 > 0 && n2 != n) {
            byte[] byArray4;
            while (true) {
                byArray4 = padding;
                if (n2 <= padding.length) break;
                this.update(byArray4, 0, byArray4.length);
                n2 -= byArray4.length;
            }
            this.update(byArray4, 0, n2);
        }
    }

    private static byte[] encode(byte[] byArray) {
        return Arrays.concatenate(XofUtils.leftEncode(byArray.length * 8), byArray);
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        this.key = Arrays.clone(((KeyParameter)cipherParameters).getKey());
        this.initialised = true;
        this.reset();
    }

    @Override
    public String getAlgorithmName() {
        return b.a("KMAC").append(this.cshake.getAlgorithmName().substring(6)).toString();
    }

    @Override
    public int getByteLength() {
        return this.cshake.getByteLength();
    }

    @Override
    public int getMacSize() {
        return this.outputLength;
    }

    @Override
    public int getDigestSize() {
        return this.outputLength;
    }

    @Override
    public void update(byte by) {
        if (this.initialised) {
            this.cshake.update(by);
            return;
        }
        throw new IllegalStateException("KMAC not initialized");
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        if (this.initialised) {
            this.cshake.update(byArray, n, n2);
            return;
        }
        throw new IllegalStateException("KMAC not initialized");
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        if (this.firstOutput) {
            if (this.initialised) {
                KMAC kMAC = this;
                byte[] byArray2 = XofUtils.rightEncode(kMAC.getMacSize() * 8);
                kMAC.cshake.update(byArray2, 0, byArray2.length);
            } else {
                throw new IllegalStateException("KMAC not initialized");
            }
        }
        int n2 = this.cshake.doFinal(byArray, n, this.getMacSize());
        this.reset();
        return n2;
    }

    @Override
    public int doFinal(byte[] byArray, int n, int n2) {
        if (this.firstOutput) {
            if (this.initialised) {
                byte[] byArray2 = XofUtils.rightEncode(n2 * 8);
                this.cshake.update(byArray2, 0, byArray2.length);
            } else {
                throw new IllegalStateException("KMAC not initialized");
            }
        }
        int n3 = this.cshake.doFinal(byArray, n, n2);
        this.reset();
        return n3;
    }

    @Override
    public int doOutput(byte[] byArray, int n, int n2) {
        if (this.firstOutput) {
            if (this.initialised) {
                byte[] byArray2 = XofUtils.rightEncode(0L);
                this.cshake.update(byArray2, 0, byArray2.length);
                this.firstOutput = false;
            } else {
                throw new IllegalStateException("KMAC not initialized");
            }
        }
        return this.cshake.doOutput(byArray, n, n2);
    }

    @Override
    public void reset() {
        KMAC kMAC = this;
        kMAC.cshake.reset();
        byte[] byArray = kMAC.key;
        if (kMAC.key != null) {
            if (this.bitLength == 128) {
                this.bytePad(byArray, 168);
            } else {
                this.bytePad(byArray, 136);
            }
        }
        this.firstOutput = true;
    }
}

