/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;

public class PGPCFBBlockCipher
implements BlockCipher {
    private byte[] IV;
    private byte[] FR;
    private byte[] FRE;
    private byte[] tmp;
    private BlockCipher cipher;
    private int count;
    private int blockSize;
    private boolean forEncryption;
    private boolean inlineIv;

    public PGPCFBBlockCipher(BlockCipher blockCipher, boolean bl) {
        int n;
        PGPCFBBlockCipher pGPCFBBlockCipher = this;
        this.cipher = blockCipher;
        this.inlineIv = bl;
        pGPCFBBlockCipher.blockSize = n = blockCipher.getBlockSize();
        pGPCFBBlockCipher.IV = new byte[n];
        pGPCFBBlockCipher.FR = new byte[n];
        pGPCFBBlockCipher.FRE = new byte[n];
        pGPCFBBlockCipher.tmp = new byte[n];
    }

    private byte encryptByte(byte by, int n) {
        return (byte)(this.FRE[n] ^ by);
    }

    private int encryptBlockWithIV(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = this.blockSize;
        if (n + n3 <= byArray.length) {
            int n4 = this.count;
            if (n4 == 0) {
                if (n3 * 2 + n2 + 2 <= byArray2.length) {
                    int n5;
                    int n6;
                    PGPCFBBlockCipher pGPCFBBlockCipher = this;
                    byte[] byArray3 = pGPCFBBlockCipher.FR;
                    byte[] byArray4 = pGPCFBBlockCipher.FRE;
                    this.cipher.processBlock(byArray3, 0, byArray4, 0);
                    for (int k = 0; k < (n6 = this.blockSize); ++k) {
                        PGPCFBBlockCipher pGPCFBBlockCipher2 = this;
                        n6 = n2 + k;
                        byArray2[n6] = pGPCFBBlockCipher2.encryptByte(pGPCFBBlockCipher2.IV[k], k);
                    }
                    PGPCFBBlockCipher pGPCFBBlockCipher3 = this;
                    PGPCFBBlockCipher pGPCFBBlockCipher4 = this;
                    PGPCFBBlockCipher pGPCFBBlockCipher5 = this;
                    PGPCFBBlockCipher pGPCFBBlockCipher6 = this;
                    System.arraycopy(byArray2, n2, this.FR, 0, n6);
                    PGPCFBBlockCipher pGPCFBBlockCipher7 = this;
                    byte[] byArray5 = pGPCFBBlockCipher7.FR;
                    byte[] byArray6 = pGPCFBBlockCipher7.FRE;
                    pGPCFBBlockCipher6.cipher.processBlock(byArray5, 0, byArray6, 0);
                    int n7 = pGPCFBBlockCipher6.blockSize;
                    int n8 = n2 + n7;
                    byArray2[n8] = pGPCFBBlockCipher5.encryptByte(pGPCFBBlockCipher5.IV[n7 - 2], 0);
                    n7 = this.blockSize;
                    n8 = n2 + n7 + 1;
                    byArray2[n8] = pGPCFBBlockCipher4.encryptByte(pGPCFBBlockCipher4.IV[n7 - 1], 1);
                    n7 = n2 + 2;
                    byte[] byArray7 = pGPCFBBlockCipher3.FR;
                    int n9 = pGPCFBBlockCipher3.blockSize;
                    System.arraycopy(byArray2, n7, byArray7, 0, n9);
                    PGPCFBBlockCipher pGPCFBBlockCipher8 = this;
                    byte[] byArray8 = pGPCFBBlockCipher8.FR;
                    byArray7 = pGPCFBBlockCipher8.FRE;
                    this.cipher.processBlock(byArray8, 0, byArray7, 0);
                    for (int k = 0; k < (n5 = this.blockSize); ++k) {
                        n5 = a.a(n2, n5, 2, k);
                        byArray2[n5] = this.encryptByte(byArray[n + k], k);
                    }
                    PGPCFBBlockCipher pGPCFBBlockCipher9 = this;
                    int n10 = n2 + n5 + 2;
                    System.arraycopy(byArray2, n10, this.FR, 0, n5);
                    n10 = pGPCFBBlockCipher9.count;
                    int n11 = pGPCFBBlockCipher9.blockSize;
                    this.count = n11 * 2 + 2 + n10;
                    return n11 * 2 + 2;
                }
                throw new OutputLengthException("output buffer too short");
            }
            if (n4 >= n3 + 2) {
                if (n2 + n3 <= byArray2.length) {
                    int n12;
                    PGPCFBBlockCipher pGPCFBBlockCipher = this;
                    byte[] byArray9 = pGPCFBBlockCipher.FR;
                    byte[] byArray10 = pGPCFBBlockCipher.FRE;
                    this.cipher.processBlock(byArray9, 0, byArray10, 0);
                    for (int k = 0; k < (n12 = this.blockSize); ++k) {
                        n12 = n2 + k;
                        byArray2[n12] = this.encryptByte(byArray[n + k], k);
                    }
                    System.arraycopy(byArray2, n2, this.FR, 0, n12);
                } else {
                    throw new OutputLengthException("output buffer too short");
                }
            }
            return this.blockSize;
        }
        throw new DataLengthException("input buffer too short");
    }

    private int decryptBlockWithIV(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = ((PGPCFBBlockCipher)object).blockSize;
        if (n + n3 <= byArray.length) {
            if (n2 + n3 <= byArray2.length) {
                int n4 = ((PGPCFBBlockCipher)object).count;
                if (n4 == 0) {
                    for (int k = 0; k < ((PGPCFBBlockCipher)object).blockSize; ++k) {
                        ((PGPCFBBlockCipher)object).FR[k] = byArray[n + k];
                    }
                    PGPCFBBlockCipher pGPCFBBlockCipher = object;
                    PGPCFBBlockCipher pGPCFBBlockCipher2 = object;
                    byArray = pGPCFBBlockCipher2.FR;
                    byte[] byArray3 = pGPCFBBlockCipher2.FRE;
                    pGPCFBBlockCipher.cipher.processBlock(byArray, 0, byArray3, 0);
                    pGPCFBBlockCipher.count += ((PGPCFBBlockCipher)object).blockSize;
                    return 0;
                }
                if (n4 == n3) {
                    int n5;
                    PGPCFBBlockCipher pGPCFBBlockCipher = object;
                    System.arraycopy(byArray, n, ((PGPCFBBlockCipher)object).tmp, 0, n3);
                    int n6 = ((PGPCFBBlockCipher)object).blockSize - 2;
                    System.arraycopy(pGPCFBBlockCipher.FR, 2, pGPCFBBlockCipher.FR, 0, n6);
                    byte[] byArray4 = pGPCFBBlockCipher.FR;
                    PGPCFBBlockCipher pGPCFBBlockCipher3 = object;
                    n = pGPCFBBlockCipher3.blockSize;
                    n3 = n - 2;
                    byte[] byArray5 = pGPCFBBlockCipher3.tmp;
                    byArray4[n3] = byArray5[0];
                    pGPCFBBlockCipher.FR[--n] = pGPCFBBlockCipher3.tmp[1];
                    pGPCFBBlockCipher.cipher.processBlock(byArray4, 0, ((PGPCFBBlockCipher)object).FRE, 0);
                    for (n5 = 0; n5 < (n = ((PGPCFBBlockCipher)object).blockSize) - 2; ++n5) {
                        PGPCFBBlockCipher pGPCFBBlockCipher4 = object;
                        n = n2 + n5;
                        byArray2[n] = pGPCFBBlockCipher4.encryptByte(pGPCFBBlockCipher4.tmp[n5 + 2], n5);
                    }
                    PGPCFBBlockCipher pGPCFBBlockCipher5 = object;
                    Object object = ((PGPCFBBlockCipher)object).FR;
                    n5 = n - 2;
                    System.arraycopy(pGPCFBBlockCipher5.tmp, 2, object, 0, n5);
                    pGPCFBBlockCipher5.count += 2;
                    return pGPCFBBlockCipher5.blockSize - 2;
                }
                if (n4 >= n3 + 2) {
                    int n7;
                    PGPCFBBlockCipher pGPCFBBlockCipher = object;
                    PGPCFBBlockCipher pGPCFBBlockCipher6 = object;
                    PGPCFBBlockCipher pGPCFBBlockCipher7 = object;
                    System.arraycopy(byArray, n, ((PGPCFBBlockCipher)object).tmp, 0, n3);
                    int n8 = n2 + 0;
                    byArray2[n8] = pGPCFBBlockCipher7.encryptByte(pGPCFBBlockCipher7.tmp[0], ((PGPCFBBlockCipher)object).blockSize - 2);
                    n8 = n2 + 1;
                    byArray2[n8] = pGPCFBBlockCipher6.encryptByte(pGPCFBBlockCipher6.tmp[1], ((PGPCFBBlockCipher)object).blockSize - 1);
                    PGPCFBBlockCipher pGPCFBBlockCipher8 = object;
                    byte[] byArray6 = pGPCFBBlockCipher8.FR;
                    n = pGPCFBBlockCipher8.blockSize - 2;
                    System.arraycopy(pGPCFBBlockCipher.tmp, 0, byArray6, n, 2);
                    PGPCFBBlockCipher pGPCFBBlockCipher9 = object;
                    byArray6 = pGPCFBBlockCipher9.FR;
                    byte[] byArray7 = pGPCFBBlockCipher9.FRE;
                    pGPCFBBlockCipher.cipher.processBlock(byArray6, 0, byArray7, 0);
                    for (int k = 0; k < (n7 = ((PGPCFBBlockCipher)object).blockSize) - 2; ++k) {
                        Object object = object;
                        n7 = n2 + k + 2;
                        byArray2[n7] = super.encryptByte(((PGPCFBBlockCipher)object).tmp[k + 2], k);
                    }
                    byte[] byArray8 = ((PGPCFBBlockCipher)object).FR;
                    System.arraycopy(((PGPCFBBlockCipher)object).tmp, 2, byArray8, 0, n7 -= 2);
                }
                return ((PGPCFBBlockCipher)object).blockSize;
            }
            throw new OutputLengthException("output buffer too short");
        }
        throw new DataLengthException("input buffer too short");
    }

    private int encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = this.blockSize;
        if (n + n3 <= byArray.length) {
            if (n2 + n3 <= byArray2.length) {
                PGPCFBBlockCipher pGPCFBBlockCipher = this;
                byte[] byArray3 = pGPCFBBlockCipher.FR;
                byte[] byArray4 = pGPCFBBlockCipher.FRE;
                this.cipher.processBlock(byArray3, 0, byArray4, 0);
                for (int k = 0; k < this.blockSize; ++k) {
                    int n4 = n2 + k;
                    byArray2[n4] = this.encryptByte(byArray[n + k], k);
                }
                for (int k = 0; k < (n = this.blockSize); ++k) {
                    this.FR[k] = byArray2[n2 + k];
                }
                return n;
            }
            throw new OutputLengthException("output buffer too short");
        }
        throw new DataLengthException("input buffer too short");
    }

    private int decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = this.blockSize;
        if (n + n3 <= byArray.length) {
            if (n2 + n3 <= byArray2.length) {
                PGPCFBBlockCipher pGPCFBBlockCipher = this;
                byte[] byArray3 = pGPCFBBlockCipher.FR;
                byte[] byArray4 = pGPCFBBlockCipher.FRE;
                this.cipher.processBlock(byArray3, 0, byArray4, 0);
                for (int k = 0; k < this.blockSize; ++k) {
                    int n4 = n2 + k;
                    byArray2[n4] = this.encryptByte(byArray[n + k], k);
                }
                for (int k = 0; k < (n2 = this.blockSize); ++k) {
                    this.FR[k] = byArray[n + k];
                }
                return n2;
            }
            throw new OutputLengthException("output buffer too short");
        }
        throw new DataLengthException("input buffer too short");
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    @Override
    public String getAlgorithmName() {
        if (this.inlineIv) {
            return this.cipher.getAlgorithmName() + "/PGPCFBwithIV";
        }
        return this.cipher.getAlgorithmName() + "/PGPCFB";
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (this.inlineIv) {
            return this.forEncryption ? this.encryptBlockWithIV(byArray, n, byArray2, n2) : this.decryptBlockWithIV(byArray, n, byArray2, n2);
        }
        return this.forEncryption ? this.encryptBlock(byArray, n, byArray2, n2) : this.decryptBlock(byArray, n, byArray2, n2);
    }

    @Override
    public void reset() {
        this.count = 0;
        int n = 0;
        while (true) {
            byte[] byArray = this.FR;
            if (n == this.FR.length) break;
            byArray[n] = this.inlineIv ? (byte)0 : this.IV[n];
            ++n;
        }
        this.cipher.reset();
    }

    @Override
    public void init(boolean bl, CipherParameters object) {
        this.forEncryption = bl;
        if (object instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)object;
            byte[] byArray = parametersWithIV.getIV();
            object = byArray;
            byte[] byArray2 = this.IV;
            if (byArray.length < this.IV.length) {
                Object object2 = object;
                int n = byArray2.length - ((Object)object).length;
                int n2 = ((Object)object2).length;
                System.arraycopy(object2, 0, byArray2, n, n2);
                int n3 = 0;
                while (true) {
                    byte[] byArray3 = this.IV;
                    if (n3 < this.IV.length - ((Object)object).length) {
                        byArray3[n3] = 0;
                        ++n3;
                        continue;
                    }
                    break;
                }
            } else {
                int n = byArray2.length;
                System.arraycopy(object, 0, byArray2, 0, n);
            }
            PGPCFBBlockCipher pGPCFBBlockCipher = this;
            pGPCFBBlockCipher.reset();
            pGPCFBBlockCipher.cipher.init(true, parametersWithIV.getParameters());
        } else {
            PGPCFBBlockCipher pGPCFBBlockCipher = this;
            pGPCFBBlockCipher.reset();
            pGPCFBBlockCipher.cipher.init(true, (CipherParameters)object);
        }
    }
}

