/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHValidationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Properties;
import java.math.BigInteger;

public class DHParameters
implements CipherParameters {
    private static final int DEFAULT_MINIMUM_LENGTH = 160;
    private BigInteger g;
    private BigInteger p;
    private BigInteger q;
    private BigInteger j;
    private int m;
    private int l;
    private DHValidationParameters validation;

    private static int getDefaultMParam(int n) {
        if (n == 0) {
            return 160;
        }
        if (n >= 160) {
            n = 160;
        }
        return n;
    }

    public DHParameters(BigInteger bigInteger, BigInteger bigInteger2) {
        this(bigInteger, bigInteger2, null, 0);
    }

    public DHParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this(bigInteger, bigInteger2, bigInteger3, 0);
    }

    public DHParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n) {
        int n2 = DHParameters.getDefaultMParam(n);
        this(bigInteger, bigInteger2, bigInteger3, n2, n, null, null);
    }

    public DHParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n, int n2) {
        this(bigInteger, bigInteger2, bigInteger3, n, n2, null, null);
    }

    public DHParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, DHValidationParameters dHValidationParameters) {
        this(bigInteger, bigInteger2, bigInteger3, 160, 0, bigInteger4, dHValidationParameters);
    }

    public DHParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n, int n2, BigInteger bigInteger4, DHValidationParameters dHValidationParameters) {
        if (n2 != 0) {
            if (n2 <= bigInteger.bitLength()) {
                if (n2 < n) {
                    throw new IllegalArgumentException("when l value specified, it may not be less than m value");
                }
            } else {
                throw new IllegalArgumentException("when l value specified, it must satisfy 2^(l-1) <= p");
            }
        }
        if (n > bigInteger.bitLength() && !Properties.isOverrideSet("com.fis.ekyc.nfc.build_in.bouncycastle.dh.allow_unsafe_p_value")) {
            throw new IllegalArgumentException("unsafe p value so small specific l required");
        }
        DHParameters dHParameters = this;
        dHParameters.g = bigInteger2;
        dHParameters.p = bigInteger;
        dHParameters.q = bigInteger3;
        dHParameters.m = n;
        dHParameters.l = n2;
        dHParameters.j = bigInteger4;
        dHParameters.validation = dHValidationParameters;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getG() {
        return this.g;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getJ() {
        return this.j;
    }

    public int getM() {
        return this.m;
    }

    public int getL() {
        return this.l;
    }

    public DHValidationParameters getValidationParameters() {
        return this.validation;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DHParameters)) {
            return false;
        }
        object = (DHParameters)object;
        if (this.getQ() != null ? !this.getQ().equals(((DHParameters)object).getQ()) : ((DHParameters)object).getQ() != null) {
            return false;
        }
        return ((DHParameters)object).getP().equals(this.p) && ((DHParameters)object).getG().equals(this.g);
    }

    public int hashCode() {
        DHParameters dHParameters = this;
        int n = dHParameters.getP().hashCode() ^ this.getG().hashCode();
        int n2 = dHParameters.getQ() != null ? this.getQ().hashCode() : 0;
        return n ^ n2;
    }
}

