/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.EntropySource;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg.SP80090DRBG;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg.Utils;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;

public class CTRSP800DRBG
implements SP80090DRBG {
    private static final long TDEA_RESEED_MAX = 0x80000000L;
    private static final long AES_RESEED_MAX = 0x800000000000L;
    private static final int TDEA_MAX_BITS_REQUEST = 4096;
    private static final int AES_MAX_BITS_REQUEST = 262144;
    private static final byte[] K_BITS = Hex.decodeStrict("000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F");
    private EntropySource _entropySource;
    private BlockCipher _engine;
    private int _keySizeInBits;
    private int _seedLength;
    private int _securityStrength;
    private byte[] _Key;
    private byte[] _V;
    private long _reseedCounter = 0L;
    private boolean _isTDEA = false;

    public CTRSP800DRBG(BlockCipher blockCipher, int n, int n2, EntropySource entropySource, byte[] byArray, byte[] byArray2) {
        this._entropySource = entropySource;
        this._engine = blockCipher;
        this._keySizeInBits = n;
        this._securityStrength = n2;
        this._seedLength = blockCipher.getBlockSize() * 8 + n;
        this._isTDEA = this.isTDEA(blockCipher);
        if (n2 <= 256) {
            if (this.getMaxSecurityStrength(blockCipher, n) >= n2) {
                if (entropySource.entropySize() >= n2) {
                    CTRSP800DRBG cTRSP800DRBG = this;
                    cTRSP800DRBG.CTR_DRBG_Instantiate_algorithm(cTRSP800DRBG.getEntropy(), byArray2, byArray);
                    return;
                }
                throw new IllegalArgumentException("Not enough entropy for security strength required");
            }
            throw new IllegalArgumentException("Requested security strength is not supported by block cipher and key size");
        }
        throw new IllegalArgumentException("Requested security strength is not supported by the derivation function");
    }

    private void CTR_DRBG_Instantiate_algorithm(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        CTRSP800DRBG cTRSP800DRBG = object;
        byArray = Arrays.concatenate(byArray, byArray2, byArray3);
        byArray = cTRSP800DRBG.Block_Cipher_df(byArray, cTRSP800DRBG._seedLength);
        byte[] byArray4 = new byte[(((CTRSP800DRBG)object)._keySizeInBits + 7) / 8];
        Object object = byArray4;
        v2._Key = byArray4;
        byArray2 = new byte[cTRSP800DRBG._engine.getBlockSize()];
        cTRSP800DRBG._V = byArray2;
        cTRSP800DRBG.CTR_DRBG_Update(byArray, (byte[])object, byArray2);
        cTRSP800DRBG._reseedCounter = 1L;
    }

    private void CTR_DRBG_Update(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n;
        KeyParameter keyParameter;
        CTRSP800DRBG cTRSP800DRBG = this;
        int n2 = byArray.length;
        byte[] byArray4 = new byte[n2];
        byte[] byArray5 = new byte[cTRSP800DRBG._engine.getBlockSize()];
        int n3 = 0;
        int n4 = cTRSP800DRBG._engine.getBlockSize();
        KeyParameter keyParameter2 = keyParameter;
        keyParameter = new KeyParameter(this.expandKey(byArray2));
        cTRSP800DRBG._engine.init(true, keyParameter2);
        while ((n = n3 * n4) < byArray.length) {
            CTRSP800DRBG cTRSP800DRBG2 = this;
            cTRSP800DRBG2.addOneTo(byArray3);
            cTRSP800DRBG2._engine.processBlock(byArray3, 0, byArray5, 0);
            int n5 = n2 - n;
            if (n5 > n4) {
                n5 = n4;
            }
            System.arraycopy(byArray5, 0, byArray4, n, n5);
            ++n3;
        }
        this.XOR(byArray4, byArray, byArray4, 0);
        int n6 = byArray2.length;
        System.arraycopy(byArray4, 0, byArray2, 0, n6);
        n6 = byArray2.length;
        int n7 = byArray3.length;
        System.arraycopy(byArray4, n6, byArray3, 0, n7);
    }

    private void CTR_DRBG_Reseed_algorithm(byte[] byArray) {
        CTRSP800DRBG cTRSP800DRBG = object;
        Object object = Arrays.concatenate(cTRSP800DRBG.getEntropy(), byArray);
        object = cTRSP800DRBG.Block_Cipher_df((byte[])object, cTRSP800DRBG._seedLength);
        byArray = cTRSP800DRBG._Key;
        byte[] byArray2 = cTRSP800DRBG._V;
        cTRSP800DRBG.CTR_DRBG_Update((byte[])object, byArray, byArray2);
        cTRSP800DRBG._reseedCounter = 1L;
    }

    private void XOR(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        for (int k = 0; k < byArray.length; ++k) {
            byArray[k] = (byte)(byArray2[k] ^ byArray3[k + n]);
        }
    }

    private void addOneTo(byte[] byArray) {
        int n = 1;
        for (int k = 1; k <= byArray.length; ++k) {
            int n2 = (n = (byArray[byArray.length - k] & 0xFF) + n) > 255 ? 1 : 0;
            int n3 = n;
            n = byArray.length - k;
            byArray[n] = (byte)n3;
            n = n2;
        }
    }

    private byte[] getEntropy() {
        byte[] byArray = this._entropySource.getEntropy();
        if (byArray.length >= (this._securityStrength + 7) / 8) {
            return byArray;
        }
        throw new IllegalStateException("Insufficient entropy provided by entropy source");
    }

    private byte[] Block_Cipher_df(byte[] byArray, int n) {
        int n2;
        KeyParameter keyParameter;
        int n3;
        int n4;
        int n5 = n;
        n = this._engine.getBlockSize();
        int n6 = byArray.length;
        int n7 = n5 / 8;
        int n8 = n6 + 8;
        byte[] byArray2 = new byte[(n8 + 1 + n - 1) / n * n];
        Object object = byArray2;
        this.copyIntToByteArray((byte[])object, n6, 0);
        this.copyIntToByteArray((byte[])object, n7, 4);
        System.arraycopy(byArray, 0, object, 8, n6);
        byArray2[n8] = -128;
        int n9 = this._keySizeInBits;
        int n10 = n9;
        int n11 = n;
        n10 = n10 / 8 + n;
        byte[] byArray3 = new byte[n10];
        byte[] byArray4 = new byte[n11];
        byte[] byArray5 = new byte[n11];
        int n12 = 0;
        int n13 = n9 / 8;
        byte[] byArray6 = new byte[n13];
        System.arraycopy(K_BITS, 0, byArray6, 0, n13);
        while ((n4 = n12 * n) * 8 < n * 8 + (n3 = this._keySizeInBits)) {
            CTRSP800DRBG cTRSP800DRBG = this;
            cTRSP800DRBG.copyIntToByteArray(byArray5, n12, 0);
            cTRSP800DRBG.BCC(byArray4, byArray6, byArray5, (byte[])object);
            n3 = n10 - n4;
            if (n3 > n) {
                n3 = n;
            }
            System.arraycopy(byArray4, 0, byArray3, n4, n3);
            ++n12;
        }
        byte[] byArray7 = new byte[n];
        System.arraycopy(byArray3, 0, byArray6, 0, n13);
        System.arraycopy(byArray3, n13, byArray7, 0, n);
        byArray3 = new byte[n7];
        int n14 = 0;
        object = keyParameter;
        keyParameter = new KeyParameter(this.expandKey(byArray6));
        this._engine.init(true, (CipherParameters)object);
        while ((n2 = n14 * n) < n7) {
            this._engine.processBlock(byArray7, 0, byArray7, 0);
            int n15 = n7 - n2;
            if (n15 > n) {
                n15 = n;
            }
            System.arraycopy(byArray7, 0, byArray3, n2, n15);
            ++n14;
        }
        return byArray3;
    }

    private void BCC(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        KeyParameter keyParameter;
        CTRSP800DRBG cTRSP800DRBG = this;
        int n = cTRSP800DRBG._engine.getBlockSize();
        byte[] byArray5 = new byte[n];
        int n2 = byArray4.length / n;
        byte[] byArray6 = new byte[n];
        KeyParameter keyParameter2 = keyParameter;
        keyParameter = new KeyParameter(this.expandKey(byArray2));
        cTRSP800DRBG._engine.init(true, keyParameter2);
        cTRSP800DRBG._engine.processBlock(byArray3, 0, byArray5, 0);
        for (int k = 0; k < n2; ++k) {
            CTRSP800DRBG cTRSP800DRBG2 = this;
            int n3 = k * n;
            cTRSP800DRBG2.XOR(byArray6, byArray5, byArray4, n3);
            cTRSP800DRBG2._engine.processBlock(byArray6, 0, byArray5, 0);
        }
        int n4 = byArray.length;
        System.arraycopy(byArray5, 0, byArray, 0, n4);
    }

    private void copyIntToByteArray(byte[] byArray, int n, int n2) {
        int n3 = n2 + 0;
        byArray[n3] = (byte)(n >> 24);
        n3 = n2 + 1;
        byArray[n3] = (byte)(n >> 16);
        n3 = n2 + 2;
        byArray[n3] = (byte)(n >> 8);
        n3 = n2 + 3;
        byArray[n3] = (byte)n;
    }

    private boolean isTDEA(BlockCipher blockCipher) {
        return blockCipher.getAlgorithmName().equals("DESede") || blockCipher.getAlgorithmName().equals("TDEA");
    }

    private int getMaxSecurityStrength(BlockCipher blockCipher, int n) {
        if (this.isTDEA(blockCipher) && n == 168) {
            return 112;
        }
        if (blockCipher.getAlgorithmName().equals("AES")) {
            return n;
        }
        return -1;
    }

    private void padKey(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n2 + 0;
        int n4 = n + 0;
        byArray2[n3] = (byte)(byArray[n4] & 0xFE);
        n3 = n2 + 1;
        int n5 = byArray[n4] << 7;
        n4 = n + 1;
        byArray2[n3] = (byte)(n5 | (byArray[n4] & 0xFC) >>> 1);
        n3 = n2 + 2;
        int n6 = byArray[n4] << 6;
        n4 = n + 2;
        byArray2[n3] = (byte)(n6 | (byArray[n4] & 0xF8) >>> 2);
        n3 = n2 + 3;
        int n7 = byArray[n4] << 5;
        n4 = n + 3;
        byArray2[n3] = (byte)(n7 | (byArray[n4] & 0xF0) >>> 3);
        n3 = n2 + 4;
        int n8 = byArray[n4] << 4;
        n4 = n + 4;
        byArray2[n3] = (byte)(n8 | (byArray[n4] & 0xE0) >>> 4);
        n3 = n2 + 5;
        int n9 = byArray[n4] << 3;
        n4 = n + 5;
        byArray2[n3] = (byte)(n9 | (byArray[n4] & 0xC0) >>> 5);
        n3 = n2 + 6;
        int n10 = n + 6;
        byArray2[n3] = (byte)(byArray[n4] << 2 | (byArray[n10] & 0x80) >>> 6);
        n3 = n2 + 7;
        byArray2[n3] = (byte)(byArray[n10] << 1);
        while (n2 <= n3) {
            n10 = byArray2[n2];
            byArray2[n2] = (byte)(n10 & 0xFE | (n10 >> 1 ^ n10 >> 2 ^ n10 >> 3 ^ n10 >> 4 ^ n10 >> 5 ^ n10 >> 6 ^ n10 >> 7 ^ 1) & 1);
            ++n2;
        }
    }

    @Override
    public int getBlockSize() {
        return this._V.length * 8;
    }

    @Override
    public int generate(byte[] byArray, byte[] byArray2, boolean bl) {
        block13: {
            KeyParameter keyParameter;
            byte[] byArray3;
            block12: {
                block11: {
                    if (!((CTRSP800DRBG)object)._isTDEA) break block11;
                    if (((CTRSP800DRBG)object)._reseedCounter > 0x80000000L) {
                        return -1;
                    }
                    if (Utils.isTooLarge(byArray, 512)) {
                        throw new IllegalArgumentException("Number of bits per request limited to 4096");
                    }
                    break block12;
                }
                if (((CTRSP800DRBG)object)._reseedCounter > 0x800000000000L) {
                    return -1;
                }
                if (Utils.isTooLarge(byArray, 32768)) break block13;
            }
            if (bl) {
                ((CTRSP800DRBG)object).CTR_DRBG_Reseed_algorithm(byArray2);
                byArray2 = null;
            }
            if (byArray2 != null) {
                CTRSP800DRBG cTRSP800DRBG = object;
                byArray2 = cTRSP800DRBG.Block_Cipher_df(byArray2, cTRSP800DRBG._seedLength);
                byte[] byArray4 = cTRSP800DRBG._Key;
                byArray3 = cTRSP800DRBG._V;
                cTRSP800DRBG.CTR_DRBG_Update(byArray2, byArray4, byArray3);
            } else {
                byArray2 = new byte[((CTRSP800DRBG)object)._seedLength / 8];
            }
            CTRSP800DRBG cTRSP800DRBG = object;
            int n = cTRSP800DRBG._V.length;
            byArray3 = new byte[n];
            KeyParameter keyParameter2 = keyParameter;
            CTRSP800DRBG cTRSP800DRBG2 = object;
            keyParameter = new KeyParameter(cTRSP800DRBG2.expandKey(cTRSP800DRBG2._Key));
            cTRSP800DRBG._engine.init(true, keyParameter2);
            for (int k = 0; k <= byArray.length / n; ++k) {
                int n2 = k * n;
                int n3 = byArray.length - n2 > n ? n : byArray.length - k * ((CTRSP800DRBG)object)._V.length;
                if (n3 == 0) continue;
                Object object = object;
                super.addOneTo(((CTRSP800DRBG)object)._V);
                ((CTRSP800DRBG)object)._engine.processBlock(((CTRSP800DRBG)object)._V, 0, byArray3, 0);
                System.arraycopy(byArray3, 0, byArray, n2, n3);
            }
            CTRSP800DRBG cTRSP800DRBG3 = object;
            CTRSP800DRBG cTRSP800DRBG4 = object;
            Object object = cTRSP800DRBG4._Key;
            cTRSP800DRBG3.CTR_DRBG_Update(byArray2, (byte[])object, cTRSP800DRBG4._V);
            ++cTRSP800DRBG3._reseedCounter;
            return byArray.length * 8;
        }
        throw new IllegalArgumentException("Number of bits per request limited to 262144");
    }

    @Override
    public void reseed(byte[] byArray) {
        this.CTR_DRBG_Reseed_algorithm(byArray);
    }

    public byte[] expandKey(byte[] byArray) {
        if (this._isTDEA) {
            byte[] byArray2 = new byte[24];
            CTRSP800DRBG cTRSP800DRBG = this;
            cTRSP800DRBG.padKey(byArray, 0, byArray2, 0);
            cTRSP800DRBG.padKey(byArray, 7, byArray2, 8);
            cTRSP800DRBG.padKey(byArray, 14, byArray2, 16);
            return byArray2;
        }
        return byArray;
    }
}

