/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ec;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DSAExt;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.NullDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.RIPEMD160Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSAEncoding;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.ECDSASigner;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.ECNRSigner;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.HMacDSAKCalculator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.PlainDSAEncoding;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.StandardDSAEncoding;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ec.ECUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.DSABase;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import java.security.AlgorithmParameters;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;

public class SignatureSpi
extends DSABase {
    public SignatureSpi(Digest digest, DSAExt dSAExt, DSAEncoding dSAEncoding) {
        super(digest, dSAExt, dSAEncoding);
    }

    @Override
    public void engineInitVerify(PublicKey publicKey) {
        SignatureSpi signatureSpi = asymmetricKeyParameter;
        AsymmetricKeyParameter asymmetricKeyParameter = ECUtils.generatePublicKeyParameter(publicKey);
        signatureSpi.digest.reset();
        signatureSpi.signer.init(false, asymmetricKeyParameter);
    }

    @Override
    public void engineInitSign(PrivateKey object) {
        SignatureSpi signatureSpi = parametersWithRandom2;
        object = ECUtil.generatePrivateKeyParameter((PrivateKey)object);
        signatureSpi.digest.reset();
        SecureRandom secureRandom = signatureSpi.appRandom;
        if (secureRandom != null) {
            ParametersWithRandom parametersWithRandom;
            ParametersWithRandom parametersWithRandom2 = parametersWithRandom;
            parametersWithRandom = new ParametersWithRandom((CipherParameters)object, secureRandom);
            ((DSABase)((Object)parametersWithRandom2)).signer.init(true, parametersWithRandom2);
        } else {
            ((DSABase)((Object)parametersWithRandom2)).signer.init(true, (CipherParameters)object);
        }
    }

    @Override
    public AlgorithmParameters engineGetParameters() {
        return null;
    }

    public static class ecPlainDSARP160
    extends SignatureSpi {
        public ecPlainDSARP160() {
            ECDSASigner eCDSASigner;
            RIPEMD160Digest rIPEMD160Digest;
            ecPlainDSARP160 ecPlainDSARP1602 = rIPEMD160Digest2;
            RIPEMD160Digest rIPEMD160Digest2 = rIPEMD160Digest;
            rIPEMD160Digest = new RIPEMD160Digest();
            ECDSASigner eCDSASigner2 = eCDSASigner;
            eCDSASigner = new ECDSASigner();
            PlainDSAEncoding plainDSAEncoding = PlainDSAEncoding.INSTANCE;
            super(rIPEMD160Digest2, eCDSASigner2, plainDSAEncoding);
        }
    }

    public static class ecCVCDSA512
    extends SignatureSpi {
        public ecCVCDSA512() {
            ECDSASigner eCDSASigner;
            ecCVCDSA512 ecCVCDSA5122 = digest;
            Digest digest = DigestFactory.createSHA512();
            ECDSASigner eCDSASigner2 = eCDSASigner;
            eCDSASigner = new ECDSASigner();
            PlainDSAEncoding plainDSAEncoding = PlainDSAEncoding.INSTANCE;
            super(digest, eCDSASigner2, plainDSAEncoding);
        }
    }

    public static class ecCVCDSA384
    extends SignatureSpi {
        public ecCVCDSA384() {
            ECDSASigner eCDSASigner;
            ecCVCDSA384 ecCVCDSA3842 = digest;
            Digest digest = DigestFactory.createSHA384();
            ECDSASigner eCDSASigner2 = eCDSASigner;
            eCDSASigner = new ECDSASigner();
            PlainDSAEncoding plainDSAEncoding = PlainDSAEncoding.INSTANCE;
            super(digest, eCDSASigner2, plainDSAEncoding);
        }
    }

    public static class ecCVCDSA256
    extends SignatureSpi {
        public ecCVCDSA256() {
            ECDSASigner eCDSASigner;
            ecCVCDSA256 ecCVCDSA2562 = digest;
            Digest digest = DigestFactory.createSHA256();
            ECDSASigner eCDSASigner2 = eCDSASigner;
            eCDSASigner = new ECDSASigner();
            PlainDSAEncoding plainDSAEncoding = PlainDSAEncoding.INSTANCE;
            super(digest, eCDSASigner2, plainDSAEncoding);
        }
    }

    public static class ecCVCDSA224
    extends SignatureSpi {
        public ecCVCDSA224() {
            ECDSASigner eCDSASigner;
            ecCVCDSA224 ecCVCDSA2242 = digest;
            Digest digest = DigestFactory.createSHA224();
            ECDSASigner eCDSASigner2 = eCDSASigner;
            eCDSASigner = new ECDSASigner();
            PlainDSAEncoding plainDSAEncoding = PlainDSAEncoding.INSTANCE;
            super(digest, eCDSASigner2, plainDSAEncoding);
        }
    }

    public static class ecCVCDSA
    extends SignatureSpi {
        public ecCVCDSA() {
            ECDSASigner eCDSASigner;
            ecCVCDSA ecCVCDSA2 = digest;
            Digest digest = DigestFactory.createSHA1();
            ECDSASigner eCDSASigner2 = eCDSASigner;
            eCDSASigner = new ECDSASigner();
            PlainDSAEncoding plainDSAEncoding = PlainDSAEncoding.INSTANCE;
            super(digest, eCDSASigner2, plainDSAEncoding);
        }
    }

    public static class ecNR512
    extends SignatureSpi {
        public ecNR512() {
            ECNRSigner eCNRSigner;
            ecNR512 ecNR5122 = digest;
            Digest digest = DigestFactory.createSHA512();
            ECNRSigner eCNRSigner2 = eCNRSigner;
            eCNRSigner = new ECNRSigner();
            StandardDSAEncoding standardDSAEncoding = StandardDSAEncoding.INSTANCE;
            super(digest, eCNRSigner2, standardDSAEncoding);
        }
    }

    public static class ecNR384
    extends SignatureSpi {
        public ecNR384() {
            ECNRSigner eCNRSigner;
            ecNR384 ecNR3842 = digest;
            Digest digest = DigestFactory.createSHA384();
            ECNRSigner eCNRSigner2 = eCNRSigner;
            eCNRSigner = new ECNRSigner();
            StandardDSAEncoding standardDSAEncoding = StandardDSAEncoding.INSTANCE;
            super(digest, eCNRSigner2, standardDSAEncoding);
        }
    }

    public static class ecNR256
    extends SignatureSpi {
        public ecNR256() {
            ECNRSigner eCNRSigner;
            ecNR256 ecNR2562 = digest;
            Digest digest = DigestFactory.createSHA256();
            ECNRSigner eCNRSigner2 = eCNRSigner;
            eCNRSigner = new ECNRSigner();
            StandardDSAEncoding standardDSAEncoding = StandardDSAEncoding.INSTANCE;
            super(digest, eCNRSigner2, standardDSAEncoding);
        }
    }

    public static class ecNR224
    extends SignatureSpi {
        public ecNR224() {
            ECNRSigner eCNRSigner;
            ecNR224 ecNR2242 = digest;
            Digest digest = DigestFactory.createSHA224();
            ECNRSigner eCNRSigner2 = eCNRSigner;
            eCNRSigner = new ECNRSigner();
            StandardDSAEncoding standardDSAEncoding = StandardDSAEncoding.INSTANCE;
            super(digest, eCNRSigner2, standardDSAEncoding);
        }
    }

    public static class ecNR
    extends SignatureSpi {
        public ecNR() {
            ECNRSigner eCNRSigner;
            ecNR ecNR2 = digest;
            Digest digest = DigestFactory.createSHA1();
            ECNRSigner eCNRSigner2 = eCNRSigner;
            eCNRSigner = new ECNRSigner();
            StandardDSAEncoding standardDSAEncoding = StandardDSAEncoding.INSTANCE;
            super(digest, eCNRSigner2, standardDSAEncoding);
        }
    }

    public static class ecDSARipeMD160
    extends SignatureSpi {
        public ecDSARipeMD160() {
            ECDSASigner eCDSASigner;
            RIPEMD160Digest rIPEMD160Digest;
            ecDSARipeMD160 ecDSARipeMD1602 = rIPEMD160Digest2;
            RIPEMD160Digest rIPEMD160Digest2 = rIPEMD160Digest;
            rIPEMD160Digest = new RIPEMD160Digest();
            ECDSASigner eCDSASigner2 = eCDSASigner;
            eCDSASigner = new ECDSASigner();
            StandardDSAEncoding standardDSAEncoding = StandardDSAEncoding.INSTANCE;
            super(rIPEMD160Digest2, eCDSASigner2, standardDSAEncoding);
        }
    }

    public static class ecDetDSASha3_512
    extends SignatureSpi {
        public ecDetDSASha3_512() {
            super(DigestFactory.createSHA3_512(), new ECDSASigner(new HMacDSAKCalculator(DigestFactory.createSHA3_512())), StandardDSAEncoding.INSTANCE);
        }
    }

    public static class ecDSASha3_512
    extends SignatureSpi {
        public ecDSASha3_512() {
            ECDSASigner eCDSASigner;
            ecDSASha3_512 ecDSASha3_5122 = digest;
            Digest digest = DigestFactory.createSHA3_512();
            ECDSASigner eCDSASigner2 = eCDSASigner;
            eCDSASigner = new ECDSASigner();
            StandardDSAEncoding standardDSAEncoding = StandardDSAEncoding.INSTANCE;
            super(digest, eCDSASigner2, standardDSAEncoding);
        }
    }

    public static class ecDetDSASha3_384
    extends SignatureSpi {
        public ecDetDSASha3_384() {
            super(DigestFactory.createSHA3_384(), new ECDSASigner(new HMacDSAKCalculator(DigestFactory.createSHA3_384())), StandardDSAEncoding.INSTANCE);
        }
    }

    public static class ecDSASha3_384
    extends SignatureSpi {
        public ecDSASha3_384() {
            ECDSASigner eCDSASigner;
            ecDSASha3_384 ecDSASha3_3842 = digest;
            Digest digest = DigestFactory.createSHA3_384();
            ECDSASigner eCDSASigner2 = eCDSASigner;
            eCDSASigner = new ECDSASigner();
            StandardDSAEncoding standardDSAEncoding = StandardDSAEncoding.INSTANCE;
            super(digest, eCDSASigner2, standardDSAEncoding);
        }
    }

    public static class ecDetDSASha3_256
    extends SignatureSpi {
        public ecDetDSASha3_256() {
            super(DigestFactory.createSHA3_256(), new ECDSASigner(new HMacDSAKCalculator(DigestFactory.createSHA3_256())), StandardDSAEncoding.INSTANCE);
        }
    }

    public static class ecDSASha3_256
    extends SignatureSpi {
        public ecDSASha3_256() {
            ECDSASigner eCDSASigner;
            ecDSASha3_256 ecDSASha3_2562 = digest;
            Digest digest = DigestFactory.createSHA3_256();
            ECDSASigner eCDSASigner2 = eCDSASigner;
            eCDSASigner = new ECDSASigner();
            StandardDSAEncoding standardDSAEncoding = StandardDSAEncoding.INSTANCE;
            super(digest, eCDSASigner2, standardDSAEncoding);
        }
    }

    public static class ecDetDSASha3_224
    extends SignatureSpi {
        public ecDetDSASha3_224() {
            super(DigestFactory.createSHA3_224(), new ECDSASigner(new HMacDSAKCalculator(DigestFactory.createSHA3_224())), StandardDSAEncoding.INSTANCE);
        }
    }

    public static class ecDSASha3_224
    extends SignatureSpi {
        public ecDSASha3_224() {
            ECDSASigner eCDSASigner;
            ecDSASha3_224 ecDSASha3_2242 = digest;
            Digest digest = DigestFactory.createSHA3_224();
            ECDSASigner eCDSASigner2 = eCDSASigner;
            eCDSASigner = new ECDSASigner();
            StandardDSAEncoding standardDSAEncoding = StandardDSAEncoding.INSTANCE;
            super(digest, eCDSASigner2, standardDSAEncoding);
        }
    }

    public static class ecDetDSA512
    extends SignatureSpi {
        public ecDetDSA512() {
            super(DigestFactory.createSHA512(), new ECDSASigner(new HMacDSAKCalculator(DigestFactory.createSHA512())), StandardDSAEncoding.INSTANCE);
        }
    }

    public static class ecDSA512
    extends SignatureSpi {
        public ecDSA512() {
            ECDSASigner eCDSASigner;
            ecDSA512 ecDSA5122 = digest;
            Digest digest = DigestFactory.createSHA512();
            ECDSASigner eCDSASigner2 = eCDSASigner;
            eCDSASigner = new ECDSASigner();
            StandardDSAEncoding standardDSAEncoding = StandardDSAEncoding.INSTANCE;
            super(digest, eCDSASigner2, standardDSAEncoding);
        }
    }

    public static class ecDetDSA384
    extends SignatureSpi {
        public ecDetDSA384() {
            super(DigestFactory.createSHA384(), new ECDSASigner(new HMacDSAKCalculator(DigestFactory.createSHA384())), StandardDSAEncoding.INSTANCE);
        }
    }

    public static class ecDSA384
    extends SignatureSpi {
        public ecDSA384() {
            ECDSASigner eCDSASigner;
            ecDSA384 ecDSA3842 = digest;
            Digest digest = DigestFactory.createSHA384();
            ECDSASigner eCDSASigner2 = eCDSASigner;
            eCDSASigner = new ECDSASigner();
            StandardDSAEncoding standardDSAEncoding = StandardDSAEncoding.INSTANCE;
            super(digest, eCDSASigner2, standardDSAEncoding);
        }
    }

    public static class ecDetDSA256
    extends SignatureSpi {
        public ecDetDSA256() {
            super(DigestFactory.createSHA256(), new ECDSASigner(new HMacDSAKCalculator(DigestFactory.createSHA256())), StandardDSAEncoding.INSTANCE);
        }
    }

    public static class ecDSA256
    extends SignatureSpi {
        public ecDSA256() {
            ECDSASigner eCDSASigner;
            ecDSA256 ecDSA2562 = digest;
            Digest digest = DigestFactory.createSHA256();
            ECDSASigner eCDSASigner2 = eCDSASigner;
            eCDSASigner = new ECDSASigner();
            StandardDSAEncoding standardDSAEncoding = StandardDSAEncoding.INSTANCE;
            super(digest, eCDSASigner2, standardDSAEncoding);
        }
    }

    public static class ecDetDSA224
    extends SignatureSpi {
        public ecDetDSA224() {
            super(DigestFactory.createSHA224(), new ECDSASigner(new HMacDSAKCalculator(DigestFactory.createSHA224())), StandardDSAEncoding.INSTANCE);
        }
    }

    public static class ecDSA224
    extends SignatureSpi {
        public ecDSA224() {
            ECDSASigner eCDSASigner;
            ecDSA224 ecDSA2242 = digest;
            Digest digest = DigestFactory.createSHA224();
            ECDSASigner eCDSASigner2 = eCDSASigner;
            eCDSASigner = new ECDSASigner();
            StandardDSAEncoding standardDSAEncoding = StandardDSAEncoding.INSTANCE;
            super(digest, eCDSASigner2, standardDSAEncoding);
        }
    }

    public static class ecDSAnone
    extends SignatureSpi {
        public ecDSAnone() {
            ECDSASigner eCDSASigner;
            NullDigest nullDigest;
            ecDSAnone ecDSAnone2 = nullDigest2;
            NullDigest nullDigest2 = nullDigest;
            nullDigest = new NullDigest();
            ECDSASigner eCDSASigner2 = eCDSASigner;
            eCDSASigner = new ECDSASigner();
            StandardDSAEncoding standardDSAEncoding = StandardDSAEncoding.INSTANCE;
            super(nullDigest2, eCDSASigner2, standardDSAEncoding);
        }
    }

    public static class ecDetDSA
    extends SignatureSpi {
        public ecDetDSA() {
            super(DigestFactory.createSHA1(), new ECDSASigner(new HMacDSAKCalculator(DigestFactory.createSHA1())), StandardDSAEncoding.INSTANCE);
        }
    }

    public static class ecDSA
    extends SignatureSpi {
        public ecDSA() {
            ECDSASigner eCDSASigner;
            ecDSA ecDSA2 = digest;
            Digest digest = DigestFactory.createSHA1();
            ECDSASigner eCDSASigner2 = eCDSASigner;
            eCDSASigner = new ECDSASigner();
            StandardDSAEncoding standardDSAEncoding = StandardDSAEncoding.INSTANCE;
            super(digest, eCDSASigner2, standardDSAEncoding);
        }
    }
}

