/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Enumerated;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.util.ASN1Dump;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.CRLReason;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extension;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralName;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralNames;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.TBSCertList;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class X509CRLEntryObject
extends X509CRLEntry {
    private TBSCertList.CRLEntry c;
    private X500Name certificateIssuer;
    private volatile boolean hashValueSet;
    private volatile int hashValue;

    public X509CRLEntryObject(TBSCertList.CRLEntry cRLEntry) {
        this.c = cRLEntry;
        this.certificateIssuer = null;
    }

    public X509CRLEntryObject(TBSCertList.CRLEntry cRLEntry, boolean bl, X500Name x500Name) {
        this.c = cRLEntry;
        this.certificateIssuer = this.loadCertificateIssuer(bl, x500Name);
    }

    private X500Name loadCertificateIssuer(boolean n, X500Name x500Name) {
        if (n == 0) {
            return null;
        }
        if ((generalNameArray = generalNameArray.getExtension(Extension.certificateIssuer)) == null) {
            return x500Name;
        }
        try {
            GeneralName[] generalNameArray = GeneralNames.getInstance(generalNameArray.getParsedValue()).getNames();
            n = 0;
        }
        catch (Exception exception) {
            return null;
        }
        while (true) {
            block8: {
                if (n >= generalNameArray.length) break;
                if (generalNameArray[n].getTagNo() != 4) break block8;
                return X500Name.getInstance(generalNameArray[n].getName());
            }
            ++n;
        }
        return null;
    }

    private Set getExtensionOIDs(boolean bl) {
        Extensions extensions = ((X509CRLEntryObject)((Object)extensions)).c.getExtensions();
        if (extensions != null) {
            HashSet<String> hashSet;
            HashSet<String> hashSet2 = hashSet;
            hashSet = new HashSet<String>();
            Enumeration enumeration = extensions.oids();
            while (enumeration.hasMoreElements()) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                if (bl != extensions.getExtension(aSN1ObjectIdentifier).isCritical()) continue;
                hashSet2.add(aSN1ObjectIdentifier.getId());
            }
            return hashSet2;
        }
        return null;
    }

    private Extension getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Extensions extensions = ((X509CRLEntryObject)((Object)extensions)).c.getExtensions();
        if (extensions != null) {
            return extensions.getExtension(aSN1ObjectIdentifier);
        }
        return null;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return (this = ((X509CRLEntryObject)this).getCriticalExtensionOIDs()) != null && !this.isEmpty();
    }

    @Override
    public X500Principal getCertificateIssuer() {
        if (this.certificateIssuer == null) {
            return null;
        }
        try {
            return new X500Principal(this.certificateIssuer.getEncoded());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    @Override
    public byte[] getExtensionValue(String string) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        X509CRLEntryObject x509CRLEntryObject = object;
        Object object = aSN1ObjectIdentifier;
        aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string);
        if ((object = x509CRLEntryObject.getExtension((ASN1ObjectIdentifier)object)) != null) {
            try {
                return ((Extension)object).getExtnValue().getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException(d.a(exception, b.a("Exception encoding: ")));
            }
        }
        return null;
    }

    @Override
    public int hashCode() {
        if (!this.hashValueSet) {
            this.hashValue = super.hashCode();
            this.hashValueSet = true;
        }
        return this.hashValue;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof X509CRLEntryObject) {
            object = (X509CRLEntryObject)object;
            if (this.hashValueSet && ((X509CRLEntryObject)object).hashValueSet && this.hashValue != ((X509CRLEntryObject)object).hashValue) {
                return false;
            }
            return this.c.equals(((X509CRLEntryObject)object).c);
        }
        X509CRLEntryObject x509CRLEntryObject = this;
        return super.equals(x509CRLEntryObject);
    }

    @Override
    public byte[] getEncoded() {
        try {
            return this.c.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(((Object)iOException).toString());
        }
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.c.getUserCertificate().getValue();
    }

    @Override
    public Date getRevocationDate() {
        return this.c.getRevocationDate().getDate();
    }

    @Override
    public boolean hasExtensions() {
        return this.c.getExtensions() != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String toString() {
        Enumeration enumeration;
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        String string = Strings.lineSeparator();
        new StringBuffer().append("      userCertificate: ").append(((X509CRLEntryObject)((Object)extensions)).getSerialNumber()).append(string);
        stringBuffer2.append("       revocationDate: ").append(((X509CRLEntryObject)((Object)extensions)).getRevocationDate()).append(string);
        stringBuffer2.append("       certificateIssuer: ").append(((X509CRLEntryObject)((Object)extensions)).getCertificateIssuer()).append(string);
        Extensions extensions = ((X509CRLEntryObject)((Object)extensions)).c.getExtensions();
        if (extensions != null && (enumeration = extensions.oids()).hasMoreElements()) {
            stringBuffer2.append("   crlEntryExtensions:").append(string);
            while (enumeration.hasMoreElements()) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                Extension extension = extensions.getExtension(aSN1ObjectIdentifier);
                if (extension.getExtnValue() != null) {
                    ASN1InputStream aSN1InputStream;
                    byte[] byArray = extension.getExtnValue().getOctets();
                    ASN1InputStream aSN1InputStream2 = aSN1InputStream;
                    aSN1InputStream = new ASN1InputStream(byArray);
                    stringBuffer2.append("                       critical(").append(extension.isCritical()).append(") ");
                    try {
                        StringBuffer stringBuffer3;
                        if (aSN1ObjectIdentifier.equals(Extension.reasonCode)) {
                            stringBuffer3 = stringBuffer2.append(CRLReason.getInstance(ASN1Enumerated.getInstance(aSN1InputStream2.readObject())));
                        } else if (aSN1ObjectIdentifier.equals(Extension.certificateIssuer)) {
                            stringBuffer3 = stringBuffer2.append("Certificate issuer: ").append(GeneralNames.getInstance(aSN1InputStream2.readObject()));
                        } else {
                            StringBuffer stringBuffer4 = stringBuffer2;
                            stringBuffer4.append(aSN1ObjectIdentifier.getId());
                            stringBuffer3 = stringBuffer4.append(" value = ").append(ASN1Dump.dumpAsString(aSN1InputStream2.readObject()));
                        }
                        stringBuffer3.append(string);
                    }
                    catch (Exception exception) {
                        StringBuffer stringBuffer5 = stringBuffer2;
                        stringBuffer5.append(aSN1ObjectIdentifier.getId());
                        stringBuffer5.append(" value = ").append("*****").append(string);
                    }
                    continue;
                }
                stringBuffer2.append(string);
            }
        }
        return stringBuffer2.toString();
    }
}

