/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.endo.EndoUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.endo.GLVEndomorphism;
import java.math.BigInteger;

public class GLVMultiplier
extends AbstractECMultiplier {
    public final ECCurve curve;
    public final GLVEndomorphism glvEndomorphism;

    public GLVMultiplier(ECCurve eCCurve, GLVEndomorphism gLVEndomorphism) {
        if (eCCurve != null && eCCurve.getOrder() != null) {
            GLVMultiplier gLVMultiplier = this;
            gLVMultiplier.curve = eCCurve;
            gLVMultiplier.glvEndomorphism = gLVEndomorphism;
            return;
        }
        throw new IllegalArgumentException("Need curve with known group order");
    }

    @Override
    public ECPoint multiplyPositive(ECPoint eCPoint, BigInteger bigInteger) {
        if (this.curve.equals(eCPoint.getCurve())) {
            GLVMultiplier gLVMultiplier = this;
            BigInteger bigInteger2 = eCPoint.getCurve().getOrder();
            BigInteger[] bigIntegerArray = gLVMultiplier.glvEndomorphism.decomposeScalar(bigInteger.mod(bigInteger2));
            bigInteger = bigIntegerArray[0];
            bigInteger2 = bigIntegerArray[1];
            if (gLVMultiplier.glvEndomorphism.hasEfficientPointMap()) {
                return ECAlgorithms.implShamirsTrickWNaf(this.glvEndomorphism, eCPoint, bigInteger, bigInteger2);
            }
            return ECAlgorithms.implShamirsTrickWNaf(eCPoint, bigInteger, EndoUtil.mapPoint(this.glvEndomorphism, eCPoint), bigInteger2);
        }
        throw new IllegalStateException();
    }
}

