/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Interleave;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import java.math.BigInteger;

public class SecT233Field {
    private static final long M41 = 0x1FFFFFFFFFFL;
    private static final long M59 = 0x7FFFFFFFFFFFFFFL;

    public static void add(long[] lArray, long[] lArray2, long[] lArray3) {
        long l;
        long l2;
        lArray3[0] = l2 = lArray[0] ^ lArray2[0];
        lArray3[1] = l2 = lArray[1] ^ lArray2[1];
        lArray3[2] = l2 = lArray[2] ^ lArray2[2];
        lArray3[3] = l = lArray[3] ^ lArray2[3];
    }

    public static void addExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long l;
        long l2;
        lArray3[0] = l2 = lArray[0] ^ lArray2[0];
        lArray3[1] = l2 = lArray[1] ^ lArray2[1];
        lArray3[2] = l2 = lArray[2] ^ lArray2[2];
        lArray3[3] = l2 = lArray[3] ^ lArray2[3];
        lArray3[4] = l2 = lArray[4] ^ lArray2[4];
        lArray3[5] = l2 = lArray[5] ^ lArray2[5];
        lArray3[6] = l2 = lArray[6] ^ lArray2[6];
        lArray3[7] = l = lArray[7] ^ lArray2[7];
    }

    public static void addOne(long[] lArray, long[] lArray2) {
        long l;
        lArray2[0] = l = lArray[0] ^ 1L;
        lArray2[1] = l = lArray[1];
        lArray2[2] = l = lArray[2];
        lArray2[3] = l = lArray[3];
    }

    private static void addTo(long[] lArray, long[] lArray2) {
        long l;
        long l2;
        long[] lArray3 = lArray2;
        lArray3[0] = l2 = lArray2[0] ^ lArray[0];
        lArray3[1] = l2 = lArray2[1] ^ lArray[1];
        lArray3[2] = l2 = lArray2[2] ^ lArray[2];
        lArray3[3] = l = lArray2[3] ^ lArray[3];
    }

    public static long[] fromBigInteger(BigInteger bigInteger) {
        return Nat.fromBigInteger64(233, bigInteger);
    }

    public static void halfTrace(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        Nat256.copy64(lArray, lArray2);
        for (int k = 1; k < 233; k += 2) {
            SecT233Field.implSquare(lArray2, lArray3);
            SecT233Field.reduce(lArray3, lArray2);
            SecT233Field.implSquare(lArray2, lArray3);
            SecT233Field.reduce(lArray3, lArray2);
            SecT233Field.addTo(lArray, lArray2);
        }
    }

    public static void invert(long[] lArray, long[] lArray2) {
        if (!Nat256.isZero64(lArray)) {
            long[] lArray3;
            long[] lArray4 = Nat256.create64();
            long[] lArray5 = lArray3 = Nat256.create64();
            long[] lArray6 = lArray3;
            long[] lArray7 = lArray3;
            long[] lArray8 = lArray3;
            long[] lArray9 = lArray4;
            long[] lArray10 = lArray4;
            SecT233Field.square(lArray, lArray4);
            SecT233Field.multiply(lArray9, lArray, lArray4);
            SecT233Field.square(lArray10, lArray4);
            SecT233Field.multiply(lArray9, lArray, lArray4);
            SecT233Field.squareN(lArray10, 3, lArray3);
            SecT233Field.multiply(lArray7, lArray4, lArray3);
            SecT233Field.square(lArray8, lArray3);
            SecT233Field.multiply(lArray7, lArray, lArray3);
            SecT233Field.squareN(lArray8, 7, lArray4);
            SecT233Field.multiply(lArray4, lArray3, lArray4);
            SecT233Field.squareN(lArray4, 14, lArray3);
            SecT233Field.multiply(lArray5, lArray4, lArray3);
            SecT233Field.square(lArray6, lArray3);
            SecT233Field.multiply(lArray5, lArray, lArray3);
            SecT233Field.squareN(lArray6, 29, lArray4);
            SecT233Field.multiply(lArray4, lArray3, lArray4);
            SecT233Field.squareN(lArray4, 58, lArray3);
            SecT233Field.multiply(lArray3, lArray4, lArray3);
            SecT233Field.squareN(lArray3, 116, lArray4);
            SecT233Field.multiply(lArray4, lArray3, lArray4);
            SecT233Field.square(lArray4, lArray2);
            return;
        }
        throw new IllegalStateException();
    }

    public static void multiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat256.createExt64();
        SecT233Field.implMultiply(lArray, lArray2, lArray4);
        SecT233Field.reduce(lArray4, lArray3);
    }

    public static void multiplyAddToExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = lArray;
        lArray = Nat256.createExt64();
        SecT233Field.implMultiply(lArray4, lArray2, lArray);
        SecT233Field.addExt(lArray3, lArray, lArray3);
    }

    public static void reduce(long[] lArray, long[] lArray2) {
        long l;
        long l2 = lArray[0];
        long l3 = lArray[1];
        long l4 = lArray[2];
        long l5 = lArray[4];
        long l6 = lArray[5];
        long l7 = lArray[6];
        long l8 = lArray[7];
        long l9 = l4;
        l4 = l5 ^ (l8 >>> 41 ^ l8 << 33);
        l5 = l6 ^ l8 >>> 31;
        l6 = l9 ^ l7 << 23;
        long l10 = l5;
        long l11 = l3;
        l3 = l4 ^ l7 >>> 31;
        l4 = l11 ^ l5 << 23;
        l5 = l6 ^ (l5 >>> 41 ^ l5 << 33);
        l6 = lArray[3] ^ l8 << 23 ^ (l7 >>> 41 ^ l7 << 33) ^ l10 >>> 31;
        l2 ^= l3 << 23;
        long l12 = l4 ^ (l3 >>> 41 ^ l3 << 33);
        l3 = l5 ^ l3 >>> 31;
        l4 = l6 >>> 41;
        lArray2[0] = l = l2 ^ l4;
        lArray2[1] = l = l12 ^ l4 << 10;
        lArray2[2] = l3;
        lArray2[3] = l = l6 & 0x1FFFFFFFFFFL;
    }

    public static void reduce23(long[] lArray, int n) {
        int n2 = n + 3;
        long l = lArray[n2];
        long[] lArray2 = lArray;
        long l2 = l >>> 41;
        lArray2[n] = lArray[n] ^ l2;
        int n3 = n + 1;
        lArray[n3] = l2 = lArray2[n3] ^ l2 << 10;
        lArray[n2] = l & 0x1FFFFFFFFFFL;
    }

    public static void sqrt(long[] lArray, long[] lArray2) {
        long l;
        long l2 = Interleave.unshuffle(lArray[0]);
        long l3 = Interleave.unshuffle(lArray[1]);
        long l4 = l2 & 0xFFFFFFFFL | l3 << 32;
        long l5 = l2 >>> 32 | l3 & 0xFFFFFFFF00000000L;
        l3 = l5;
        long l6 = Interleave.unshuffle(lArray[2]);
        long l7 = Interleave.unshuffle(lArray[3]);
        long l8 = l6 & 0xFFFFFFFFL | l7 << 32;
        l7 = l6 >>> 32 | l7 & 0xFFFFFFFF00000000L;
        long l9 = l3;
        l3 = l7 >>> 27;
        l7 ^= l9 >>> 27 | l7 << 37;
        long l10 = l5 ^ l5 << 37;
        lArray = Nat256.createExt64();
        int n = 3;
        int[] nArray = new int[3];
        int[] nArray2 = nArray;
        nArray[0] = 32;
        nArray[1] = 117;
        nArray[2] = 191;
        for (int k = 0; k < n; ++k) {
            long l11;
            long l12;
            long l13;
            long[] lArray3 = lArray;
            int n2 = nArray2[k];
            int n3 = n2 >>> 6;
            int n4 = n2 & 0x3F;
            lArray3[n3] = l13 = lArray[n3] ^ l10 << n4;
            int n5 = n3 + 1;
            int n6 = -n4;
            lArray3[n5] = l12 = lArray[n5] ^ (l7 << n4 | l10 >>> n6);
            n5 = n3 + 2;
            lArray3[n5] = l12 = lArray[n5] ^ (l3 << n4 | l7 >>> n6);
            lArray3[n3 += 3] = l11 = lArray[n3] ^ l3 >>> n6;
        }
        long[] lArray4 = lArray2;
        SecT233Field.reduce(lArray, lArray2);
        lArray4[0] = l = lArray2[0] ^ l4;
        lArray4[1] = l = lArray2[1] ^ l8;
    }

    public static void square(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        SecT233Field.implSquare(lArray, lArray3);
        SecT233Field.reduce(lArray3, lArray2);
    }

    public static void squareAddToExt(long[] lArray, long[] lArray2) {
        long[] lArray3 = lArray;
        lArray = Nat256.createExt64();
        SecT233Field.implSquare(lArray3, lArray);
        SecT233Field.addExt(lArray2, lArray, lArray2);
    }

    public static void squareN(long[] lArray, int n, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        SecT233Field.implSquare(lArray, lArray3);
        SecT233Field.reduce(lArray3, lArray2);
        while ((n += -1) > 0) {
            SecT233Field.implSquare(lArray2, lArray3);
            SecT233Field.reduce(lArray3, lArray2);
        }
    }

    public static int trace(long[] lArray) {
        return (int)(lArray[0] ^ lArray[2] >>> 31) & 1;
    }

    public static void implCompactExt(long[] lArray) {
        long l = lArray[0];
        long l2 = lArray[1];
        long l3 = lArray[2];
        long l4 = lArray[3];
        long l5 = lArray[4];
        long l6 = lArray[5];
        long l7 = lArray[6];
        long l8 = lArray[7];
        lArray[0] = l ^= l2 << 59;
        lArray[1] = l = l2 >>> 5 ^ l3 << 54;
        lArray[2] = l = l3 >>> 10 ^ l4 << 49;
        lArray[3] = l = l4 >>> 15 ^ l5 << 44;
        lArray[4] = l = l5 >>> 20 ^ l6 << 39;
        lArray[5] = l = l6 >>> 25 ^ l7 << 34;
        lArray[6] = l = l7 >>> 30 ^ l8 << 29;
        lArray[7] = l = l8 >>> 35;
    }

    public static void implExpand(long[] lArray, long[] lArray2) {
        long l = lArray[0];
        long l2 = lArray[1];
        long l3 = lArray[2];
        long l4 = l;
        long l5 = lArray[3];
        lArray2[0] = l &= 0x7FFFFFFFFFFFFFFL;
        lArray2[1] = l = (l4 >>> 59 ^ l2 << 5) & 0x7FFFFFFFFFFFFFFL;
        lArray2[2] = l = (l2 >>> 54 ^ l3 << 10) & 0x7FFFFFFFFFFFFFFL;
        lArray2[3] = l5 = l3 >>> 49 ^ l5 << 15;
    }

    public static void implMultiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long l;
        long[] lArray4 = lArray2;
        long[] lArray5 = lArray;
        lArray = new long[4];
        lArray2 = new long[4];
        SecT233Field.implExpand(lArray5, lArray);
        SecT233Field.implExpand(lArray4, lArray2);
        long[] lArray6 = new long[8];
        long l2 = lArray[0];
        long l3 = lArray2[0];
        SecT233Field.implMulwAcc(lArray6, l2, l3, lArray3, 0);
        l2 = lArray[1];
        l3 = lArray2[1];
        SecT233Field.implMulwAcc(lArray6, l2, l3, lArray3, 1);
        l2 = lArray[2];
        l3 = lArray2[2];
        SecT233Field.implMulwAcc(lArray6, l2, l3, lArray3, 2);
        l2 = lArray[3];
        l3 = lArray2[3];
        SecT233Field.implMulwAcc(lArray6, l2, l3, lArray3, 3);
        for (int k = 5; k > 0; --k) {
            lArray3[k] = lArray3[k] ^ lArray3[k - 1];
        }
        long l4 = lArray[0] ^ lArray[1];
        l3 = lArray2[0] ^ lArray2[1];
        SecT233Field.implMulwAcc(lArray6, l4, l3, lArray3, 1);
        l4 = lArray[2] ^ lArray[3];
        l3 = lArray2[2] ^ lArray2[3];
        SecT233Field.implMulwAcc(lArray6, l4, l3, lArray3, 3);
        for (int k = 7; k > 1; --k) {
            lArray3[k] = lArray3[k] ^ lArray3[k - 2];
        }
        long[] lArray7 = lArray3;
        long l5 = lArray[0] ^ lArray[2];
        l3 = lArray[1] ^ lArray[3];
        long l6 = lArray2[0] ^ lArray2[2];
        long l7 = lArray2[1] ^ lArray2[3];
        long l8 = l5 ^ l3;
        long l9 = l6 ^ l7;
        SecT233Field.implMulwAcc(lArray6, l8, l9, lArray3, 3);
        lArray3 = new long[3];
        SecT233Field.implMulwAcc(lArray6, l5, l6, lArray3, 0);
        SecT233Field.implMulwAcc(lArray6, l3, l7, lArray3, 1);
        l7 = lArray3[0];
        long l10 = lArray3[1];
        long l11 = lArray3[2];
        lArray7[2] = l = lArray7[2] ^ l7;
        lArray7[3] = l7 = lArray7[3] ^ (l7 ^ l10);
        lArray7[4] = l7 = lArray7[4] ^ (l11 ^ l10);
        lArray7[5] = l7 = lArray7[5] ^ l11;
        SecT233Field.implCompactExt(lArray3);
    }

    public static void implMulwAcc(long[] lArray, long l, long l2, long[] lArray2, int n) {
        long l3;
        long l4;
        lArray[1] = l2;
        lArray[2] = l4 = l2 << 1;
        lArray[3] = l3 = l4 ^ l2;
        lArray[4] = l4 <<= 1;
        lArray[5] = l4 ^= l2;
        lArray[6] = l4 = l3 << 1;
        lArray[7] = l2 = l4 ^ l2;
        int n2 = (int)l;
        l4 = 0L;
        long l5 = lArray[n2 & 7] ^ lArray[n2 >>> 3 & 7] << 3;
        int n3 = 54;
        do {
            long l6 = l4;
            int n4 = (int)(l >>> n3);
            l4 = lArray[n4 & 7] ^ lArray[n4 >>> 3 & 7] << 3;
            l5 ^= l4 << n3;
            l4 = l6 ^ l4 >>> -n3;
        } while ((n3 += -6) > 0);
        long[] lArray3 = lArray2;
        lArray3[n] = lArray2[n] ^ l5 & 0x7FFFFFFFFFFFFFFL;
        int n5 = n + 1;
        lArray2[n5] = l = lArray3[n5] ^ (l5 >>> 59 ^ l4 << 5);
    }

    public static void implSquare(long[] lArray, long[] lArray2) {
        Interleave.expand64To128(lArray, 0, 4, lArray2, 0);
    }
}

