/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.saber.SABEREngine;

class Utils {
    private final int SABER_N;
    private final int SABER_L;
    private final int SABER_ET;
    private final int SABER_POLYBYTES;
    private final int SABER_EP;
    private final int SABER_KEYBYTES;

    public Utils(SABEREngine sABEREngine) {
        this.SABER_N = sABEREngine.getSABER_N();
        this.SABER_L = sABEREngine.getSABER_L();
        this.SABER_ET = sABEREngine.getSABER_ET();
        this.SABER_POLYBYTES = sABEREngine.getSABER_POLYBYTES();
        this.SABER_EP = sABEREngine.getSABER_EP();
        this.SABER_KEYBYTES = sABEREngine.getSABER_KEYBYTES();
    }

    private void POLq2BS(byte[] byArray, int n, short[] sArray) {
        int n2 = 0;
        while (n2 < this.SABER_N / 8) {
            int n3;
            int n4 = n2;
            int n5 = n2;
            n2 = (short)(n5 * 13);
            int n6 = n5 * 8;
            int n7 = n3 = n6;
            int n8 = n3;
            int n9 = n3;
            int n10 = n3;
            int n11 = n3;
            int n12 = n3;
            int n13 = n3;
            n2 = n + n2;
            n3 = n2 + 0;
            int n14 = sArray[n13 + 0];
            byArray[n3] = (byte)(n14 & 0xFF);
            n3 = n2 + 1;
            n14 = n14 >> 8 & 0x1F;
            short s = sArray[n12 + 1];
            byArray[n3] = (byte)(n14 | (s & 7) << 5);
            n3 = n2 + 2;
            byArray[n3] = (byte)(s >> 3 & 0xFF);
            n3 = n2 + 3;
            n14 = s >> 11 & 3;
            s = sArray[n11 + 2];
            byArray[n3] = (byte)(n14 | (s & 0x3F) << 2);
            n3 = n2 + 4;
            n14 = s >> 6 & 0x7F;
            s = sArray[n10 + 3];
            byArray[n3] = (byte)(n14 | (s & 1) << 7);
            n3 = n2 + 5;
            byArray[n3] = (byte)(s >> 1 & 0xFF);
            n3 = n2 + 6;
            n14 = s >> 9 & 0xF;
            s = sArray[n9 + 4];
            byArray[n3] = (byte)(n14 | (s & 0xF) << 4);
            n3 = n2 + 7;
            byArray[n3] = (byte)(s >> 4 & 0xFF);
            n3 = n2 + 8;
            n14 = s >> 12 & 1;
            s = sArray[n8 + 5];
            byArray[n3] = (byte)(n14 | (s & 0x7F) << 1);
            n3 = n2 + 9;
            n14 = s >> 7 & 0x3F;
            s = sArray[n7 + 6];
            byArray[n3] = (byte)(n14 | (s & 3) << 6);
            n3 = n2 + 10;
            byArray[n3] = (byte)(s >> 2 & 0xFF);
            n3 = n2 + 11;
            n14 = s >> 10 & 7;
            s = sArray[n6 + 7];
            byArray[n3] = (byte)(n14 | (s & 0x1F) << 3);
            byArray[n2 += 12] = (byte)(s >> 5 & 0xFF);
            n2 = (short)(n4 + 1);
        }
    }

    private void BS2POLq(byte[] byArray, int n, short[] sArray) {
        int n2 = 0;
        while (n2 < this.SABER_N / 8) {
            int n3 = n2;
            int n4 = n2;
            n2 = (short)(n4 * 13);
            short s = (short)(n4 * 8);
            int n5 = n2;
            n2 = s + 0;
            int n6 = n + n5;
            int n7 = byArray[n6 + 0] & 0xFF;
            byte by = byArray[n6 + 1];
            sArray[n2] = (short)(n7 | (by & 0x1F) << 8);
            n2 = s + 1;
            n7 = by >> 5 & 7 | (byArray[n6 + 2] & 0xFF) << 3;
            by = byArray[n6 + 3];
            sArray[n2] = (short)(n7 | (by & 3) << 11);
            n2 = s + 2;
            n7 = by >> 2 & 0x3F;
            by = byArray[n6 + 4];
            sArray[n2] = (short)(n7 | (by & 0x7F) << 6);
            n2 = s + 3;
            n7 = by >> 7 & 1 | (byArray[n6 + 5] & 0xFF) << 1;
            by = byArray[n6 + 6];
            sArray[n2] = (short)(n7 | (by & 0xF) << 9);
            n2 = s + 4;
            n7 = by >> 4 & 0xF | (byArray[n6 + 7] & 0xFF) << 4;
            by = byArray[n6 + 8];
            sArray[n2] = (short)(n7 | (by & 1) << 12);
            n2 = s + 5;
            n7 = by >> 1 & 0x7F;
            by = byArray[n6 + 9];
            sArray[n2] = (short)(n7 | (by & 0x3F) << 7);
            n2 = s + 6;
            n7 = by >> 6 & 3 | (byArray[n6 + 10] & 0xFF) << 2;
            by = byArray[n6 + 11];
            sArray[n2] = (short)(n7 | (by & 7) << 10);
            n2 = s + 7;
            sArray[n2] = (short)(by >> 3 & 0x1F | (byArray[n6 + 12] & 0xFF) << 5);
            n2 = (short)(n3 + 1);
        }
    }

    private void POLp2BS(byte[] byArray, int n, short[] sArray) {
        int n2 = 0;
        while (n2 < this.SABER_N / 4) {
            int n3;
            int n4 = n2;
            int n5 = n2;
            n2 = (short)(n5 * 5);
            int n6 = n5 * 4;
            int n7 = n3 = n6;
            int n8 = n3;
            int n9 = n3;
            n2 = n + n2;
            n3 = n2 + 0;
            int n10 = sArray[n9 + 0];
            byArray[n3] = (byte)(n10 & 0xFF);
            n3 = n2 + 1;
            n10 = n10 >> 8 & 3;
            short s = sArray[n8 + 1];
            byArray[n3] = (byte)(n10 | (s & 0x3F) << 2);
            n3 = n2 + 2;
            n10 = s >> 6 & 0xF;
            s = sArray[n7 + 2];
            byArray[n3] = (byte)(n10 | (s & 0xF) << 4);
            n3 = n2 + 3;
            n10 = s >> 4 & 0x3F;
            s = sArray[n6 + 3];
            byArray[n3] = (byte)(n10 | (s & 3) << 6);
            byArray[n2 += 4] = (byte)(s >> 2 & 0xFF);
            n2 = (short)(n4 + 1);
        }
    }

    public void POLT2BS(byte[] byArray, int n, short[] sArray) {
        block4: {
            int n2;
            block5: {
                block3: {
                    n2 = this.SABER_ET;
                    if (n2 != 3) break block3;
                    n2 = 0;
                    while (n2 < this.SABER_N / 8) {
                        int n3 = n2;
                        int n4 = n2;
                        n2 = (short)(n4 * 3);
                        short s = (short)(n4 * 8);
                        n2 = n + n2;
                        int n5 = n2 + 0;
                        int n6 = sArray[s + 0] & 7 | (sArray[s + 1] & 7) << 3;
                        short s2 = sArray[s + 2];
                        byArray[n5] = (byte)(n6 | (s2 & 3) << 6);
                        n5 = n2 + 1;
                        n6 = s2 >> 2 & 1 | (sArray[s + 3] & 7) << 1 | (sArray[s + 4] & 7) << 4;
                        s2 = sArray[s + 5];
                        byArray[n5] = (byte)(n6 | (s2 & 1) << 7);
                        byArray[n2 += 2] = (byte)(s2 >> 1 & 3 | (sArray[s + 6] & 7) << 2 | (sArray[s + 7] & 7) << 5);
                        n2 = (short)(n3 + 1);
                    }
                    break block4;
                }
                if (n2 != 4) break block5;
                n2 = 0;
                while (n2 < this.SABER_N / 2) {
                    int n7 = n2;
                    int n8 = n2;
                    n2 = (short)(n8 * 2);
                    int n9 = n + n8;
                    byArray[n9] = (byte)(sArray[n2] & 0xF | (sArray[n2 + 1] & 0xF) << 4);
                    n2 = (short)(n7 + 1);
                }
                break block4;
            }
            if (n2 != 6) break block4;
            n2 = 0;
            while (n2 < this.SABER_N / 4) {
                int n10 = n2;
                int n11 = n2;
                n2 = (short)(n11 * 3);
                short s = (short)(n11 * 4);
                n2 = n + n2;
                int n12 = n2 + 0;
                int n13 = sArray[s + 0] & 0x3F;
                short s3 = sArray[s + 1];
                byArray[n12] = (byte)(n13 | (s3 & 3) << 6);
                n12 = n2 + 1;
                n13 = s3 >> 2 & 0xF;
                s3 = sArray[s + 2];
                byArray[n12] = (byte)(n13 | (s3 & 0xF) << 4);
                byArray[n2 += 2] = (byte)(s3 >> 4 & 3 | (sArray[s + 3] & 0x3F) << 2);
                n2 = (short)(n10 + 1);
            }
        }
    }

    public void BS2POLT(byte[] byArray, int n, short[] sArray) {
        block4: {
            int n2;
            block5: {
                block3: {
                    n2 = this.SABER_ET;
                    if (n2 != 3) break block3;
                    n2 = 0;
                    while (n2 < this.SABER_N / 8) {
                        int n3;
                        int n4 = n2;
                        int n5 = n2;
                        n2 = (short)(n5 * 3);
                        short s = (short)(n5 * 8);
                        int n6 = n2;
                        n2 = s + 0;
                        int n7 = n + n6;
                        int n8 = n3 = n7;
                        n3 = byArray[n3 + 0];
                        sArray[n2] = (short)(n3 & 7);
                        n2 = s + 1;
                        sArray[n2] = (short)(n3 >> 3 & 7);
                        n2 = s + 2;
                        n3 = n3 >> 6 & 3;
                        byte by = byArray[n8 + 1];
                        sArray[n2] = (short)(n3 | (by & 1) << 2);
                        n2 = s + 3;
                        sArray[n2] = (short)(by >> 1 & 7);
                        n2 = s + 4;
                        sArray[n2] = (short)(by >> 4 & 7);
                        n2 = s + 5;
                        n3 = by >> 7 & 1;
                        by = byArray[n7 + 2];
                        sArray[n2] = (short)(n3 | (by & 3) << 1);
                        n2 = s + 6;
                        sArray[n2] = (short)(by >> 2 & 7);
                        n2 = s + 7;
                        sArray[n2] = (short)(by >> 5 & 7);
                        n2 = (short)(n4 + 1);
                    }
                    break block4;
                }
                if (n2 != 4) break block5;
                n2 = 0;
                while (n2 < this.SABER_N / 2) {
                    int n9 = n2;
                    int n10 = n2;
                    n2 = (short)(n10 * 2);
                    byte by = byArray[n + n10];
                    sArray[n2] = (short)(by & 0xF);
                    sArray[++n2] = (short)(by >> 4 & 0xF);
                    n2 = (short)(n9 + 1);
                }
                break block4;
            }
            if (n2 != 6) break block4;
            n2 = 0;
            while (n2 < this.SABER_N / 4) {
                int n11;
                int n12 = n2;
                int n13 = n2;
                n2 = (short)(n13 * 3);
                short s = (short)(n13 * 4);
                int n14 = n2;
                n2 = s + 0;
                int n15 = n + n14;
                int n16 = n11 = n15;
                n11 = byArray[n11 + 0];
                sArray[n2] = (short)(n11 & 0x3F);
                n2 = s + 1;
                n11 = n11 >> 6 & 3;
                byte by = byArray[n16 + 1];
                sArray[n2] = (short)(n11 | (by & 0xF) << 2);
                n2 = s + 2;
                n11 = (by & 0xFF) >> 4;
                by = byArray[n15 + 2];
                sArray[n2] = (short)(n11 | (by & 3) << 4);
                n2 = s + 3;
                sArray[n2] = (short)((by & 0xFF) >> 2);
                n2 = (short)(n12 + 1);
            }
        }
    }

    public void BS2POLp(byte[] byArray, int n, short[] sArray) {
        int n2 = 0;
        while (n2 < this.SABER_N / 4) {
            int n3 = n2;
            int n4 = n2;
            n2 = (short)(n4 * 5);
            short s = (short)(n4 * 4);
            int n5 = n2;
            n2 = s + 0;
            int n6 = n + n5;
            int n7 = byArray[n6 + 0] & 0xFF;
            byte by = byArray[n6 + 1];
            sArray[n2] = (short)(n7 | (by & 3) << 8);
            n2 = s + 1;
            n7 = by >> 2 & 0x3F;
            by = byArray[n6 + 2];
            sArray[n2] = (short)(n7 | (by & 0xF) << 6);
            n2 = s + 2;
            n7 = by >> 4 & 0xF;
            by = byArray[n6 + 3];
            sArray[n2] = (short)(n7 | (by & 0x3F) << 4);
            n2 = s + 3;
            sArray[n2] = (short)(by >> 6 & 3 | (byArray[n6 + 4] & 0xFF) << 2);
            n2 = (short)(n3 + 1);
        }
    }

    public void POLVECq2BS(byte[] byArray, short[][] sArray) {
        int n = 0;
        while (n < this.SABER_L) {
            int n2 = n;
            int n3 = n;
            n = n3 * this.SABER_POLYBYTES;
            this.POLq2BS(byArray, n, sArray[n3]);
            n = (byte)(n2 + 1);
        }
    }

    public void BS2POLVECq(byte[] byArray, int n, short[][] sArray) {
        int n2 = 0;
        while (n2 < this.SABER_L) {
            int n3 = n2;
            int n4 = n2;
            n2 = n4 * this.SABER_POLYBYTES + n;
            this.BS2POLq(byArray, n2, sArray[n4]);
            n2 = (byte)(n3 + 1);
        }
    }

    public void POLVECp2BS(byte[] byArray, short[][] sArray) {
        int n = 0;
        while (n < this.SABER_L) {
            int n2 = n;
            int n3 = n;
            n = this.SABER_EP * this.SABER_N / 8 * n;
            this.POLp2BS(byArray, n, sArray[n3]);
            n = (byte)(n2 + 1);
        }
    }

    public void BS2POLVECp(byte[] byArray, short[][] sArray) {
        int n = 0;
        while (n < this.SABER_L) {
            int n2 = n;
            int n3 = n;
            n = this.SABER_EP * this.SABER_N / 8 * n;
            this.BS2POLp(byArray, n, sArray[n3]);
            n = (byte)(n2 + 1);
        }
    }

    public void BS2POLmsg(byte[] byArray, short[] sArray) {
        for (int n = 0; n < this.SABER_KEYBYTES; n = (int)((byte)(n + 1))) {
            for (int n2 = 0; n2 < 8; n2 = (int)((byte)(n2 + 1))) {
                int n3 = n;
                int n4 = n3 * 8 + n2;
                sArray[n4] = (short)(byArray[n3] >> n2 & 1);
            }
        }
    }

    public void POLmsg2BS(byte[] byArray, short[] sArray) {
        for (int n = 0; n < this.SABER_KEYBYTES; n = (int)((byte)(n + 1))) {
            for (int n2 = 0; n2 < 8; n2 = (int)((byte)(n2 + 1))) {
                byArray[n] = (byte)(byArray[n] | (sArray[n * 8 + n2] & 1) << n2);
            }
        }
    }
}

