/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.WOTSPlusParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSUtil;

final class WOTSPlusPublicKeyParameters {
    private final byte[][] publicKey;

    public WOTSPlusPublicKeyParameters(WOTSPlusParameters wOTSPlusParameters, byte[][] byArray) {
        if (wOTSPlusParameters != null) {
            if (byArray != null) {
                if (!XMSSUtil.hasNullPointer(byArray)) {
                    if (byArray.length == wOTSPlusParameters.getLen()) {
                        for (int k = 0; k < byArray.length; ++k) {
                            if (byArray[k].length == wOTSPlusParameters.getTreeDigestSize()) {
                                continue;
                            }
                            throw new IllegalArgumentException("wrong publicKey format");
                        }
                        this.publicKey = XMSSUtil.cloneArray(byArray);
                        return;
                    }
                    throw new IllegalArgumentException("wrong publicKey size");
                }
                throw new NullPointerException("publicKey byte array == null");
            }
            throw new NullPointerException("publicKey == null");
        }
        throw new NullPointerException("params == null");
    }

    public byte[][] toByteArray() {
        return XMSSUtil.cloneArray(this.publicKey);
    }
}

