/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds.iso19794;

import b.b;
import com.fis.ekyc.nfc.build_in.eidparser.lds.AbstractImageInfo;
import d.a;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class IrisImageInfo
extends AbstractImageInfo {
    private static final long serialVersionUID = 833541246115625112L;
    public static final int IMAGE_QUAL_UNDEF = 254;
    public static final int IMAGE_QUAL_LOW_LO = 26;
    public static final int IMAGE_QUAL_LOW_HI = 50;
    public static final int IMAGE_QUAL_MED_LO = 51;
    public static final int IMAGE_QUAL_MED_HI = 75;
    public static final int IMAGE_QUAL_HIGH_LO = 76;
    public static final int IMAGE_QUAL_HIGH_HI = 100;
    private static final int ROT_ANGLE_UNDEF = 65535;
    private static final int ROT_UNCERTAIN_UNDEF = 65535;
    private int imageFormat;
    private int imageNumber;
    private int quality;
    private int rotationAngle;
    private int rotationAngleUncertainty;

    public IrisImageInfo(int n, int n2, int n3, int n4, int n5, int n6, InputStream inputStream, int n7, int n8) {
        long l = n7;
        String string2 = IrisImageInfo.getMimeTypeFromImageFormat(n8);
        super(3, n5, n6, inputStream, l, string2);
        if (inputStream != null) {
            IrisImageInfo irisImageInfo = this;
            irisImageInfo.imageNumber = n;
            irisImageInfo.quality = n2;
            irisImageInfo.rotationAngle = n3;
            irisImageInfo.rotationAngleUncertainty = n4;
            return;
        }
        throw new IllegalArgumentException("Null image bytes");
    }

    public IrisImageInfo(int n, int n2, int n3, InputStream inputStream, int n4, int n5) {
        this(n, 254, 65535, 65535, n2, n3, inputStream, n4, n5);
    }

    public IrisImageInfo(InputStream inputStream, int n) {
        super(3);
        this.imageFormat = n;
        this.setMimeType(IrisImageInfo.getMimeTypeFromImageFormat(n));
        this.readObject(inputStream);
    }

    private static String getMimeTypeFromImageFormat(int n) {
        if (n != 2 && n != 4) {
            if (n != 6 && n != 8 && n != 10 && n != 12) {
                if (n != 14 && n != 16) {
                    return null;
                }
                return "image/jp2";
            }
            return "image/jpeg";
        }
        return "image/x-wsq";
    }

    public int getImageFormat() {
        return this.imageFormat;
    }

    public int getImageNumber() {
        return this.imageNumber;
    }

    public int getQuality() {
        return this.quality;
    }

    public int getRotationAngle() {
        return this.rotationAngle;
    }

    public int getRotationAngleUncertainty() {
        return this.rotationAngleUncertainty;
    }

    @Override
    public long getRecordLength() {
        return (long)this.getImageLength() + 11L;
    }

    @Override
    public int hashCode() {
        return ((((super.hashCode() * 31 + this.imageFormat) * 31 + this.imageNumber) * 31 + this.quality) * 31 + this.rotationAngle) * 31 + this.rotationAngleUncertainty;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (IrisImageInfo)object;
        return this.imageFormat == ((IrisImageInfo)object).imageFormat && this.imageNumber == ((IrisImageInfo)object).imageNumber && this.quality == ((IrisImageInfo)object).quality && this.rotationAngle == ((IrisImageInfo)object).rotationAngle && this.rotationAngleUncertainty == ((IrisImageInfo)object).rotationAngleUncertainty;
    }

    @Override
    public String toString() {
        return a.a(b.a("IrisImageInfo [image number: ").append(this.imageNumber).append(", quality: ").append(this.quality).append(", image: ").append(this.getWidth()).append(" x ").append(this.getHeight()).append("mime-type: "), IrisImageInfo.getMimeTypeFromImageFormat(this.imageFormat), "]");
    }

    @Override
    public void readObject(InputStream inputStream) {
        DataInputStream dataInputStream;
        if (inputStream instanceof DataInputStream) {
            dataInputStream = (DataInputStream)inputStream;
        } else {
            DataInputStream dataInputStream2;
            dataInputStream = dataInputStream2;
            dataInputStream2 = new DataInputStream(inputStream);
        }
        this.imageNumber = dataInputStream.readUnsignedShort();
        this.quality = dataInputStream.readUnsignedByte();
        this.rotationAngle = dataInputStream.readShort();
        this.rotationAngleUncertainty = dataInputStream.readUnsignedShort();
        this.readImage(inputStream, (long)dataInputStream.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public void writeObject(OutputStream outputStream) {
        if (outputStream instanceof DataOutputStream) {
            outputStream = (DataOutputStream)outputStream;
        } else {
            DataOutputStream dataOutputStream;
            DataOutputStream dataOutputStream2 = dataOutputStream;
            dataOutputStream = new DataOutputStream(outputStream);
            outputStream = dataOutputStream2;
        }
        OutputStream outputStream2 = outputStream;
        ((DataOutputStream)outputStream).writeShort(this.imageNumber);
        ((DataOutputStream)outputStream).writeByte(this.quality);
        ((DataOutputStream)outputStream).writeShort(this.rotationAngle);
        ((DataOutputStream)outputStream).writeShort(this.rotationAngleUncertainty);
        ((DataOutputStream)outputStream2).writeInt(this.getImageLength());
        this.writeImage(outputStream2);
    }
}

