/*
 * Decompiled with CFR 0.152.
 */
package vn.payos;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import vn.payos.constant.PayOSConstant;
import vn.payos.exception.PayOSException;
import vn.payos.type.CheckoutResponseData;
import vn.payos.type.PayOSResponse;
import vn.payos.type.PaymentData;
import vn.payos.type.PaymentLinkData;
import vn.payos.type.Webhook;
import vn.payos.type.WebhookData;
import vn.payos.util.SignatureUtils;

public class PayOS {
    private final String clientId;
    private final String apiKey;
    private final String checksumKey;
    private final String partnerCode;
    private static final String PAYOS_BASE_URL = "https://api-merchant.payos.vn";

    public PayOS(String clientId, String apiKey, String checksumKey) {
        this.clientId = clientId;
        this.apiKey = apiKey;
        this.checksumKey = checksumKey;
        this.partnerCode = null;
    }

    public PayOS(String clientId, String apiKey, String checksumKey, String partnerCode) {
        this.clientId = clientId;
        this.apiKey = apiKey;
        this.checksumKey = checksumKey;
        this.partnerCode = partnerCode;
    }

    public CheckoutResponseData createPaymentLink(PaymentData paymentData) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        String url = "https://api-merchant.payos.vn/v2/payment-requests";
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        paymentData.setSignature(SignatureUtils.createSignatureOfPaymentRequest(paymentData, this.checksumKey));
        httpPost.setHeader("Accept", (Object)"application/json");
        httpPost.setHeader("Content-type", (Object)"application/json");
        httpPost.setHeader("Charset", (Object)"UTF-8");
        httpPost.setHeader("x-client-id", (Object)this.clientId);
        httpPost.setHeader("x-api-key", (Object)this.apiKey);
        if (this.partnerCode != null) {
            httpPost.setHeader("x-partner-code", (Object)this.partnerCode);
        }
        String paymentDataJson = objectMapper.writeValueAsString((Object)paymentData);
        httpPost.setEntity((HttpEntity)new StringEntity(paymentDataJson, StandardCharsets.UTF_8));
        CloseableHttpResponse response = client.execute((ClassicHttpRequest)httpPost);
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            response.close();
            client.close();
            throw new Exception("Call api failed!");
        }
        String responseData = EntityUtils.toString((HttpEntity)entity);
        response.close();
        client.close();
        PayOSResponse res = (PayOSResponse)objectMapper.readValue(responseData, (TypeReference)new TypeReference<PayOSResponse<CheckoutResponseData>>(){});
        if (!res.getCode().equals("00")) {
            throw new PayOSException(res.getCode(), res.getDesc());
        }
        String paymentLinkResSignature = SignatureUtils.createSignatureFromObj(res.getData(), this.checksumKey);
        if (!paymentLinkResSignature.equals(res.getSignature())) {
            throw new Exception(PayOSConstant.ERROR_MESSAGE.get("DATA_NOT_INTEGRITY"));
        }
        return (CheckoutResponseData)res.getData();
    }

    public PaymentLinkData getPaymentLinkInformation(Long orderId) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        String url = "https://api-merchant.payos.vn/v2/payment-requests/" + orderId;
        CloseableHttpClient client = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader("Accept", (Object)"application/json");
        httpGet.setHeader("Content-type", (Object)"application/json");
        httpGet.setHeader("Charset", (Object)"UTF-8");
        httpGet.setHeader("x-client-id", (Object)this.clientId);
        httpGet.setHeader("x-api-key", (Object)this.apiKey);
        CloseableHttpResponse response = client.execute((ClassicHttpRequest)httpGet);
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            response.close();
            client.close();
            throw new Exception("Call api failed!");
        }
        String responseData = EntityUtils.toString((HttpEntity)entity);
        response.close();
        client.close();
        PayOSResponse res = (PayOSResponse)objectMapper.readValue(responseData, (TypeReference)new TypeReference<PayOSResponse<PaymentLinkData>>(){});
        if (!res.getCode().equals("00")) {
            throw new PayOSException(res.getCode(), res.getDesc());
        }
        String paymentLinkResSignature = SignatureUtils.createSignatureFromObj(res.getData(), this.checksumKey);
        if (!paymentLinkResSignature.equals(res.getSignature())) {
            throw new Exception(PayOSConstant.ERROR_MESSAGE.get("DATA_NOT_INTEGRITY"));
        }
        return (PaymentLinkData)res.getData();
    }

    public String confirmWebhook(String webhookUrl) throws Exception {
        if (webhookUrl == null || webhookUrl.isEmpty()) {
            throw new Exception(PayOSConstant.ERROR_MESSAGE.get("INVALID_PARAMETER"));
        }
        String url = "https://api-merchant.payos.vn/confirm-webhook";
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Accept", (Object)"application/json");
        httpPost.setHeader("Content-type", (Object)"application/json");
        httpPost.setHeader("Charset", (Object)"UTF-8");
        httpPost.setHeader("x-client-id", (Object)this.clientId);
        httpPost.setHeader("x-api-key", (Object)this.apiKey);
        httpPost.setEntity((HttpEntity)new StringEntity("{\"webhookUrl\":\"" + webhookUrl + "\"}", StandardCharsets.UTF_8));
        CloseableHttpResponse response = client.execute((ClassicHttpRequest)httpPost);
        int statusCode = response.getCode();
        response.close();
        client.close();
        if (statusCode == 200) {
            return webhookUrl;
        }
        if (statusCode == 404) {
            throw new PayOSException(PayOSConstant.ERROR_CODE.get("INTERNAL_SERVER_ERROR"), PayOSConstant.ERROR_MESSAGE.get("INTERNAL_SERVER_ERROR"));
        }
        if (statusCode == 401) {
            throw new PayOSException(PayOSConstant.ERROR_CODE.get("UNAUTHORIZED"), PayOSConstant.ERROR_MESSAGE.get("UNAUTHORIZED"));
        }
        throw new PayOSException(PayOSConstant.ERROR_CODE.get("INTERNAL_SERVER_ERROR"), PayOSConstant.ERROR_MESSAGE.get("INTERNAL_SERVER_ERROR"));
    }

    public PaymentLinkData cancelPaymentLink(long orderId, String cancellationReason) throws Exception {
        CloseableHttpResponse response;
        int statusCode;
        String url = "https://api-merchant.payos.vn/v2/payment-requests/" + orderId + "/cancel";
        ObjectMapper objectMapper = new ObjectMapper();
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Accept", (Object)"application/json");
        httpPost.setHeader("Content-type", (Object)"application/json");
        httpPost.setHeader("Charset", (Object)"UTF-8");
        httpPost.setHeader("x-client-id", (Object)this.clientId);
        httpPost.setHeader("x-api-key", (Object)this.apiKey);
        if (cancellationReason != null) {
            httpPost.setEntity((HttpEntity)new StringEntity("{\"cancellationReason\":\"" + cancellationReason + "\"}", StandardCharsets.UTF_8));
        }
        if ((statusCode = (response = client.execute((ClassicHttpRequest)httpPost)).getCode()) != 200) {
            throw new PayOSException(PayOSConstant.ERROR_CODE.get("INTERNAL_SERVER_ERROR"), PayOSConstant.ERROR_MESSAGE.get("INTERNAL_SERVER_ERROR"));
        }
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            response.close();
            client.close();
            throw new Exception("Call api failed!");
        }
        String responseData = EntityUtils.toString((HttpEntity)entity);
        response.close();
        client.close();
        PayOSResponse res = (PayOSResponse)objectMapper.readValue(responseData, (TypeReference)new TypeReference<PayOSResponse<PaymentLinkData>>(){});
        if (!res.getCode().equals("00")) {
            throw new PayOSException(res.getCode(), res.getDesc());
        }
        String paymentLinkResSignature = SignatureUtils.createSignatureFromObj(res.getData(), this.checksumKey);
        if (!paymentLinkResSignature.equals(res.getSignature())) {
            throw new Exception(PayOSConstant.ERROR_MESSAGE.get("DATA_NOT_INTEGRITY"));
        }
        return (PaymentLinkData)res.getData();
    }

    public WebhookData verifyPaymentWebhookData(Webhook webhookBody) throws Exception {
        WebhookData data = webhookBody.getData();
        String signature = webhookBody.getSignature();
        if (signature.isEmpty()) {
            throw new Exception(PayOSConstant.ERROR_MESSAGE.get("NO_SIGNATURE"));
        }
        String signData = SignatureUtils.createSignatureFromObj(data, this.checksumKey);
        if (!signData.equals(signature)) {
            throw new Exception(PayOSConstant.ERROR_MESSAGE.get("DATA_NOT_INTEGRITY"));
        }
        return data;
    }
}

