/*
 * Decompiled with CFR 0.152.
 */
package vn.payos.type;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import vn.payos.type.ItemData;

@JsonDeserialize(builder=PaymentDataBuilder.class)
public class PaymentData {
    @NonNull
    private Long orderCode;
    @NonNull
    private Integer amount;
    @NonNull
    private String description;
    private List<ItemData> items;
    @NonNull
    private String cancelUrl;
    @NonNull
    private String returnUrl;
    private String signature;
    private String buyerName;
    private String buyerEmail;
    private String buyerPhone;
    private String buyerAddress;
    private Integer expiredAt;

    public void addItem(ItemData item) {
        if (this.items == null) {
            this.items = new ArrayList<ItemData>();
        }
        this.items.add(item);
    }

    PaymentData(@NonNull Long orderCode, @NonNull Integer amount, @NonNull String description, List<ItemData> items, @NonNull String cancelUrl, @NonNull String returnUrl, String signature, String buyerName, String buyerEmail, String buyerPhone, String buyerAddress, Integer expiredAt) {
        if (orderCode == null) {
            throw new NullPointerException("orderCode is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (cancelUrl == null) {
            throw new NullPointerException("cancelUrl is marked non-null but is null");
        }
        if (returnUrl == null) {
            throw new NullPointerException("returnUrl is marked non-null but is null");
        }
        this.orderCode = orderCode;
        this.amount = amount;
        this.description = description;
        this.items = items;
        this.cancelUrl = cancelUrl;
        this.returnUrl = returnUrl;
        this.signature = signature;
        this.buyerName = buyerName;
        this.buyerEmail = buyerEmail;
        this.buyerPhone = buyerPhone;
        this.buyerAddress = buyerAddress;
        this.expiredAt = expiredAt;
    }

    public static PaymentDataBuilder builder() {
        return new PaymentDataBuilder();
    }

    @NonNull
    public Long getOrderCode() {
        return this.orderCode;
    }

    @NonNull
    public Integer getAmount() {
        return this.amount;
    }

    @NonNull
    public String getDescription() {
        return this.description;
    }

    public List<ItemData> getItems() {
        return this.items;
    }

    @NonNull
    public String getCancelUrl() {
        return this.cancelUrl;
    }

    @NonNull
    public String getReturnUrl() {
        return this.returnUrl;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getBuyerName() {
        return this.buyerName;
    }

    public String getBuyerEmail() {
        return this.buyerEmail;
    }

    public String getBuyerPhone() {
        return this.buyerPhone;
    }

    public String getBuyerAddress() {
        return this.buyerAddress;
    }

    public Integer getExpiredAt() {
        return this.expiredAt;
    }

    public void setOrderCode(@NonNull Long orderCode) {
        if (orderCode == null) {
            throw new NullPointerException("orderCode is marked non-null but is null");
        }
        this.orderCode = orderCode;
    }

    public void setAmount(@NonNull Integer amount) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.amount = amount;
    }

    public void setDescription(@NonNull String description) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.description = description;
    }

    public void setItems(List<ItemData> items) {
        this.items = items;
    }

    public void setCancelUrl(@NonNull String cancelUrl) {
        if (cancelUrl == null) {
            throw new NullPointerException("cancelUrl is marked non-null but is null");
        }
        this.cancelUrl = cancelUrl;
    }

    public void setReturnUrl(@NonNull String returnUrl) {
        if (returnUrl == null) {
            throw new NullPointerException("returnUrl is marked non-null but is null");
        }
        this.returnUrl = returnUrl;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public void setBuyerEmail(String buyerEmail) {
        this.buyerEmail = buyerEmail;
    }

    public void setBuyerPhone(String buyerPhone) {
        this.buyerPhone = buyerPhone;
    }

    public void setBuyerAddress(String buyerAddress) {
        this.buyerAddress = buyerAddress;
    }

    public void setExpiredAt(Integer expiredAt) {
        this.expiredAt = expiredAt;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class PaymentDataBuilder {
        private Long orderCode;
        private Integer amount;
        private String description;
        private String cancelUrl;
        private String returnUrl;
        private String signature;
        private String buyerName;
        private String buyerEmail;
        private String buyerPhone;
        private String buyerAddress;
        private Integer expiredAt;
        private List<ItemData> items = new ArrayList<ItemData>();

        public PaymentDataBuilder item(ItemData item) {
            this.items.add(item);
            return this;
        }

        PaymentDataBuilder() {
        }

        public PaymentDataBuilder orderCode(@NonNull Long orderCode) {
            if (orderCode == null) {
                throw new NullPointerException("orderCode is marked non-null but is null");
            }
            this.orderCode = orderCode;
            return this;
        }

        public PaymentDataBuilder amount(@NonNull Integer amount) {
            if (amount == null) {
                throw new NullPointerException("amount is marked non-null but is null");
            }
            this.amount = amount;
            return this;
        }

        public PaymentDataBuilder description(@NonNull String description) {
            if (description == null) {
                throw new NullPointerException("description is marked non-null but is null");
            }
            this.description = description;
            return this;
        }

        public PaymentDataBuilder items(List<ItemData> items) {
            this.items = items;
            return this;
        }

        public PaymentDataBuilder cancelUrl(@NonNull String cancelUrl) {
            if (cancelUrl == null) {
                throw new NullPointerException("cancelUrl is marked non-null but is null");
            }
            this.cancelUrl = cancelUrl;
            return this;
        }

        public PaymentDataBuilder returnUrl(@NonNull String returnUrl) {
            if (returnUrl == null) {
                throw new NullPointerException("returnUrl is marked non-null but is null");
            }
            this.returnUrl = returnUrl;
            return this;
        }

        public PaymentDataBuilder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public PaymentDataBuilder buyerName(String buyerName) {
            this.buyerName = buyerName;
            return this;
        }

        public PaymentDataBuilder buyerEmail(String buyerEmail) {
            this.buyerEmail = buyerEmail;
            return this;
        }

        public PaymentDataBuilder buyerPhone(String buyerPhone) {
            this.buyerPhone = buyerPhone;
            return this;
        }

        public PaymentDataBuilder buyerAddress(String buyerAddress) {
            this.buyerAddress = buyerAddress;
            return this;
        }

        public PaymentDataBuilder expiredAt(Integer expiredAt) {
            this.expiredAt = expiredAt;
            return this;
        }

        public PaymentData build() {
            return new PaymentData(this.orderCode, this.amount, this.description, this.items, this.cancelUrl, this.returnUrl, this.signature, this.buyerName, this.buyerEmail, this.buyerPhone, this.buyerAddress, this.expiredAt);
        }

        public String toString() {
            return "PaymentData.PaymentDataBuilder(orderCode=" + this.orderCode + ", amount=" + this.amount + ", description=" + this.description + ", items=" + this.items + ", cancelUrl=" + this.cancelUrl + ", returnUrl=" + this.returnUrl + ", signature=" + this.signature + ", buyerName=" + this.buyerName + ", buyerEmail=" + this.buyerEmail + ", buyerPhone=" + this.buyerPhone + ", buyerAddress=" + this.buyerAddress + ", expiredAt=" + this.expiredAt + ")";
        }
    }
}

