/*
 * Decompiled with CFR 0.152.
 */
package vn.payos.type;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import vn.payos.type.Transaction;

@JsonDeserialize(builder=PaymentLinkDataBuilder.class)
public class PaymentLinkData {
    @NonNull
    private String id;
    @NonNull
    private Long orderCode;
    @NonNull
    private Integer amount;
    @NonNull
    private Integer amountPaid;
    @NonNull
    private Integer amountRemaining;
    @NonNull
    private String status;
    @NonNull
    private String createdAt;
    @NonNull
    private List<Transaction> transactions;
    private String cancellationReason;
    private String canceledAt;

    public void addTransaction(Transaction transaction) {
        if (this.transactions == null) {
            this.transactions = new ArrayList<Transaction>();
        }
        this.transactions.add(transaction);
    }

    PaymentLinkData(@NonNull String id, @NonNull Long orderCode, @NonNull Integer amount, @NonNull Integer amountPaid, @NonNull Integer amountRemaining, @NonNull String status, @NonNull String createdAt, @NonNull List<Transaction> transactions, String cancellationReason, String canceledAt) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (orderCode == null) {
            throw new NullPointerException("orderCode is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (amountPaid == null) {
            throw new NullPointerException("amountPaid is marked non-null but is null");
        }
        if (amountRemaining == null) {
            throw new NullPointerException("amountRemaining is marked non-null but is null");
        }
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        if (createdAt == null) {
            throw new NullPointerException("createdAt is marked non-null but is null");
        }
        if (transactions == null) {
            throw new NullPointerException("transactions is marked non-null but is null");
        }
        this.id = id;
        this.orderCode = orderCode;
        this.amount = amount;
        this.amountPaid = amountPaid;
        this.amountRemaining = amountRemaining;
        this.status = status;
        this.createdAt = createdAt;
        this.transactions = transactions;
        this.cancellationReason = cancellationReason;
        this.canceledAt = canceledAt;
    }

    public static PaymentLinkDataBuilder builder() {
        return new PaymentLinkDataBuilder();
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public Long getOrderCode() {
        return this.orderCode;
    }

    @NonNull
    public Integer getAmount() {
        return this.amount;
    }

    @NonNull
    public Integer getAmountPaid() {
        return this.amountPaid;
    }

    @NonNull
    public Integer getAmountRemaining() {
        return this.amountRemaining;
    }

    @NonNull
    public String getStatus() {
        return this.status;
    }

    @NonNull
    public String getCreatedAt() {
        return this.createdAt;
    }

    @NonNull
    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public String getCanceledAt() {
        return this.canceledAt;
    }

    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    public void setOrderCode(@NonNull Long orderCode) {
        if (orderCode == null) {
            throw new NullPointerException("orderCode is marked non-null but is null");
        }
        this.orderCode = orderCode;
    }

    public void setAmount(@NonNull Integer amount) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.amount = amount;
    }

    public void setAmountPaid(@NonNull Integer amountPaid) {
        if (amountPaid == null) {
            throw new NullPointerException("amountPaid is marked non-null but is null");
        }
        this.amountPaid = amountPaid;
    }

    public void setAmountRemaining(@NonNull Integer amountRemaining) {
        if (amountRemaining == null) {
            throw new NullPointerException("amountRemaining is marked non-null but is null");
        }
        this.amountRemaining = amountRemaining;
    }

    public void setStatus(@NonNull String status) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        this.status = status;
    }

    public void setCreatedAt(@NonNull String createdAt) {
        if (createdAt == null) {
            throw new NullPointerException("createdAt is marked non-null but is null");
        }
        this.createdAt = createdAt;
    }

    public void setTransactions(@NonNull List<Transaction> transactions) {
        if (transactions == null) {
            throw new NullPointerException("transactions is marked non-null but is null");
        }
        this.transactions = transactions;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public void setCanceledAt(String canceledAt) {
        this.canceledAt = canceledAt;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class PaymentLinkDataBuilder {
        private String id;
        private Long orderCode;
        private Integer amount;
        private Integer amountPaid;
        private Integer amountRemaining;
        private String status;
        private String createdAt;
        private String cancellationReason;
        private String canceledAt;
        private List<Transaction> transactions = new ArrayList<Transaction>();

        public PaymentLinkDataBuilder transaction(Transaction transaction) {
            this.transactions.add(transaction);
            return this;
        }

        PaymentLinkDataBuilder() {
        }

        public PaymentLinkDataBuilder id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        public PaymentLinkDataBuilder orderCode(@NonNull Long orderCode) {
            if (orderCode == null) {
                throw new NullPointerException("orderCode is marked non-null but is null");
            }
            this.orderCode = orderCode;
            return this;
        }

        public PaymentLinkDataBuilder amount(@NonNull Integer amount) {
            if (amount == null) {
                throw new NullPointerException("amount is marked non-null but is null");
            }
            this.amount = amount;
            return this;
        }

        public PaymentLinkDataBuilder amountPaid(@NonNull Integer amountPaid) {
            if (amountPaid == null) {
                throw new NullPointerException("amountPaid is marked non-null but is null");
            }
            this.amountPaid = amountPaid;
            return this;
        }

        public PaymentLinkDataBuilder amountRemaining(@NonNull Integer amountRemaining) {
            if (amountRemaining == null) {
                throw new NullPointerException("amountRemaining is marked non-null but is null");
            }
            this.amountRemaining = amountRemaining;
            return this;
        }

        public PaymentLinkDataBuilder status(@NonNull String status) {
            if (status == null) {
                throw new NullPointerException("status is marked non-null but is null");
            }
            this.status = status;
            return this;
        }

        public PaymentLinkDataBuilder createdAt(@NonNull String createdAt) {
            if (createdAt == null) {
                throw new NullPointerException("createdAt is marked non-null but is null");
            }
            this.createdAt = createdAt;
            return this;
        }

        public PaymentLinkDataBuilder transactions(@NonNull List<Transaction> transactions) {
            if (transactions == null) {
                throw new NullPointerException("transactions is marked non-null but is null");
            }
            this.transactions = transactions;
            return this;
        }

        public PaymentLinkDataBuilder cancellationReason(String cancellationReason) {
            this.cancellationReason = cancellationReason;
            return this;
        }

        public PaymentLinkDataBuilder canceledAt(String canceledAt) {
            this.canceledAt = canceledAt;
            return this;
        }

        public PaymentLinkData build() {
            return new PaymentLinkData(this.id, this.orderCode, this.amount, this.amountPaid, this.amountRemaining, this.status, this.createdAt, this.transactions, this.cancellationReason, this.canceledAt);
        }

        public String toString() {
            return "PaymentLinkData.PaymentLinkDataBuilder(id=" + this.id + ", orderCode=" + this.orderCode + ", amount=" + this.amount + ", amountPaid=" + this.amountPaid + ", amountRemaining=" + this.amountRemaining + ", status=" + this.status + ", createdAt=" + this.createdAt + ", transactions=" + this.transactions + ", cancellationReason=" + this.cancellationReason + ", canceledAt=" + this.canceledAt + ")";
        }
    }
}

