/*
 * Decompiled with CFR 0.152.
 */
package vn.payos.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import vn.payos.type.PaymentData;

public class SignatureUtils {
    private static String convertObjToQueryStr(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        ObjectMapper objectMapper = new ObjectMapper();
        Map map = (Map)objectMapper.convertValue(object, (TypeReference)new TypeReference<Map<String, Object>>(){});
        map.forEach((key, value) -> {
            if (value == null && key == "expiredAt") {
                return;
            }
            String valueAsString = "";
            if (value instanceof List) {
                ArrayList sortedList = new ArrayList();
                ((List)value).forEach(item -> {
                    boolean bl = sortedList.add(SignatureUtils.sortObjDataByKey(item));
                });
                try {
                    valueAsString = objectMapper.writeValueAsString(sortedList);
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
            } else if (value != null) {
                valueAsString = value.toString();
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append((String)key).append('=').append(valueAsString);
        });
        return stringBuilder.toString();
    }

    private static Object sortObjDataByKey(Object object) {
        ObjectMapper objectMapper = new ObjectMapper();
        Map map = (Map)objectMapper.convertValue(object, (TypeReference)new TypeReference<Map<String, Object>>(){});
        TreeMap sortedMap = new TreeMap(map);
        return objectMapper.convertValue(sortedMap, Object.class);
    }

    private static String generateHmacSHA256(String dataStr, String key) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac sha256Hmac = Mac.getInstance("HmacSHA256");
        SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
        sha256Hmac.init(secretKey);
        byte[] hmacBytes = sha256Hmac.doFinal(dataStr.getBytes(StandardCharsets.UTF_8));
        StringBuilder hexStringBuilder = new StringBuilder();
        byte[] byArray = hmacBytes;
        int n = hmacBytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            hexStringBuilder.append(String.format("%02x", b));
            ++n2;
        }
        return hexStringBuilder.toString();
    }

    public static String createSignatureFromObj(Object object, String key) throws NoSuchAlgorithmException, InvalidKeyException {
        Object sortedDataByKey = SignatureUtils.sortObjDataByKey(object);
        String dataQueryStr = SignatureUtils.convertObjToQueryStr(sortedDataByKey);
        return SignatureUtils.generateHmacSHA256(dataQueryStr, key);
    }

    public static String createSignatureOfPaymentRequest(PaymentData data, String key) throws NoSuchAlgorithmException, InvalidKeyException {
        int amount = data.getAmount();
        String cancelUrl = data.getCancelUrl();
        String description = data.getDescription();
        String orderCode = Long.toString(data.getOrderCode());
        String returnUrl = data.getReturnUrl();
        String dataStr = "amount=" + amount + "&cancelUrl=" + cancelUrl + "&description=" + description + "&orderCode=" + orderCode + "&returnUrl=" + returnUrl;
        return SignatureUtils.generateHmacSHA256(dataStr, key);
    }
}

