/*
 * Decompiled with CFR 0.152.
 */
package vn.tiki.ab;

import java.util.Map;
import java.util.concurrent.TimeUnit;

public interface AbSettings {
    public boolean debug();

    public Map<String, Object> defaults();

    public long cacheExpiration();

    public static class Builder {
        private boolean debug;
        private long cacheExpiration;
        private Map<String, Object> defaults;

        public Builder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder cacheExpiration(long cacheExpiration, TimeUnit timeUnit) {
            this.cacheExpiration = TimeUnit.SECONDS.convert(cacheExpiration, timeUnit);
            return this;
        }

        public Builder defaults(Map<String, Object> defaults) {
            this.defaults = defaults;
            return this;
        }

        public AbSettings build() {
            if (this.defaults == null) {
                throw new NullPointerException("defaults must not be null");
            }
            return new AbSettings(){

                @Override
                public boolean debug() {
                    return Builder.this.debug;
                }

                @Override
                public long cacheExpiration() {
                    return Builder.this.cacheExpiration;
                }

                @Override
                public Map<String, Object> defaults() {
                    return Builder.this.defaults;
                }
            };
        }
    }
}

