/*
 * Decompiled with CFR 0.152.
 */
package vn.tiki.ab;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.remoteconfig.FirebaseRemoteConfig;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import rx.AsyncEmitter;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;
import vn.tiki.ab.ValueParser;

public class ValueRequest {
    private final FirebaseRemoteConfig remoteConfig;
    private final String key;
    private final long timeout;
    private final long cacheExpiration;
    private final WeakReference<Activity> activityWeakReference;

    ValueRequest(@Nullable Activity activity, FirebaseRemoteConfig remoteConfig, long cacheExpiration, String key, long timeout) {
        this.activityWeakReference = new WeakReference<Activity>(activity);
        this.remoteConfig = remoteConfig;
        this.cacheExpiration = cacheExpiration;
        this.key = key;
        this.timeout = timeout;
    }

    public <T> Observable<T> parseValue(final ValueParser<T> valueParser) {
        return this.getValue().map(new Func1<FirebaseRemoteConfigValue, T>(){

            public T call(FirebaseRemoteConfigValue remoteConfigValue) {
                return valueParser.parse(remoteConfigValue.asString());
            }
        });
    }

    public Observable<String> stringValue() {
        return this.getValue().map((Func1)new Func1<FirebaseRemoteConfigValue, String>(){

            public String call(FirebaseRemoteConfigValue remoteConfigValue) {
                return remoteConfigValue.asString();
            }
        });
    }

    public Observable<Boolean> booleanValue() {
        return this.getValue().map((Func1)new Func1<FirebaseRemoteConfigValue, Boolean>(){

            public Boolean call(FirebaseRemoteConfigValue remoteConfigValue) {
                return remoteConfigValue.asBoolean();
            }
        });
    }

    private Observable<FirebaseRemoteConfigValue> getValue() {
        return Observable.fromEmitter((Action1)new Action1<AsyncEmitter<FirebaseRemoteConfigValue>>(){

            public void call(final AsyncEmitter<FirebaseRemoteConfigValue> asyncEmitter) {
                Activity activity = (Activity)ValueRequest.this.activityWeakReference.get();
                ValueRequest.this.remoteConfig.fetch(ValueRequest.this.cacheExpiration).addOnFailureListener(activity, new OnFailureListener(){

                    public void onFailure(@NonNull Exception e) {
                        asyncEmitter.onError((Throwable)e);
                    }
                }).addOnSuccessListener(activity, (OnSuccessListener)new OnSuccessListener<Void>(){

                    public void onSuccess(Void aVoid) {
                        ValueRequest.this.remoteConfig.activateFetched();
                        asyncEmitter.onNext((Object)ValueRequest.this.remoteConfig.getValue(ValueRequest.this.key));
                    }
                }).addOnCompleteListener(activity, (OnCompleteListener)new OnCompleteListener<Void>(){

                    public void onComplete(@NonNull Task<Void> task) {
                        asyncEmitter.onCompleted();
                    }
                });
                asyncEmitter.setCancellation(new AsyncEmitter.Cancellable(){

                    public void cancel() throws Exception {
                        ValueRequest.this.activityWeakReference.clear();
                    }
                });
            }
        }, (AsyncEmitter.BackpressureMode)AsyncEmitter.BackpressureMode.BUFFER).timeout(this.timeout, TimeUnit.MILLISECONDS).onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends FirebaseRemoteConfigValue>>(){

            public Observable<? extends FirebaseRemoteConfigValue> call(Throwable throwable) {
                return Observable.just((Object)ValueRequest.this.remoteConfig.getValue(ValueRequest.this.key));
            }
        });
    }
}

