/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    protected static final String newline = System.getProperty("line.separator");
    protected static final String[] _xlate = new String[]{"lvl0 ", "lvl1 ", "lvl2 ", "TRACE", "finer", "DEBUG", "lvl6 ", "conf ", "INFO ", "WARN ", "ERROR"};
    protected final Date _date = new Date();
    protected final DateFormat _fmt = new SimpleDateFormat("hh:mm:ss.SSS");

    public synchronized String format(LogRecord r) {
        StringBuffer buf = new StringBuffer();
        this._date.setTime(r.getMillis());
        buf.append(this._fmt.format(this._date));
        buf.append(" ");
        buf.append(_xlate[r.getLevel().intValue() / 100]);
        buf.append(" [");
        String ln = r.getLoggerName();
        if (ln.startsWith("org.codehaus.wadi.")) {
            ln = "o.c.w." + ln.substring(18);
        }
        buf.append(ln);
        buf.append("] ");
        buf.append(this.formatMessage(r));
        Throwable t = r.getThrown();
        if (t != null) {
            buf.append(newline);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            buf.append(sw.toString());
        }
        buf.append(newline);
        return buf.toString();
    }
}

