/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.dindex.impl;

import EDU.oswego.cs.dl.util.concurrent.Slot;
import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Destination;
import org.activecluster.Cluster;
import org.activecluster.LocalNode;
import org.activecluster.Node;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.dindex.CoordinatorConfig;
import org.codehaus.wadi.dindex.impl.DIndex;
import org.codehaus.wadi.dindex.impl.PartitionKeys;
import org.codehaus.wadi.dindex.impl.PartitionOwner;
import org.codehaus.wadi.dindex.impl.PartitionTransfer;
import org.codehaus.wadi.dindex.impl.RedistributionPlan;
import org.codehaus.wadi.dindex.messages.PartitionEvacuationResponse;
import org.codehaus.wadi.dindex.messages.PartitionTransferCommand;
import org.codehaus.wadi.gridstate.Dispatcher;
import org.codehaus.wadi.impl.Quipu;

public class Coordinator
implements Runnable {
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected final Slot _flag = new Slot();
    protected final CoordinatorConfig _config;
    protected final Cluster _cluster;
    protected final Dispatcher _dispatcher;
    protected final Node _localNode;
    protected final int _numItems;
    protected final long _inactiveTime;
    protected Thread _thread;
    protected Node[] _remoteNodes;

    public Coordinator(CoordinatorConfig config) {
        this._config = config;
        this._cluster = this._config.getCluster();
        this._dispatcher = this._config.getDispatcher();
        this._localNode = this._cluster.getLocalNode();
        this._numItems = this._config.getNumPartitions();
        this._inactiveTime = this._config.getInactiveTime();
    }

    public synchronized void start() throws Exception {
        this._log.info((Object)"starting...");
        this._thread = new Thread((Runnable)this, "WADI Coordinator");
        this._thread.start();
        this._log.info((Object)"...started");
    }

    public synchronized void stop() throws Exception {
        this._log.info((Object)"stopping...");
        this._flag.put((Object)Boolean.FALSE);
        this._thread.join();
        this._thread = null;
        this._log.info((Object)"...stopped");
    }

    public synchronized void queueRebalancing() {
        this._log.trace((Object)"queueing rebalancing...");
        try {
            this._flag.offer((Object)Boolean.TRUE, 0L);
        }
        catch (InterruptedException e) {
            this._log.warn((Object)"unexpected interruption");
        }
        this._log.trace((Object)"...rebalancing queued");
    }

    public void run() {
        try {
            while (this._flag.take() == Boolean.TRUE) {
                this.rebalanceClusterState();
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            this._log.warn((Object)"interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebalanceClusterState() {
        int failures = 0;
        try {
            ArrayList l;
            Collection stayingNodes;
            Map nodeMap = this._cluster.getNodes();
            Collection collection = stayingNodes = nodeMap.values();
            synchronized (collection) {
                stayingNodes = new ArrayList(stayingNodes);
            }
            stayingNodes.add(this._cluster.getLocalNode());
            ArrayList arrayList = l = this._config.getLeavers();
            synchronized (arrayList) {
                l = new ArrayList(l);
            }
            ArrayList<Node> leavingNodes = new ArrayList<Node>();
            Iterator i = l.iterator();
            while (i.hasNext()) {
                Destination d = (Destination)i.next();
                Node leaver = this.getNode(d);
                if (leaver == null) continue;
                leavingNodes.add(leaver);
                stayingNodes.remove(leaver);
            }
            this._log.trace((Object)"--------");
            this._log.trace((Object)"STAYING:");
            this.printNodes(stayingNodes);
            this._log.trace((Object)"LEAVING:");
            this.printNodes(leavingNodes);
            this._log.trace((Object)"--------");
            Node[] leaving = leavingNodes.toArray(new Node[leavingNodes.size()]);
            if (stayingNodes.size() == 0) {
                this._log.warn((Object)"we are the last node - no need to rebalance cluster");
            } else {
                Node[] living = stayingNodes.toArray(new Node[stayingNodes.size()]);
                this._config.regenerateMissingPartitions(living, leaving);
                RedistributionPlan plan = new RedistributionPlan(living, leaving, this._numItems);
                this._log.trace((Object)"--------");
                this._log.trace((Object)"BEFORE:");
                this.printNodes(living, leaving);
                this._log.trace((Object)"--------");
                Map rvMap = this._config.getRendezVousMap();
                Quipu rv = new Quipu(0);
                String correlationId = this._dispatcher.nextCorrelationId();
                rvMap.put(correlationId, rv);
                this.execute(plan, correlationId, rv);
                try {
                    this._log.trace((Object)"WAITING ON RENDEZVOUS");
                    if (rv.waitFor(this._inactiveTime)) {
                        this._log.trace((Object)"RENDEZVOUS SUCCESSFUL");
                    } else {
                        this._log.warn((Object)"RENDEZVOUS FAILED");
                        ++failures;
                    }
                }
                catch (TimeoutException e) {
                    this._log.warn((Object)"timed out waiting for response", (Throwable)e);
                    ++failures;
                }
                catch (InterruptedException e) {
                    this._log.warn((Object)"unexpected interruption", (Throwable)e);
                    ++failures;
                }
                finally {
                    rvMap.remove(correlationId);
                }
                this._log.trace((Object)"--------");
                this._log.trace((Object)"AFTER:");
                this.printNodes(living, leaving);
                this._log.trace((Object)"--------");
            }
            Collection left = this._config.getLeft();
            for (int i2 = 0; i2 < leaving.length; ++i2) {
                Node node = leaving[i2];
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("sending evacuation response to: " + this._dispatcher.getNodeName(node.getDestination())));
                }
                if (left.contains(node.getDestination())) continue;
                PartitionEvacuationResponse response = new PartitionEvacuationResponse();
                if (!this._dispatcher.reply(this._cluster.getLocalNode().getDestination(), node.getDestination(), node.getName(), response)) {
                    if (this._log.isErrorEnabled()) {
                        this._log.error((Object)("problem sending EvacuationResponse to " + DIndex.getNodeName(node)));
                    }
                    ++failures;
                }
                left.add(node.getDestination());
            }
        }
        catch (Throwable t) {
            this._log.warn((Object)"problem rebalancing indeces", t);
            ++failures;
        }
        if (failures > 0) {
            if (this._log.isWarnEnabled()) {
                this._log.warn((Object)("rebalance failed - backing off for " + this._inactiveTime + " millis..."));
            }
            this.queueRebalancing();
        }
    }

    protected void execute(RedistributionPlan plan, String correlationId, Quipu quipu) {
        quipu.increment();
        Iterator p = plan.getProducers().iterator();
        Iterator c = plan.getConsumers().iterator();
        PartitionOwner consumer = null;
        while (p.hasNext()) {
            PartitionOwner producer = (PartitionOwner)p.next();
            ArrayList<PartitionTransfer> transfers = new ArrayList<PartitionTransfer>();
            while (producer._deviation > 0) {
                if (consumer == null) {
                    PartitionOwner partitionOwner = consumer = c.hasNext() ? (PartitionOwner)c.next() : null;
                }
                if (null == consumer) break;
                if (producer._deviation >= consumer._deviation) {
                    transfers.add(new PartitionTransfer(consumer._node.getDestination(), DIndex.getNodeName(consumer._node), consumer._deviation));
                    producer._deviation -= consumer._deviation;
                    consumer._deviation = 0;
                    consumer = null;
                    continue;
                }
                transfers.add(new PartitionTransfer(consumer._node.getDestination(), DIndex.getNodeName(consumer._node), producer._deviation));
                consumer._deviation -= producer._deviation;
                producer._deviation = 0;
            }
            PartitionTransferCommand command = new PartitionTransferCommand(transfers.toArray(new PartitionTransfer[transfers.size()]));
            quipu.increment();
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("sending plan to: " + this._dispatcher.getNodeName(producer._node.getDestination())));
            }
            if (this._dispatcher.send(this._cluster.getLocalNode().getDestination(), producer._node.getDestination(), correlationId, command)) continue;
            this._log.error((Object)"problem sending transfer command");
        }
        quipu.decrement();
    }

    protected int printNodes(Collection nodes) {
        int total = 0;
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            total += this.printNode((Node)i.next());
        }
        return total;
    }

    protected void printNodes(Node[] living, Node[] leaving) {
        int i;
        int total = 0;
        for (i = 0; i < living.length; ++i) {
            total += this.printNode(living[i]);
        }
        for (i = 0; i < leaving.length; ++i) {
            total += this.printNode(leaving[i]);
        }
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("TOTAL: " + total));
        }
    }

    protected int printNode(Node node) {
        if (node != this._cluster.getLocalNode()) {
            node = (Node)this._cluster.getNodes().get(node.getDestination());
        }
        if (node == null) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)(DIndex.getNodeName(node) + " : <unknown>"));
            }
            return 0;
        }
        PartitionKeys keys = DIndex.getPartitionKeys(node);
        int amount = keys.size();
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)(DIndex.getNodeName(node) + " : " + amount + " - " + keys));
        }
        return amount;
    }

    protected Node getNode(Destination destination) {
        LocalNode localNode = this._cluster.getLocalNode();
        Destination localDestination = localNode.getDestination();
        if (destination.equals(localDestination)) {
            return localNode;
        }
        return (Node)this._cluster.getNodes().get(destination);
    }
}

