/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.dindex.impl;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.dindex.DIndexRequest;
import org.codehaus.wadi.dindex.PartitionConfig;
import org.codehaus.wadi.dindex.impl.AbstractPartition;
import org.codehaus.wadi.dindex.messages.DIndexForwardRequest;
import org.codehaus.wadi.dindex.messages.DIndexRelocationRequest;
import org.codehaus.wadi.dindex.messages.DIndexRelocationResponse;
import org.codehaus.wadi.dindex.messages.RelocationRequest;
import org.codehaus.wadi.dindex.messages.RelocationResponse;
import org.codehaus.wadi.dindex.newmessages.DeleteIMToPM;
import org.codehaus.wadi.dindex.newmessages.DeletePMToIM;
import org.codehaus.wadi.dindex.newmessages.InsertIMToPM;
import org.codehaus.wadi.dindex.newmessages.InsertPMToIM;
import org.codehaus.wadi.dindex.newmessages.MoveIMToPM;
import org.codehaus.wadi.dindex.newmessages.MovePMToIM;
import org.codehaus.wadi.dindex.newmessages.MovePMToSM;
import org.codehaus.wadi.dindex.newmessages.MoveSMToPM;
import org.codehaus.wadi.gridstate.Dispatcher;

public class LocalPartition
extends AbstractPartition
implements Serializable {
    protected transient Log _log = LogFactory.getLog(this.getClass());
    protected transient Log _lockLog = LogFactory.getLog((String)"org.codehaus.wadi.LOCKS");
    protected Map _map = new HashMap();
    protected transient PartitionConfig _config;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LocalPartition(int key) {
        super(key);
    }

    protected LocalPartition() {
    }

    public void init(PartitionConfig config) {
        this._config = config;
        this._log = LogFactory.getLog((String)(this.getClass().getName() + "#" + this._key + "@" + this._config.getLocalNodeName()));
        this._lockLog = LogFactory.getLog((String)"org.codehaus.wadi.LOCKS");
    }

    public boolean isLocal() {
        return true;
    }

    public String toString() {
        return "<LocalPartition:" + this._key + "@" + (this._config == null ? "<unknown>" : this._config.getLocalNodeName()) + ">";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String name, Destination destination) {
        Map map = this._map;
        synchronized (map) {
            this._map.put(name, destination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ObjectMessage message, InsertIMToPM request) {
        Destination newDestination = null;
        try {
            newDestination = message.getJMSReplyTo();
        }
        catch (JMSException e) {
            this._log.error((Object)"unexpected problem", (Throwable)e);
        }
        boolean success = false;
        String key = request.getKey();
        Sync sync = null;
        try {
            if (this._lockLog.isTraceEnabled()) {
                this._lockLog.trace((Object)("Partition - acquiring: " + key + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
            }
            sync = this._config.getPMSyncs().acquire(key);
            if (this._lockLog.isTraceEnabled()) {
                this._lockLog.trace((Object)("Partition - acquired: " + key + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
            }
            Map map = this._map;
            synchronized (map) {
                if (!this._map.containsKey(key)) {
                    this._map.put(key, newDestination);
                    success = true;
                }
            }
            if (success) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("insert: " + key + " {" + this._config.getNodeName(newDestination) + "}"));
                }
            } else if (this._log.isWarnEnabled()) {
                this._log.warn((Object)("insert: {" + key + " {" + this._config.getNodeName(newDestination) + "} failed - key already in use"));
            }
            InsertPMToIM response = new InsertPMToIM(success);
            this._config.getDispatcher().reply(message, response);
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (this._lockLog.isTraceEnabled()) {
                this._lockLog.trace((Object)("Partition - releasing: " + key + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
            }
            sync.release();
            if (this._lockLog.isTraceEnabled()) {
                this._lockLog.trace((Object)("Partition - released: " + key + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
            }
            throw throwable;
        }
        if (this._lockLog.isTraceEnabled()) {
            this._lockLog.trace((Object)("Partition - releasing: " + key + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
        }
        sync.release();
        if (this._lockLog.isTraceEnabled()) {
            this._lockLog.trace((Object)("Partition - released: " + key + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ObjectMessage message, DeleteIMToPM request) {
        String key = request.getKey();
        Sync sync = null;
        try {
            Destination oldDestination;
            if (this._lockLog.isTraceEnabled()) {
                this._lockLog.trace((Object)("Partition - acquiring: " + key + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
            }
            sync = this._config.getPMSyncs().acquire(key);
            if (this._lockLog.isTraceEnabled()) {
                this._lockLog.trace((Object)("Partition - acquired: " + key + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
            }
            Map map = this._map;
            synchronized (map) {
                oldDestination = (Destination)this._map.remove(key);
            }
            if (oldDestination == null) {
                throw new IllegalStateException("session " + key + " is not known in this partition");
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("delete: " + key + " {" + this._config.getNodeName(oldDestination) + "}"));
            }
            DeletePMToIM response = new DeletePMToIM();
            this._config.getDispatcher().reply(message, response);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (this._lockLog.isTraceEnabled()) {
                this._lockLog.trace((Object)("Partition - releasing: " + key + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
            }
            sync.release();
            if (this._lockLog.isTraceEnabled()) {
                this._lockLog.trace((Object)("Partition - released: " + key + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
            }
            throw throwable;
        }
        if (this._lockLog.isTraceEnabled()) {
            this._lockLog.trace((Object)("Partition - releasing: " + key + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
        }
        sync.release();
        if (this._lockLog.isTraceEnabled()) {
            this._lockLog.trace((Object)("Partition - released: " + key + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ObjectMessage message, DIndexRelocationRequest request) {
        Destination newDestination = null;
        try {
            newDestination = message.getJMSReplyTo();
        }
        catch (JMSException e) {
            this._log.error((Object)"unexpected problem", (Throwable)e);
        }
        Destination oldDestination = null;
        Map map = this._map;
        synchronized (map) {
            oldDestination = this._map.put(request.getKey(), newDestination);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("relocation {" + request.getKey() + " : " + this._config.getNodeName(oldDestination) + " -> " + this._config.getNodeName(newDestination) + "}"));
        }
        DIndexRelocationResponse response = new DIndexRelocationResponse();
        this._config.getDispatcher().reply(message, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ObjectMessage message, DIndexForwardRequest request) {
        String name = request.getKey();
        Destination destination = null;
        Map map = this._map;
        synchronized (map) {
            destination = (Destination)this._map.get(name);
        }
        if (destination == null) {
            DIndexRequest r = request.getRequest();
            if (r instanceof RelocationRequest) {
                if (!$assertionsDisabled && message == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && name == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && this._config == null) {
                    throw new AssertionError();
                }
                this._config.getDispatcher().reply(message, new RelocationResponse(name));
            } else if (this._log.isWarnEnabled()) {
                this._log.warn((Object)("unexpected nested request structure - ignoring: " + r));
            }
        } else {
            if (!$assertionsDisabled && destination == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && request == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this._config == null) {
                throw new AssertionError();
            }
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("directing: " + request + " -> " + this._config.getNodeName(destination)));
            }
            if (!this._config.getDispatcher().forward(message, destination, request.getRequest())) {
                this._log.warn((Object)"could not forward message");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMessage(ObjectMessage message1, MoveIMToPM request) {
        Sync sync;
        String key;
        block21: {
            block20: {
                key = request.getKey();
                Dispatcher _dispatcher = this._config.getDispatcher();
                sync = null;
                try {
                    try {
                        Destination destination;
                        Destination im = message1.getJMSReplyTo();
                        if (this._lockLog.isTraceEnabled()) {
                            this._lockLog.trace((Object)("Partition - acquiring: " + key + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
                        }
                        sync = this._config.getPMSyncs().acquire(key);
                        if (this._lockLog.isTraceEnabled()) {
                            this._lockLog.trace((Object)("Partition - acquired: " + key + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
                        }
                        if ((destination = (Destination)this._map.get(key)) == null) {
                            _dispatcher.reply(message1, new MovePMToIM());
                            Object var16_9 = null;
                            break block20;
                        }
                        if (destination.equals(im)) {
                            this._log.warn((Object)"IM REQUESTING RELOCATION IS ALREADY SM");
                        }
                        Destination pm = _dispatcher.getLocalDestination();
                        Destination sm = destination;
                        String poCorrelationId = null;
                        try {
                            poCorrelationId = _dispatcher.getOutgoingCorrelationId(message1);
                        }
                        catch (Exception e) {
                            this._log.error((Object)"unexpected problem", (Throwable)e);
                        }
                        MovePMToSM request2 = new MovePMToSM(key, im, pm, poCorrelationId);
                        ObjectMessage message2 = _dispatcher.exchangeSend(pm, sm, request2, this._config.getInactiveTime());
                        if (message2 == null) {
                            this._log.error((Object)"NO RESPONSE WITHIN TIMEFRAME - PANIC!");
                        }
                        MoveSMToPM response = null;
                        try {
                            response = (MoveSMToPM)message2.getObject();
                        }
                        catch (JMSException e) {
                            this._log.error((Object)"unexpected problem", (Throwable)e);
                        }
                        if (response.getSuccess()) {
                            Destination oldOwner = this._map.put(key, im);
                            this._log.debug((Object)("move: " + key + " {" + this._config.getNodeName(oldOwner) + "->" + this._config.getNodeName(im) + "}"));
                            break block21;
                        } else {
                            this._log.warn((Object)("state relocation failed: " + key));
                        }
                        break block21;
                    }
                    catch (JMSException e) {
                        this._log.error((Object)"could not read src address from incoming message");
                        Object var16_11 = null;
                        if (this._lockLog.isTraceEnabled()) {
                            this._lockLog.trace((Object)("Partition - releasing: " + key + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
                        }
                        sync.release();
                        if (!this._lockLog.isTraceEnabled()) return;
                        this._lockLog.trace((Object)("Partition - released: " + key + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var16_12 = null;
                    if (this._lockLog.isTraceEnabled()) {
                        this._lockLog.trace((Object)("Partition - releasing: " + key + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
                    }
                    sync.release();
                    if (!this._lockLog.isTraceEnabled()) throw throwable;
                    this._lockLog.trace((Object)("Partition - released: " + key + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
                    throw throwable;
                }
            }
            if (this._lockLog.isTraceEnabled()) {
                this._lockLog.trace((Object)("Partition - releasing: " + key + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
            }
            sync.release();
            if (!this._lockLog.isTraceEnabled()) return;
            this._lockLog.trace((Object)("Partition - released: " + key + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
            return;
        }
        Object var16_10 = null;
        if (this._lockLog.isTraceEnabled()) {
            this._lockLog.trace((Object)("Partition - releasing: " + key + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
        }
        sync.release();
        if (!this._lockLog.isTraceEnabled()) return;
        this._lockLog.trace((Object)("Partition - released: " + key + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
    }

    public ObjectMessage exchange(DIndexRequest request, long timeout) throws Exception {
        Destination from;
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"local dispatch - needs optimisation");
        }
        Dispatcher dispatcher = this._config.getDispatcher();
        Destination to = from = dispatcher.getLocalDestination();
        return dispatcher.exchangeSend(from, to, request, timeout);
    }

    static {
        $assertionsDisabled = !LocalPartition.class.desiredAssertionStatus();
    }
}

