/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.dindex.impl;

import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import javax.jms.Destination;
import javax.jms.ObjectMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.dindex.DIndexRequest;
import org.codehaus.wadi.dindex.Partition;
import org.codehaus.wadi.dindex.PartitionConfig;
import org.codehaus.wadi.dindex.impl.AbstractPartition;
import org.codehaus.wadi.dindex.impl.RemotePartition;
import org.codehaus.wadi.dindex.messages.DIndexForwardRequest;
import org.codehaus.wadi.dindex.messages.DIndexRelocationRequest;
import org.codehaus.wadi.dindex.newmessages.DeleteIMToPM;
import org.codehaus.wadi.dindex.newmessages.InsertIMToPM;
import org.codehaus.wadi.dindex.newmessages.MoveIMToPM;
import org.codehaus.wadi.gridstate.Dispatcher;

public class PartitionFacade
extends AbstractPartition {
    protected final ReadWriteLock _lock = new WriterPreferenceReadWriteLock();
    protected final LinkedQueue _queue = new LinkedQueue();
    protected final PartitionConfig _config;
    protected final Log _log;
    protected long _timeStamp;
    protected Partition _content;

    public PartitionFacade(int key, long timeStamp, Partition content, boolean queueing, PartitionConfig config) {
        super(key);
        this._config = config;
        this._timeStamp = timeStamp;
        this._content = content;
        this._log = LogFactory.getLog((String)(this.getClass().getName() + "#" + this._key + "@" + this._config.getLocalNodeName()));
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("initialising location to: " + this._content));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocal() {
        Sync sync = this._lock.writeLock();
        boolean acquired = false;
        try {
            sync.acquire();
            acquired = true;
            boolean bl = this._content.isLocal();
            return bl;
        }
        catch (InterruptedException e) {
            this._log.warn((Object)"unexpected problem", (Throwable)e);
        }
        finally {
            if (acquired) {
                sync.release();
            }
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Partition getContent() {
        Sync sync = this._lock.writeLock();
        boolean acquired = false;
        try {
            sync.acquire();
            acquired = true;
            Partition partition = this._content;
            return partition;
        }
        catch (InterruptedException e) {
            this._log.warn((Object)"unexpected problem", (Throwable)e);
        }
        finally {
            if (acquired) {
                sync.release();
            }
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(long timeStamp, Partition content) {
        Sync sync = this._lock.writeLock();
        boolean acquired = false;
        try {
            sync.acquire();
            acquired = true;
            if (timeStamp > this._timeStamp) {
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("[" + this._key + "] changing location from: " + this._content + " to: " + content));
                }
                this._timeStamp = timeStamp;
                this._content = content;
            }
        }
        catch (InterruptedException e) {
            this._log.warn((Object)"unexpected problem", (Throwable)e);
        }
        finally {
            if (acquired) {
                sync.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContentRemote(long timeStamp, Dispatcher dispatcher, Destination location) {
        Sync sync = this._lock.writeLock();
        boolean acquired = false;
        try {
            sync.acquire();
            acquired = true;
            if (timeStamp > this._timeStamp) {
                this._timeStamp = timeStamp;
                if (this._content instanceof RemotePartition) {
                    ((RemotePartition)this._content).setLocation(location);
                } else {
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("[" + this._key + "] changing location from: " + this._content + " to: " + location));
                    }
                    this._content = new RemotePartition(this._key, this._config, location);
                }
            }
        }
        catch (InterruptedException e) {
            this._log.warn((Object)"unexpected problem", (Throwable)e);
        }
        finally {
            if (acquired) {
                sync.release();
            }
        }
    }

    public ObjectMessage exchange(DIndexRequest request, long timeout) throws Exception {
        return this._content.exchange(request, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ObjectMessage message, InsertIMToPM request) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("dispatching: " + request + " on " + this._content));
        }
        Sync sync = this._lock.readLock();
        boolean acquired = false;
        try {
            sync.acquire();
            acquired = true;
            this._content.onMessage(message, request);
        }
        catch (InterruptedException e) {
            this._log.warn((Object)"unexpected problem", (Throwable)e);
        }
        finally {
            if (acquired) {
                sync.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ObjectMessage message, DeleteIMToPM request) {
        Sync sync = this._lock.readLock();
        boolean acquired = false;
        try {
            sync.acquire();
            acquired = true;
            this._content.onMessage(message, request);
        }
        catch (InterruptedException e) {
            this._log.warn((Object)"unexpected problem", (Throwable)e);
        }
        finally {
            if (acquired) {
                sync.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ObjectMessage message, DIndexRelocationRequest request) {
        Sync sync = this._lock.readLock();
        boolean acquired = false;
        try {
            sync.acquire();
            acquired = true;
            this._content.onMessage(message, request);
        }
        catch (InterruptedException e) {
            this._log.warn((Object)"unexpected problem", (Throwable)e);
        }
        finally {
            if (acquired) {
                sync.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ObjectMessage message, MoveIMToPM request) {
        Sync sync = this._lock.readLock();
        boolean acquired = false;
        try {
            sync.acquire();
            acquired = true;
            this._content.onMessage(message, request);
        }
        catch (InterruptedException e) {
            this._log.warn((Object)"unexpected problem", (Throwable)e);
        }
        finally {
            if (acquired) {
                sync.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ObjectMessage message, DIndexForwardRequest request) {
        Sync sync = this._lock.readLock();
        boolean acquired = false;
        try {
            sync.acquire();
            acquired = true;
            this._content.onMessage(message, request);
        }
        catch (InterruptedException e) {
            this._log.warn((Object)"unexpected problem", (Throwable)e);
        }
        finally {
            if (acquired) {
                sync.release();
            }
        }
    }
}

