/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.dindex.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.activecluster.Node;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.dindex.impl.DIndex;
import org.codehaus.wadi.dindex.impl.PartitionOwner;
import org.codehaus.wadi.dindex.impl.PartitionOwnerGreaterThanComparator;
import org.codehaus.wadi.dindex.impl.PartitionOwnerLessThanComparator;

public class RedistributionPlan {
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected final List _producers = new ArrayList();
    protected final List _consumers = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public RedistributionPlan(Node[] living, Node[] leaving, int totalNumPartitions) {
        int numPartitions;
        Node node;
        int i;
        int numPartitionsPerNode = totalNumPartitions / living.length;
        for (i = 0; i < leaving.length; ++i) {
            node = leaving[i];
            numPartitions = DIndex.getPartitionKeys(node).size();
            if (numPartitions <= 0) continue;
            this._producers.add(new PartitionOwner(node, numPartitions, true));
        }
        for (i = 0; i < living.length; ++i) {
            node = living[i];
            numPartitions = DIndex.getPartitionKeys(node).size();
            this.decide(node, numPartitions, numPartitionsPerNode, this._producers, this._consumers);
        }
        Collections.sort(this._producers, new PartitionOwnerGreaterThanComparator());
        Collections.sort(this._consumers, new PartitionOwnerLessThanComparator());
        int remainingPartitions = totalNumPartitions % living.length;
        ListIterator i2 = this._producers.listIterator();
        while (remainingPartitions > 0 && i2.hasNext()) {
            PartitionOwner p = (PartitionOwner)i2.next();
            if (p._leaving) continue;
            --remainingPartitions;
            if (--p._deviation != 0) continue;
            i2.remove();
        }
        i2 = this._consumers.listIterator();
        while (remainingPartitions > 0 && i2.hasNext()) {
            PartitionOwner p = (PartitionOwner)i2.next();
            --remainingPartitions;
            ++p._deviation;
        }
        if (!$assertionsDisabled && remainingPartitions != 0) {
            throw new AssertionError();
        }
    }

    protected void decide(Node node, int numPartitions, int numPartitionsPerNode, Collection producers, Collection consumers) {
        int deviation = numPartitions - numPartitionsPerNode;
        if (deviation > 0) {
            producers.add(new PartitionOwner(node, deviation, false));
            return;
        }
        if (deviation < 0) {
            consumers.add(new PartitionOwner(node, -deviation, false));
            return;
        }
    }

    public Collection getProducers() {
        return this._producers;
    }

    public Collection getConsumers() {
        return this._consumers;
    }

    static {
        $assertionsDisabled = !RedistributionPlan.class.desiredAssertionStatus();
    }
}

