/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.dindex.impl;

import javax.jms.Destination;
import javax.jms.ObjectMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.dindex.DIndexRequest;
import org.codehaus.wadi.dindex.PartitionConfig;
import org.codehaus.wadi.dindex.impl.AbstractPartition;
import org.codehaus.wadi.dindex.messages.DIndexForwardRequest;
import org.codehaus.wadi.dindex.messages.DIndexRelocationRequest;
import org.codehaus.wadi.dindex.newmessages.DeleteIMToPM;
import org.codehaus.wadi.dindex.newmessages.InsertIMToPM;
import org.codehaus.wadi.dindex.newmessages.MoveIMToPM;
import org.codehaus.wadi.gridstate.Dispatcher;

public class RemotePartition
extends AbstractPartition {
    protected transient Log _log;
    protected final PartitionConfig _config;
    protected Destination _location;

    public RemotePartition(int key, PartitionConfig config, Destination location) {
        super(key);
        this._config = config;
        this._location = location;
        this._log = LogFactory.getLog((String)(this.getClass().getName() + "#" + this._key + "@" + this._config.getLocalNodeName()));
    }

    public boolean isLocal() {
        return false;
    }

    public Destination getDestination() {
        return this._location;
    }

    public void setLocation(Destination location) {
        if (this._location == null) {
            if (location != null) {
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("[" + this._key + "] updating location from: " + this._config.getNodeName(this._location) + " to: " + this._config.getNodeName(location)));
                }
                this._location = location;
            }
        } else if (!this._location.equals(location)) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("[" + this._key + "] updating location from: " + this._config.getNodeName(this._location) + " to: " + this._config.getNodeName(location)));
            }
            this._location = location;
        }
    }

    public String toString() {
        return "<" + this.getClass() + ":" + this._key + "@" + this._config.getLocalNodeName() + "->" + this._config.getNodeName(this._location) + ">";
    }

    public void onMessage(ObjectMessage message, InsertIMToPM request) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("#" + this._key + " : forwarding: " + request + " from " + this._config.getLocalNodeName() + " to " + this._config.getNodeName(this._location)));
        }
        if (!this._config.getDispatcher().forward(message, this._location)) {
            this._log.warn((Object)"could not forward message");
        }
    }

    public void onMessage(ObjectMessage message, DeleteIMToPM request) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("indirecting: " + request + " via " + this._config.getNodeName(this._location)));
        }
        if (!this._config.getDispatcher().forward(message, this._location)) {
            this._log.warn((Object)"could not forward message");
        }
    }

    public void onMessage(ObjectMessage message, DIndexRelocationRequest request) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("indirecting: " + request + " via " + this._config.getNodeName(this._location)));
        }
        if (!this._config.getDispatcher().forward(message, this._location)) {
            this._log.warn((Object)"could not forward message");
        }
    }

    public void onMessage(ObjectMessage message, DIndexForwardRequest request) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("indirecting: " + request + " via " + this._config.getNodeName(this._location)));
        }
        if (!this._config.getDispatcher().forward(message, this._location)) {
            this._log.warn((Object)"could not forward message");
        }
    }

    public void onMessage(ObjectMessage message, MoveIMToPM request) {
        if (this._log.isWarnEnabled()) {
            this._log.warn((Object)(this._config.getLocalNodeName() + ": not Master of Partition[" + this._key + "] - forwarding message to " + this._config.getNodeName(this._location)));
        }
        if (!this._config.getDispatcher().forward(message, this._location)) {
            this._log.warn((Object)"could not forward message");
        }
    }

    public ObjectMessage exchange(DIndexRequest request, long timeout) throws Exception {
        Dispatcher dispatcher = this._config.getDispatcher();
        Destination from = dispatcher.getLocalDestination();
        Destination to = this._location;
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("exchanging message (" + request + ") with node: " + this._config.getNodeName(to) + " on " + Thread.currentThread().getName()));
        }
        return dispatcher.exchangeSend(from, to, request, timeout);
    }
}

