/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.dindex.impl;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import java.nio.ByteBuffer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.Immoter;
import org.codehaus.wadi.InvocationContext;
import org.codehaus.wadi.InvocationException;
import org.codehaus.wadi.Location;
import org.codehaus.wadi.Motable;
import org.codehaus.wadi.dindex.StateManager;
import org.codehaus.wadi.dindex.StateManagerConfig;
import org.codehaus.wadi.dindex.impl.RemotePartition;
import org.codehaus.wadi.dindex.messages.DIndexForwardRequest;
import org.codehaus.wadi.dindex.messages.DIndexRelocationRequest;
import org.codehaus.wadi.dindex.messages.DIndexRelocationResponse;
import org.codehaus.wadi.dindex.newmessages.DeleteIMToPM;
import org.codehaus.wadi.dindex.newmessages.DeletePMToIM;
import org.codehaus.wadi.dindex.newmessages.InsertIMToPM;
import org.codehaus.wadi.dindex.newmessages.InsertPMToIM;
import org.codehaus.wadi.dindex.newmessages.MoveIMToPM;
import org.codehaus.wadi.dindex.newmessages.MoveIMToSM;
import org.codehaus.wadi.dindex.newmessages.MovePMToIM;
import org.codehaus.wadi.dindex.newmessages.MovePMToSM;
import org.codehaus.wadi.dindex.newmessages.MoveSMToIM;
import org.codehaus.wadi.dindex.newmessages.MoveSMToPM;
import org.codehaus.wadi.dindex.newmessages.ReleaseEntryRequest;
import org.codehaus.wadi.dindex.newmessages.ReleaseEntryResponse;
import org.codehaus.wadi.gridstate.Dispatcher;
import org.codehaus.wadi.impl.AbstractMotable;
import org.codehaus.wadi.impl.RankedRWLock;
import org.codehaus.wadi.impl.SimpleMotable;
import org.codehaus.wadi.impl.Utils;

public class SimpleStateManager
implements StateManager {
    protected final Log _lockLog = LogFactory.getLog((String)"org.codehaus.wadi.LOCKS");
    protected final Dispatcher _dispatcher;
    protected final long _inactiveTime;
    protected final int _resTimeout = 500;
    protected StateManagerConfig _config;
    protected Log _log = LogFactory.getLog(this.getClass());
    protected StateManager.ImmigrationListener _listener;

    public SimpleStateManager(Dispatcher dispatcher, long inactiveTime) {
        this._dispatcher = dispatcher;
        this._inactiveTime = inactiveTime;
    }

    public void init(StateManagerConfig config) {
        this._config = config;
        this._log = LogFactory.getLog((String)(this.getClass().getName() + "#" + this._config.getLocalNodeName()));
        this._dispatcher.register(this, "onDIndexInsertionRequest", InsertIMToPM.class);
        this._dispatcher.register(InsertPMToIM.class, this._inactiveTime);
        this._dispatcher.register(this, "onDIndexDeletionRequest", DeleteIMToPM.class);
        this._dispatcher.register(DeletePMToIM.class, this._inactiveTime);
        this._dispatcher.register(this, "onDIndexRelocationRequest", DIndexRelocationRequest.class);
        this._dispatcher.register(DIndexRelocationResponse.class, this._inactiveTime);
        this._dispatcher.register(this, "onDIndexForwardRequest", DIndexForwardRequest.class);
        this._dispatcher.register(this, "onMessage", MoveIMToPM.class);
        this._dispatcher.register(this, "onMessage", MovePMToSM.class);
        this._dispatcher.register(MoveSMToIM.class, this._inactiveTime);
        this._dispatcher.register(MoveIMToSM.class, this._inactiveTime);
        this._dispatcher.register(MoveSMToPM.class, this._inactiveTime);
        this._dispatcher.register(MovePMToIM.class, this._inactiveTime);
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        this._dispatcher.deregister("onDIndexInsertionRequest", InsertIMToPM.class, 5000);
        this._dispatcher.deregister("onDIndexDeletionRequest", DeleteIMToPM.class, 5000);
        this._dispatcher.deregister("onDIndexRelocationRequest", DIndexRelocationRequest.class, 5000);
        this._dispatcher.deregister("onDIndexForwardRequest", DIndexForwardRequest.class, 5000);
    }

    public void onDIndexInsertionRequest(ObjectMessage om, InsertIMToPM request) {
        this._config.getPartition(request.getKey()).onMessage(om, request);
    }

    public void onDIndexDeletionRequest(ObjectMessage om, DeleteIMToPM request) {
        this._config.getPartition(request.getKey()).onMessage(om, request);
    }

    public void onDIndexForwardRequest(ObjectMessage om, DIndexForwardRequest request) {
        this._config.getPartition(request.getKey()).onMessage(om, request);
    }

    public void onDIndexRelocationRequest(ObjectMessage om, DIndexRelocationRequest request) {
        this._config.getPartition(request.getKey()).onMessage(om, request);
    }

    public void onMessage(ObjectMessage message, MoveIMToPM request) {
        this._config.getPartition(request.getKey()).onMessage(message, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ObjectMessage message1, MovePMToSM request) {
        Object key = request.getKey();
        RankedRWLock.setPriority(4);
        try {
            Destination im = request.getIM();
            String imName = this._config.getNodeName(im);
            RelocationImmoter promoter = new RelocationImmoter(imName, message1, request);
            this._config.contextualise(null, (String)key, promoter, null, true);
            if (!promoter.getFound()) {
                this._log.warn((Object)("state not found - perhaps it has just been destroyed: " + key));
                MoveSMToIM req = new MoveSMToIM(key, null);
                Destination sm = this._dispatcher.getLocalDestination();
                long timeout = this._config.getInactiveTime();
                this._log.info((Object)("sending 0 bytes to : " + imName));
                ObjectMessage ignore = this._dispatcher.exchangeSend(sm, im, req, timeout, request.getIMCorrelationId());
                this._log.info((Object)("received: " + ignore));
                this._log.info((Object)"reporting failure to PM");
                this._dispatcher.reply(message1, new MoveSMToPM(false));
            }
        }
        catch (Exception e) {
            if (this._log.isWarnEnabled()) {
                this._log.warn((Object)("problem handling relocation request: " + key), (Throwable)e);
            }
        }
        finally {
            RankedRWLock.setPriority(0);
        }
    }

    public boolean offerEmigrant(String key, Motable emotable, long timeout) {
        Destination to = ((RemotePartition)this._config.getPartition(key).getContent()).getDestination();
        Destination from = this._dispatcher.getLocalDestination();
        ReleaseEntryRequest request = new ReleaseEntryRequest(emotable);
        ObjectMessage message = this._dispatcher.exchangeSend(from, to, request, timeout);
        ReleaseEntryResponse ack = null;
        try {
            ack = message == null ? null : (ReleaseEntryResponse)message.getObject();
        }
        catch (JMSException e) {
            this._log.error((Object)"could not unpack response", (Throwable)e);
        }
        if (ack == null) {
            if (this._log.isWarnEnabled()) {
                this._log.warn((Object)("no acknowledgement within timeframe (" + timeout + " millis): " + key));
            }
            return false;
        }
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("received acknowledgement within timeframe (" + timeout + " millis): " + key));
        }
        return true;
    }

    public void acceptImmigrant(ObjectMessage message, Location location, String name, Motable motable) {
        if (!this._dispatcher.reply(message, new ReleaseEntryResponse(name, location)) && this._log.isErrorEnabled()) {
            this._log.error((Object)("could not acknowledge safe receipt: " + name));
        }
    }

    public void setImmigrationListener(StateManager.ImmigrationListener listener) {
        this._dispatcher.register(this, "onEmigrationRequest", ReleaseEntryRequest.class);
        this._dispatcher.register(ReleaseEntryResponse.class, 500L);
        this._listener = listener;
    }

    public void unsetImmigrationListener(StateManager.ImmigrationListener listener) {
        if (this._listener == listener) {
            this._listener = null;
        }
    }

    public void onEmigrationRequest(ObjectMessage message, ReleaseEntryRequest request) {
        this._listener.onImmigration(message, request.getMotable());
    }

    class RelocationImmoter
    implements Immoter {
        protected final Log _log = LogFactory.getLog(this.getClass());
        protected final String _tgtNodeName;
        protected ObjectMessage _message;
        protected final MovePMToSM _request;
        protected boolean _found = false;
        protected Sync _invocationLock;

        public RelocationImmoter(String nodeName, ObjectMessage message, MovePMToSM request) {
            this._tgtNodeName = nodeName;
            this._message = message;
            this._request = request;
        }

        public Motable nextMotable(String name, Motable emotable) {
            return new PMToIMEmotable(name, this._tgtNodeName, this._message, this._request);
        }

        public boolean prepare(String name, Motable emotable, Motable immotable) {
            this._invocationLock = SimpleStateManager.this._config.getInvocationLock(name);
            try {
                if (SimpleStateManager.this._lockLog.isTraceEnabled()) {
                    SimpleStateManager.this._lockLog.trace((Object)("Invocation - acquiring: " + name + " [" + Thread.currentThread().getName() + "]" + " : " + this._invocationLock));
                }
                Utils.acquireUninterrupted(this._invocationLock);
                if (SimpleStateManager.this._lockLog.isTraceEnabled()) {
                    SimpleStateManager.this._lockLog.trace((Object)("Invocation - acquired: " + name + " [" + Thread.currentThread().getName() + "]" + " : " + this._invocationLock));
                }
            }
            catch (TimeoutException e) {
                if (SimpleStateManager.this._lockLog.isTraceEnabled()) {
                    SimpleStateManager.this._lockLog.trace((Object)("Invocation - not acquired: " + name + " [" + Thread.currentThread().getName() + "]" + " : " + this._invocationLock));
                }
                this._log.error((Object)"unexpected timeout - proceding without lock", (Throwable)e);
            }
            return true;
        }

        public void commit(String name, Motable immotable) {
            this._found = true;
            if (SimpleStateManager.this._lockLog.isTraceEnabled()) {
                SimpleStateManager.this._lockLog.trace((Object)("Invocation - releasing: " + name + " [" + Thread.currentThread().getName() + "]" + " : " + this._invocationLock));
            }
            this._invocationLock.release();
            if (SimpleStateManager.this._lockLog.isTraceEnabled()) {
                SimpleStateManager.this._lockLog.trace((Object)("Invocation - released: " + name + " [" + Thread.currentThread().getName() + "]" + " : " + this._invocationLock));
            }
        }

        public void rollback(String name, Motable immotable) {
        }

        public boolean contextualise(InvocationContext invocationContext, String id, Motable immotable, Sync motionLock) throws InvocationException {
            return false;
        }

        public String getInfo() {
            return "emigration:" + this._tgtNodeName;
        }

        public boolean getFound() {
            return this._found;
        }
    }

    class PMToIMEmotable
    extends AbstractMotable {
        protected final String _name;
        protected final String _tgtNodeName;
        protected ObjectMessage _message1;
        protected final MovePMToSM _get;

        public PMToIMEmotable(String name, String nodeName, ObjectMessage message1, MovePMToSM get) {
            this._name = name;
            this._tgtNodeName = nodeName;
            this._message1 = message1;
            this._get = get;
        }

        public byte[] getBodyAsByteArray() throws Exception {
            throw new UnsupportedOperationException();
        }

        public void setBodyAsByteArray(byte[] bytes) throws Exception {
            ObjectMessage message2;
            SimpleMotable immotable = new SimpleMotable();
            immotable.setBodyAsByteArray(bytes);
            Object key = this._get.getKey();
            Dispatcher dispatcher = SimpleStateManager.this._config.getDispatcher();
            long timeout = SimpleStateManager.this._config.getInactiveTime();
            Destination sm = dispatcher.getLocalDestination();
            Destination im = this._get.getIM();
            MoveSMToIM request = new MoveSMToIM(key, bytes);
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("exchanging MoveSMToIM between: " + SimpleStateManager.this._config.getNodeName(sm) + "->" + SimpleStateManager.this._config.getNodeName(im)));
            }
            if ((message2 = dispatcher.exchangeSend(sm, im, request, timeout, this._get.getIMCorrelationId())) == null) {
                _log.error((Object)"NO REPLY RECEIVED FOR MESSAGE IN TIMEFRAME - PANIC!");
            } else {
                dispatcher.reply(this._message1, new MoveSMToPM(true));
            }
        }

        public ByteBuffer getBodyAsByteBuffer() throws Exception {
            throw new UnsupportedOperationException();
        }

        public void setBodyAsByteBuffer(ByteBuffer body) throws Exception {
            throw new UnsupportedOperationException();
        }
    }
}

