/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.gridstate.activecluster;

import java.util.Timer;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import org.activecluster.Cluster;
import org.activecluster.LocalNode;
import org.activecluster.impl.DefaultClusterFactory;
import org.activecluster.impl.ReplicatedLocalNode;
import org.activecluster.impl.StateService;
import org.activecluster.impl.StateServiceStub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.gridstate.activecluster.CustomCluster;

public class CustomClusterFactory
extends DefaultClusterFactory {
    protected static final Log log = LogFactory.getLog((Class)CustomClusterFactory.class);

    public CustomClusterFactory(ConnectionFactory connectionFactory) {
        super(connectionFactory);
        System.setProperty("activemq.broker.disable-clean-shutdown", "true");
    }

    protected Cluster createCluster(Connection connection, Session session, Topic groupDestination) throws JMSException {
        Topic dataTopic = session.createTopic(this.getDataTopicPrefix() + groupDestination.getTopicName());
        if (log.isInfoEnabled()) {
            log.info((Object)("Creating cluster group producer on topic: " + groupDestination));
        }
        MessageProducer producer = this.createProducer(session, null);
        producer.setDeliveryMode(this.getDeliveryMode());
        if (log.isInfoEnabled()) {
            log.info((Object)("Creating cluster data producer on topic: " + dataTopic));
        }
        MessageProducer keepAliveProducer = session.createProducer((Destination)dataTopic);
        keepAliveProducer.setDeliveryMode(1);
        StateServiceStub serviceStub = new StateServiceStub(session, keepAliveProducer);
        Object localInbox = null;
        localInbox = this.isUseQueueForInbox() ? session.createTemporaryQueue() : session.createTemporaryTopic();
        ReplicatedLocalNode localNode = new ReplicatedLocalNode((Destination)localInbox, (StateService)serviceStub);
        Timer timer = new Timer();
        CustomCluster answer = new CustomCluster((LocalNode)localNode, dataTopic, groupDestination, connection, session, producer, timer, this.getInactiveTime());
        return answer;
    }
}

