/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.gridstate.activecluster;

import java.io.Serializable;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.activecluster.ClusterFactory;
import org.activecluster.ClusterListener;
import org.activecluster.LocalNode;
import org.activecluster.election.ElectionStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.gridstate.ExtendedCluster;

public class RestartableCluster
implements ExtendedCluster {
    protected static final Log _log = LogFactory.getLog((Class)RestartableCluster.class);
    protected final ClusterFactory _factory;
    protected final Topic _groupDestination;
    protected final String _topic;
    protected ExtendedCluster _cluster;

    public RestartableCluster(ClusterFactory factory, Topic groupDestination) {
        this._factory = factory;
        this._groupDestination = groupDestination;
        this._topic = null;
        this.ensureCluster();
    }

    public RestartableCluster(ClusterFactory factory, String topic) {
        this._factory = factory;
        this._groupDestination = null;
        this._topic = topic;
        this.ensureCluster();
    }

    public Topic getDestination() {
        return this._cluster.getDestination();
    }

    public Map getNodes() {
        return this._cluster.getNodes();
    }

    public void addClusterListener(ClusterListener listener) {
        this.ensureCluster();
        this._cluster.addClusterListener(listener);
    }

    public void removeClusterListener(ClusterListener listener) {
        this.ensureCluster();
        this._cluster.removeClusterListener(listener);
    }

    public LocalNode getLocalNode() {
        return this._cluster.getLocalNode();
    }

    public void send(Destination destination, Message message) throws JMSException {
        this._cluster.send(destination, message);
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this._cluster.createConsumer(destination);
    }

    public MessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        return this._cluster.createConsumer(destination, selector);
    }

    public MessageConsumer createConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        return this._cluster.createConsumer(destination, selector, noLocal);
    }

    public Message createMessage() throws JMSException {
        return this._cluster.createMessage();
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this._cluster.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this._cluster.createMapMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this._cluster.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return this._cluster.createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this._cluster.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this._cluster.createTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        return this._cluster.createTextMessage(text);
    }

    public boolean waitForClusterToComplete(int expectedCount, long timeout) throws InterruptedException {
        return this._cluster.waitForClusterToComplete(expectedCount, timeout);
    }

    protected void createCluster() {
        try {
            this._cluster = this._groupDestination != null ? (ExtendedCluster)this._factory.createCluster(this._groupDestination) : (ExtendedCluster)this._factory.createCluster(this._topic);
        }
        catch (Exception e) {
            _log.error((Object)"could not start Cluster", (Throwable)e);
        }
    }

    protected synchronized void ensureCluster() {
        if (this._cluster == null) {
            this.createCluster();
        }
    }

    public void start() throws JMSException {
        this.ensureCluster();
        this._cluster.start();
    }

    public void stop() throws JMSException {
        this._cluster.stop();
        this._cluster = null;
    }

    public Connection getConnection() {
        return this._cluster.getConnection();
    }

    public void setElectionStrategy(ElectionStrategy strategy) {
        this._cluster.setElectionStrategy(strategy);
    }
}

