/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.gridstate.impl;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheEntry;
import javax.cache.CacheException;
import javax.cache.CacheListener;
import javax.cache.CacheStatistics;
import javax.jms.Destination;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.gridstate.Dispatcher;
import org.codehaus.wadi.gridstate.DispatcherConfig;
import org.codehaus.wadi.gridstate.LockManager;
import org.codehaus.wadi.gridstate.PartitionConfig;
import org.codehaus.wadi.gridstate.PartitionManager;
import org.codehaus.wadi.gridstate.PartitionManagerConfig;
import org.codehaus.wadi.gridstate.StateManager;
import org.codehaus.wadi.gridstate.StateManagerConfig;
import org.codehaus.wadi.gridstate.impl.PartitionFacade;
import org.codehaus.wadi.gridstate.impl.StupidLockManager;

public class GCache
implements Cache,
DispatcherConfig,
StateManagerConfig,
PartitionManagerConfig {
    protected final Log _log = LogFactory.getLog((String)this.getClass().getName());
    protected final Dispatcher _dispatcher;
    protected final PartitionManager _partitionManager;
    protected final StateManager _stateManager;
    protected final Map _map = new HashMap();
    protected final LockManager _pmSyncs = new StupidLockManager("PM");
    protected final LockManager _smSyncs = new StupidLockManager("IM/SM");
    protected ThreadLocal _threadLocks = new ThreadLocal(){

        public Object initialValue() {
            return new HashMap();
        }
    };

    public void release() {
        Iterator i = ((Map)this._threadLocks.get()).entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object key = entry.getKey();
            Sync sync = (Sync)entry.getValue();
            sync.release();
            i.remove();
            if (!this._log.isInfoEnabled()) continue;
            this._log.info((Object)("released: " + key));
        }
    }

    protected void addLock(Object key, Sync newSync) {
        Map locks = (Map)this._threadLocks.get();
        Sync oldSync = (Sync)locks.get(key);
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("adding: " + key));
        }
        if (oldSync == null) {
            locks.put(key, newSync);
        } else if (this._log.isWarnEnabled()) {
            this._log.warn((Object)"NYI...");
        }
    }

    public GCache(Dispatcher dispatcher, PartitionManager partitionManager, StateManager stateManager) throws Exception {
        this._dispatcher = dispatcher;
        this._dispatcher.init(this);
        this._partitionManager = partitionManager;
        this._stateManager = stateManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        Map map = this._map;
        synchronized (map) {
            return this._map.containsKey(key);
        }
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map t) {
    }

    public int size() {
        return this.getCacheStatistics().getObjectCount();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object key) {
        return this._stateManager.get(key);
    }

    public Map getAll(Collection keys) throws CacheException {
        throw new UnsupportedOperationException();
    }

    public void load(Object key) throws CacheException {
        throw new UnsupportedOperationException();
    }

    public void loadAll(Collection keys) throws CacheException {
        throw new UnsupportedOperationException();
    }

    public Object peek(Object key) {
        return null;
    }

    public Object put(Object key, Object value) {
        return this.put(key, value, true, true);
    }

    public boolean putFirst(Object key, Object value) {
        return (Boolean)this.put(key, value, false, true);
    }

    public Object put(Object key, Object value, boolean overwrite, boolean returnOldValue) {
        return this._stateManager.put(key, value, overwrite, returnOldValue);
    }

    public CacheEntry getCacheEntry(Object key) {
        return null;
    }

    public CacheStatistics getCacheStatistics() {
        return null;
    }

    public Object remove(Object key) {
        return this._stateManager.remove(key, true);
    }

    public Object remove(Object key, boolean returnOldValue) {
        return this._stateManager.remove(key, returnOldValue);
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void evict() {
    }

    public void addListener(CacheListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeListener(CacheListener listener) {
        throw new UnsupportedOperationException();
    }

    public PartitionFacade[] getPartitions() {
        return this._partitionManager.getPartitions();
    }

    public Map getMap() {
        return this._map;
    }

    public LockManager getPMSyncs() {
        return this._pmSyncs;
    }

    public LockManager getSMSyncs() {
        return this._smSyncs;
    }

    public PartitionConfig getPartitionConfig() {
        return this._partitionManager;
    }

    public PartitionManager getPartitionManager() {
        return this._partitionManager;
    }

    public StateManager getStateManager() {
        return this._stateManager;
    }

    public void start() throws Exception {
        this._partitionManager.start();
        this._stateManager.start();
    }

    public void stop() throws Exception {
        this._stateManager.stop();
        this._partitionManager.stop();
    }

    public PartitionFacade getPartition(Object key) {
        return this._partitionManager.getPartition(key);
    }

    public Destination getLocalDestination() {
        return this._dispatcher.getLocalDestination();
    }

    public void init() throws Exception {
        this._partitionManager.init(this);
        this._stateManager.init(this);
    }

    public String getContextPath() {
        return "/";
    }
}

