/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.gridstate.impl;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import org.codehaus.wadi.gridstate.impl.SmartLockManager;
import org.codehaus.wadi.impl.Utils;

public class HybridLockManager
extends SmartLockManager {
    protected final Adaptor _adaptor;
    protected final boolean _always;

    public HybridLockManager(String name, Adaptor adaptor, boolean always) {
        super(name);
        this._adaptor = adaptor;
        this._always = always;
    }

    public Sync acquire(Object key) {
        return this.acquire(key, null);
    }

    public Sync acquire(Object key, Object value) {
        if (value == null) {
            if (this._always) {
                return super.acquire(key);
            }
            return null;
        }
        Sync sync = this._adaptor.adapt(value);
        if (sync == null) {
            return null;
        }
        Utils.safeAcquire(sync);
        if (this._adaptor.isValid(value)) {
            return sync;
        }
        sync.release();
        return null;
    }

    static interface Adaptor {
        public Sync adapt(Object var1);

        public boolean isValid(Object var1);
    }
}

