/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.gridstate.impl;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.dindex.newmessages.MoveIMToSM;
import org.codehaus.wadi.dindex.newmessages.MovePMToIM;
import org.codehaus.wadi.dindex.newmessages.MovePMToSM;
import org.codehaus.wadi.dindex.newmessages.MoveSMToIM;
import org.codehaus.wadi.dindex.newmessages.MoveSMToPM;
import org.codehaus.wadi.gridstate.Dispatcher;
import org.codehaus.wadi.gridstate.StateManager;
import org.codehaus.wadi.gridstate.StateManagerConfig;
import org.codehaus.wadi.gridstate.impl.Location;
import org.codehaus.wadi.gridstate.impl.PartitionFacade;
import org.codehaus.wadi.gridstate.messages.ReadIMToPM;
import org.codehaus.wadi.gridstate.messages.WriteIMToPM;
import org.codehaus.wadi.gridstate.messages.WritePMToIM;

public class IndirectStateManager
implements StateManager {
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected final String _clusterName = "ORG.CODEHAUS.WADI.TEST";
    protected final long _timeout;
    protected final Dispatcher _dispatcher;
    protected final String _nodeName;
    protected StateManagerConfig _config;

    public IndirectStateManager(Dispatcher dispatcher, long timeout) throws Exception {
        this._dispatcher = dispatcher;
        this._timeout = timeout;
        this._nodeName = this._dispatcher.getNodeName();
        this._dispatcher.register(this, "onMessage", ReadIMToPM.class);
        this._dispatcher.register(this, "onMessage", MovePMToSM.class);
        this._dispatcher.register(MoveSMToIM.class, this._timeout);
        this._dispatcher.register(MoveIMToSM.class, this._timeout);
        this._dispatcher.register(MoveSMToPM.class, this._timeout);
        this._dispatcher.register(MovePMToIM.class, this._timeout);
        this._dispatcher.register(this, "onMessage", WriteIMToPM.class);
        this._dispatcher.register(WritePMToIM.class, this._timeout);
    }

    public void init(StateManagerConfig config) {
        this._config = config;
    }

    public void start() throws Exception {
        HashMap<String, String> state = new HashMap<String, String>();
        state.put("nodeName", this._nodeName);
        this._dispatcher.setDistributedState(state);
        this._dispatcher.start();
    }

    public void stop() throws Exception {
        this._dispatcher.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Object object;
        Map map;
        Object value;
        String agent;
        Sync sync;
        block21: {
            Map map2;
            sync = null;
            agent = this._nodeName;
            try {
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - acquiring sync(" + sync + ")..." + " <" + Thread.currentThread().getName() + ">"));
                }
                sync = this._config.getSMSyncs().acquire(key);
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - ...sync(" + sync + ") acquired" + " <" + Thread.currentThread().getName() + ">"));
                }
                value = null;
                map2 = map = this._config.getMap();
                synchronized (map2) {
                    value = map.get(key);
                }
                if (value == null) break block21;
                map2 = value;
                Object var14_9 = null;
            }
            catch (Throwable throwable) {
                block22: {
                    Object var14_11 = null;
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - releasing sync(" + sync + ")..." + " <" + Thread.currentThread().getName() + ">"));
                    }
                    sync.release();
                    if (!this._log.isTraceEnabled()) break block22;
                    this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - ...sync(" + sync + ") released" + " <" + Thread.currentThread().getName() + ">"));
                }
                throw throwable;
            }
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - releasing sync(" + sync + ")..." + " <" + Thread.currentThread().getName() + ">"));
            }
            sync.release();
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - ...sync(" + sync + ") released" + " <" + Thread.currentThread().getName() + ">"));
            }
            return map2;
        }
        Destination im = this._dispatcher.getLocalDestination();
        Destination pm = this._config.getPartition(key).getDestination();
        ReadIMToPM request = new ReadIMToPM(key, im);
        ObjectMessage message = this._dispatcher.exchangeSendLoop(im, pm, request, this._timeout, 10);
        Serializable response = null;
        try {
            response = message.getObject();
        }
        catch (JMSException e) {
            this._log.error((Object)"unexpected problem", (Throwable)e);
        }
        if (response instanceof MovePMToIM) {
            value = null;
        } else if (response instanceof MoveSMToIM) {
            value = ((MoveSMToIM)response).getValue();
            object = this._config.getMap();
            synchronized (object) {
                map.put(key, value);
            }
            this._dispatcher.reply(message, new MoveIMToSM());
        }
        object = value;
        Object var14_10 = null;
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - releasing sync(" + sync + ")..." + " <" + Thread.currentThread().getName() + ">"));
        }
        sync.release();
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - ...sync(" + sync + ") released" + " <" + Thread.currentThread().getName() + ">"));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMessage(ObjectMessage message1, ReadIMToPM get) {
        String agent;
        Sync sync;
        Object key;
        block12: {
            block11: {
                key = get.getKey();
                sync = null;
                agent = this._dispatcher.getNodeName(get.getIM());
                try {
                    PartitionFacade partition;
                    Location location;
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(PM)] - " + key + " - acquiring sync(" + sync + ")..." + " <" + Thread.currentThread().getName() + ">"));
                    }
                    sync = this._config.getPMSyncs().acquire(key);
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(PM)] - " + key + " - ...sync(" + sync + ") acquired" + " <" + Thread.currentThread().getName() + ">"));
                    }
                    if ((location = (partition = this._config.getPartition(key)).getLocation(key)) == null) {
                        this._dispatcher.reply(message1, new MovePMToIM());
                        Object var15_8 = null;
                        break block11;
                    }
                    Destination im = get.getIM();
                    Destination pm = this._dispatcher.getLocalDestination();
                    Destination sm = (Destination)location.getValue();
                    String poCorrelationId = null;
                    try {
                        poCorrelationId = this._dispatcher.getOutgoingCorrelationId(message1);
                    }
                    catch (Exception e) {
                        this._log.error((Object)"unexpected problem", (Throwable)e);
                    }
                    MovePMToSM request = new MovePMToSM(key, im, pm, poCorrelationId);
                    ObjectMessage message2 = this._dispatcher.exchangeSendLoop(pm, sm, request, this._timeout, 10);
                    if (message2 == null) {
                        this._log.error((Object)"NO RESPONSE WITHIN TIMEFRAME - PANIC!");
                    }
                    location.setValue(get.getIM());
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var15_10 = null;
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(PM)] - " + key + " - releasing sync(" + sync + ")..." + " <" + Thread.currentThread().getName() + ">"));
                    }
                    sync.release();
                    if (!this._log.isTraceEnabled()) throw throwable;
                    this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(PM)] - " + key + " - ...sync(" + sync + ") released" + " <" + Thread.currentThread().getName() + ">"));
                    throw throwable;
                }
            }
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(PM)] - " + key + " - releasing sync(" + sync + ")..." + " <" + Thread.currentThread().getName() + ">"));
            }
            sync.release();
            if (!this._log.isTraceEnabled()) return;
            this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(PM)] - " + key + " - ...sync(" + sync + ") released" + " <" + Thread.currentThread().getName() + ">"));
            return;
        }
        Object var15_9 = null;
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(PM)] - " + key + " - releasing sync(" + sync + ")..." + " <" + Thread.currentThread().getName() + ">"));
        }
        sync.release();
        if (!this._log.isTraceEnabled()) return;
        this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(PM)] - " + key + " - ...sync(" + sync + ") released" + " <" + Thread.currentThread().getName() + ">"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ObjectMessage message1, MovePMToSM get) {
        Object key = get.getKey();
        String agent = this._dispatcher.getNodeName(get.getIM());
        Sync sync = null;
        try {
            Object value;
            Map map;
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(SM)] - " + key + " - acquiring sync(" + sync + ")..." + " <" + Thread.currentThread().getName() + ">"));
            }
            sync = this._config.getSMSyncs().acquire(key);
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(SM)] - " + key + " - ...sync(" + sync + ") acquired" + " <" + Thread.currentThread().getName() + ">"));
            }
            Destination sm = this._dispatcher.getLocalDestination();
            Destination im = get.getIM();
            Map map2 = map = this._config.getMap();
            synchronized (map2) {
                value = map.get(key);
            }
            MoveSMToIM request = new MoveSMToIM(key, value);
            ObjectMessage message2 = this._dispatcher.exchangeSend(sm, im, request, this._timeout, get.getIMCorrelationId());
            if (message2 == null) {
                this._log.error((Object)"NO REPLY RECEIVED FOR MESSAGE IN TIMEFRAME - PANIC!");
            }
            Map map3 = map;
            synchronized (map3) {
                map.remove(key);
            }
            this._dispatcher.reply(message1, new MoveSMToPM());
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(SM)] - " + key + " - releasing sync(" + sync + ")..." + " <" + Thread.currentThread().getName() + ">"));
            }
            sync.release();
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(SM)] - " + key + " - ...sync(" + sync + ") released" + " <" + Thread.currentThread().getName() + ">"));
            }
            throw throwable;
        }
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(SM)] - " + key + " - releasing sync(" + sync + ")..." + " <" + Thread.currentThread().getName() + ">"));
        }
        sync.release();
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(SM)] - " + key + " - ...sync(" + sync + ") released" + " <" + Thread.currentThread().getName() + ">"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Object put(Object key, Object value, boolean overwrite, boolean returnOldValue) {
        Object var14_30;
        boolean removal = value == null;
        Map map = this._config.getMap();
        Sync sync = null;
        String agent = this._nodeName;
        try {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - acquiring sync(" + sync + ")..." + " <" + Thread.currentThread().getName() + ">"));
            }
            sync = this._config.getSMSyncs().acquire(key);
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - ...sync(" + sync + ") acquired" + " <" + Thread.currentThread().getName() + ">"));
            }
            if (!removal) {
                Object object = map;
                // MONITORENTER : object
                boolean local = map.containsKey(key);
                // MONITOREXIT : object
                if (local) {
                    if (overwrite) {
                        object = map;
                        // MONITORENTER : object
                        Object oldValue = map.put(key, value);
                        Object object2 = returnOldValue ? oldValue : null;
                        // MONITOREXIT : object
                        Object var21_16 = null;
                        if (this._log.isTraceEnabled()) {
                            this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - releasing sync(" + sync + ")..." + " <" + Thread.currentThread().getName() + ">"));
                        }
                        sync.release();
                        if (!this._log.isTraceEnabled()) return object2;
                        this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - ...sync(" + sync + ") released" + " <" + Thread.currentThread().getName() + ">"));
                        return object2;
                    }
                    object = Boolean.FALSE;
                    Object var21_17 = null;
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - releasing sync(" + sync + ")..." + " <" + Thread.currentThread().getName() + ">"));
                    }
                    sync.release();
                    if (!this._log.isTraceEnabled()) return object;
                    this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - ...sync(" + sync + ") released" + " <" + Thread.currentThread().getName() + ">"));
                    return object;
                }
            }
            Destination im = this._dispatcher.getLocalDestination();
            Destination pm = this._config.getPartition(key).getDestination();
            WriteIMToPM request = new WriteIMToPM(key, value == null, overwrite, returnOldValue, im);
            ObjectMessage message = this._dispatcher.exchangeSendLoop(im, pm, request, this._timeout, 10);
            Serializable response = null;
            try {
                response = message.getObject();
            }
            catch (JMSException e) {
                this._log.error((Object)"unexpected problem", (Throwable)e);
            }
            if (response instanceof WritePMToIM) {
                if (overwrite) {
                    Map map2 = map;
                    // MONITORENTER : map2
                    Object oldValue = removal ? map.remove(key) : map.put(key, value);
                    Object object = returnOldValue ? oldValue : null;
                    // MONITOREXIT : map2
                    Object var21_18 = null;
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - releasing sync(" + sync + ")..." + " <" + Thread.currentThread().getName() + ">"));
                    }
                    sync.release();
                    if (!this._log.isTraceEnabled()) return object;
                    this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - ...sync(" + sync + ") released" + " <" + Thread.currentThread().getName() + ">"));
                    return object;
                }
                if (((WritePMToIM)response).getSuccess()) {
                    Object object = map;
                    // MONITORENTER : object
                    map.put(key, value);
                    // MONITOREXIT : object
                    object = Boolean.TRUE;
                    Object var21_19 = null;
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - releasing sync(" + sync + ")..." + " <" + Thread.currentThread().getName() + ">"));
                    }
                    sync.release();
                    if (!this._log.isTraceEnabled()) return object;
                    this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - ...sync(" + sync + ") released" + " <" + Thread.currentThread().getName() + ">"));
                    return object;
                }
                Boolean bl = Boolean.FALSE;
                Object var21_20 = null;
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - releasing sync(" + sync + ")..." + " <" + Thread.currentThread().getName() + ">"));
                }
                sync.release();
                if (!this._log.isTraceEnabled()) return bl;
                this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - ...sync(" + sync + ") released" + " <" + Thread.currentThread().getName() + ">"));
                return bl;
            }
            if (response instanceof MoveSMToIM) {
                this._dispatcher.reply(message, new MoveIMToSM());
                Object object = map;
                // MONITORENTER : object
                if (removal) {
                    map.remove(key);
                } else {
                    map.put(key, value);
                }
                // MONITOREXIT : object
                object = ((MoveSMToIM)response).getValue();
                Object var21_21 = null;
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - releasing sync(" + sync + ")..." + " <" + Thread.currentThread().getName() + ">"));
                }
                sync.release();
                if (!this._log.isTraceEnabled()) return object;
                this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - ...sync(" + sync + ") released" + " <" + Thread.currentThread().getName() + ">"));
                return object;
            }
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)("unexpected response: " + response.getClass().getName()));
            }
            var14_30 = null;
            Object var21_22 = null;
        }
        catch (Throwable throwable) {
            Object var21_23 = null;
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - releasing sync(" + sync + ")..." + " <" + Thread.currentThread().getName() + ">"));
            }
            sync.release();
            if (!this._log.isTraceEnabled()) throw throwable;
            this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - ...sync(" + sync + ") released" + " <" + Thread.currentThread().getName() + ">"));
            throw throwable;
        }
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - releasing sync(" + sync + ")..." + " <" + Thread.currentThread().getName() + ">"));
        }
        sync.release();
        if (!this._log.isTraceEnabled()) return var14_30;
        this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(IM)] - " + key + " - ...sync(" + sync + ") released" + " <" + Thread.currentThread().getName() + ">"));
        return var14_30;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ObjectMessage message1, WriteIMToPM write) {
        Object key = write.getKey();
        PartitionFacade partition = this._config.getPartition(key);
        Map partitionMap = partition.getMap();
        Sync sync = null;
        String agent = this._dispatcher.getNodeName(write.getIM());
        try {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(PM)] - " + key + " - acquiring sync(" + sync + ")..." + " <" + Thread.currentThread().getName() + ">"));
            }
            sync = this._config.getPMSyncs().acquire(key);
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(PM)] - " + key + " - ...sync(" + sync + ") acquired" + " <" + Thread.currentThread().getName() + ">"));
            }
            Location location = write.getValueIsNull() ? null : new Location(write.getIM());
            Location oldLocation = (Location)(location == null ? partitionMap.remove(key) : partitionMap.put(key, location));
            if (!write.getOverwrite() && oldLocation != null) {
                partitionMap.put(key, oldLocation);
                this._dispatcher.reply(message1, new WritePMToIM(false));
            } else if (oldLocation == null || write.getIM().equals(oldLocation.getValue())) {
                this._dispatcher.reply(message1, new WritePMToIM(true));
            } else {
                String poCorrelationId = null;
                try {
                    poCorrelationId = this._dispatcher.getOutgoingCorrelationId(message1);
                }
                catch (Exception e) {
                    this._log.error((Object)"unexpected problem", (Throwable)e);
                }
                Destination im = write.getIM();
                Destination pm = this._dispatcher.getLocalDestination();
                Destination sm = (Destination)oldLocation.getValue();
                MovePMToSM request = new MovePMToSM(key, im, pm, poCorrelationId);
                this._dispatcher.exchangeSendLoop(pm, sm, request, this._timeout, 10);
            }
            Object var16_16 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(PM)] - " + key + " - releasing sync(" + sync + ")..." + " <" + Thread.currentThread().getName() + ">"));
            }
            sync.release();
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(PM)] - " + key + " - ...sync(" + sync + ") released" + " <" + Thread.currentThread().getName() + ">"));
            }
            throw throwable;
        }
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(PM)] - " + key + " - releasing sync(" + sync + ")..." + " <" + Thread.currentThread().getName() + ">"));
        }
        sync.release();
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("[" + agent + "@" + this._nodeName + "(PM)] - " + key + " - ...sync(" + sync + ") released" + " <" + Thread.currentThread().getName() + ">"));
        }
    }

    public Object remove(Object key, boolean returnOldValue) {
        return this.put(key, null, true, returnOldValue);
    }

    public Object syncRpc(Destination destination, Object message) throws Exception {
        ObjectMessage tmp = this._dispatcher.exchangeSendLoop(this._dispatcher.getLocalDestination(), destination, (Serializable)message, this._timeout, 10);
        Serializable response = null;
        try {
            response = tmp.getObject();
        }
        catch (JMSException e) {
            this._log.error((Object)"unexpected problem", (Throwable)e);
        }
        return response;
    }
}

