/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.gridstate.impl;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.ReaderPreferenceReadWriteLock;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.gridstate.Partition;
import org.codehaus.wadi.gridstate.PartitionConfig;
import org.codehaus.wadi.gridstate.impl.Location;
import org.codehaus.wadi.impl.Utils;

public class LocalPartition
implements Partition {
    protected static final Log _log = LogFactory.getLog((Class)LocalPartition.class);
    protected final transient ReadWriteLock _lock;
    protected Map _map = new HashMap();
    protected PartitionConfig _config;

    public LocalPartition() {
        this._lock = new ReaderPreferenceReadWriteLock();
    }

    public void init(PartitionConfig config) {
        this._config = config;
    }

    public Destination getDestination() {
        return this._config.getLocalDestination();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getLocation(Object key) {
        try {
            Utils.safeAcquire(this._lock.readLock());
            Location location = (Location)this._map.get(key);
            return location;
        }
        finally {
            this._lock.readLock().release();
        }
    }

    public ReadWriteLock getLock() {
        return this._lock;
    }

    public Map getMap() {
        return this._map;
    }

    public boolean isLocal() {
        return true;
    }

    public int getKey() {
        throw new UnsupportedOperationException("NYI");
    }
}

