/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.gridstate.impl;

import EDU.oswego.cs.dl.util.concurrent.Mutex;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.wadi.gridstate.LockManager;
import org.codehaus.wadi.impl.Utils;

public class SmartLockManager
implements LockManager {
    protected final String _name;
    protected final Map _syncs;

    public SmartLockManager(String name) {
        this._name = name;
        this._syncs = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sync acquire(Object key) {
        Sync sync;
        Map map = this._syncs;
        synchronized (map) {
            sync = (Sync)this._syncs.get(key);
            if (sync == null) {
                sync = new ManagedSync(key);
                this._syncs.put(key, sync);
            }
            Utils.safeAcquire(sync);
        }
        return sync;
    }

    public Sync acquire(Object key, Object value) {
        return this.acquire(key);
    }

    class ManagedSync
    implements Sync {
        protected final Object _key;
        protected final Sync _sync;
        protected int _count;

        ManagedSync(Object key) {
            this._key = key;
            this._sync = new Mutex();
            this._count = 0;
        }

        public void acquire() throws InterruptedException {
            this.inc();
            this._sync.acquire();
        }

        public boolean attempt(long msecs) throws InterruptedException {
            this.inc();
            if (this._sync.attempt(msecs)) {
                return true;
            }
            this.dec();
            return false;
        }

        public void release() {
            this._sync.release();
            this.dec();
        }

        protected void inc() {
            ++this._count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dec() {
            Map map = SmartLockManager.this._syncs;
            synchronized (map) {
                if (--this._count == 0) {
                    SmartLockManager.this._syncs.remove(this._key);
                }
            }
        }
    }
}

