/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.gridstate.impl;

import javax.jms.Destination;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.gridstate.Dispatcher;
import org.codehaus.wadi.gridstate.PartitionManager;
import org.codehaus.wadi.gridstate.PartitionManagerConfig;
import org.codehaus.wadi.gridstate.PartitionMapper;
import org.codehaus.wadi.gridstate.impl.GCache;
import org.codehaus.wadi.gridstate.impl.LocalPartition;
import org.codehaus.wadi.gridstate.impl.PartitionFacade;
import org.codehaus.wadi.gridstate.impl.RemotePartition;

public class StaticPartitionManager
implements PartitionManager {
    protected final Dispatcher _dispatcher;
    protected final PartitionFacade[] _partitions;
    protected final PartitionMapper _mapper;
    protected static final Log _log = LogFactory.getLog((Class)StaticPartitionManager.class);

    public StaticPartitionManager(Dispatcher dispatcher, int numPartitions, PartitionMapper mapper) {
        this._dispatcher = dispatcher;
        this._partitions = new PartitionFacade[numPartitions];
        this._mapper = mapper;
    }

    public void init(PartitionManagerConfig config) {
        for (int i = 0; i < this._partitions.length; ++i) {
            this._partitions[i].init(this);
        }
    }

    public PartitionFacade[] getPartitions() {
        return this._partitions;
    }

    public int getNumPartitions() {
        return this._partitions.length;
    }

    public static void partition(GCache[] caches, PartitionManager[] managers, int numPartitions) {
        int numCaches = caches.length;
        int partitionsPerCache = numPartitions / numCaches;
        for (int i = 0; i < numPartitions; ++i) {
            int index = i / partitionsPerCache;
            GCache master = caches[index];
            if (_log.isInfoEnabled()) {
                _log.info((Object)("partition-" + i + " -> node-" + index));
            }
            for (int j = 0; j < numCaches; ++j) {
                PartitionFacade partition;
                GCache cache = caches[j];
                if (cache != master) {
                    partition = new PartitionFacade(new RemotePartition(master.getLocalDestination()));
                    partition.init(cache.getPartitionConfig());
                    cache.getPartitions()[i] = partition;
                    continue;
                }
                cache.getPartitions()[i] = partition = new PartitionFacade(new LocalPartition());
            }
        }
    }

    public PartitionFacade getPartition(Object key) {
        return this._partitions[this._mapper.map(key)];
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public Dispatcher getDispatcher() {
        return this._dispatcher;
    }

    public Destination getLocalDestination() {
        return this._dispatcher.getLocalDestination();
    }

    public void evacuate() {
        throw new UnsupportedOperationException("NYI");
    }
}

