/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.Evictable;
import org.codehaus.wadi.EvicterConfig;
import org.codehaus.wadi.Motable;
import org.codehaus.wadi.impl.AbstractEvicter;
import org.codehaus.wadi.impl.RankedRWLock;
import org.codehaus.wadi.impl.Utils;

public abstract class AbstractBestEffortEvicter
extends AbstractEvicter {
    protected final Log _lockLog = LogFactory.getLog((String)"org.codehaus.wadi.LOCKS");
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected final int _sweepInterval;
    protected final boolean _strictOrdering;
    protected TimerTask _task;
    protected EvicterConfig _config;

    public Comparator getComparator(long time) {
        return new TimeToLiveComparator(time);
    }

    public AbstractBestEffortEvicter(int sweepInterval, boolean strictOrdering) {
        this._sweepInterval = sweepInterval;
        this._strictOrdering = strictOrdering;
    }

    public void init(EvicterConfig config) {
        super.init(config);
        this._config = config;
    }

    public void start() throws Exception {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("starting (sweep interval: " + this._sweepInterval + " sec[s])"));
        }
        long interval = this._sweepInterval * 1000;
        this._task = new BestEffortTask();
        this._config.getTimer().schedule(this._task, interval, interval);
    }

    public void stop() throws Exception {
        this._task.cancel();
        this._log.trace((Object)"stopped");
    }

    public void destroy() {
        this._config = null;
    }

    public void evict() {
        this._log.trace((Object)"sweep started");
        RankedRWLock.setPriority(3);
        long time = System.currentTimeMillis();
        Map candidates = this._config.getMap();
        ArrayList<Evictable> toExpireList = new ArrayList<Evictable>();
        ArrayList<Evictable> toDemoteList = new ArrayList<Evictable>();
        Iterator i = candidates.values().iterator();
        while (i.hasNext()) {
            Evictable e = (Evictable)i.next();
            long ttl = e.getTimeToLive(time);
            if (ttl < 0L) {
                toExpireList.add(e);
                continue;
            }
            if (!this.test(e, time, ttl)) continue;
            toDemoteList.add(e);
        }
        Object[] toExpire = toExpireList.toArray();
        toExpireList = null;
        Object[] toDemote = toDemoteList.toArray();
        toDemoteList = null;
        if (this._strictOrdering) {
            Comparator comparator = this.getComparator(time);
            Arrays.sort(toDemote, comparator);
            Arrays.sort(toDemote, comparator);
            comparator = null;
        }
        int expirations = 0;
        int l = toExpire.length;
        boolean traceEnabled = this._lockLog.isTraceEnabled();
        for (int i2 = 0; i2 < l; ++i2) {
            Motable motable = (Motable)toExpire[i2];
            String id = motable.getName();
            if (id == null) continue;
            Sync sync = this._config.getEvictionLock(id, motable);
            if (traceEnabled) {
                this._lockLog.trace((Object)("Eviction - acquiring: " + id + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
            }
            if (Utils.attemptUninterrupted(sync)) {
                if (traceEnabled) {
                    this._lockLog.trace((Object)("Eviction - acquired: " + id + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
                }
                if (motable.getTimedOut(time)) {
                    this._config.expire(motable);
                    ++expirations;
                }
                if (traceEnabled) {
                    this._lockLog.trace((Object)("Eviction - releasing: " + id + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
                }
                sync.release();
                if (!traceEnabled) continue;
                this._lockLog.trace((Object)("Eviction - released: " + id + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
                continue;
            }
            if (!traceEnabled) continue;
            this._lockLog.trace((Object)("Eviction - not acquired: " + id + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
        }
        toExpire = null;
        int demotions = 0;
        traceEnabled = this._lockLog.isTraceEnabled();
        int l2 = toDemote.length;
        for (int i3 = 0; i3 < l2; ++i3) {
            Motable motable = (Motable)toDemote[i3];
            String id = motable.getName();
            Sync sync = this._config.getEvictionLock(id, motable);
            if (traceEnabled) {
                this._lockLog.trace((Object)("Eviction - acquiring: " + id + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
            }
            if (Utils.attemptUninterrupted(sync)) {
                if (traceEnabled) {
                    this._lockLog.trace((Object)("Eviction - acquired: " + id + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
                }
                if (this.test(motable, time, motable.getTimeToLive(time))) {
                    this._config.demote(motable);
                    ++demotions;
                }
                if (traceEnabled) {
                    this._lockLog.trace((Object)("Eviction - releasing: " + id + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
                }
                sync.release();
                if (!traceEnabled) continue;
                this._lockLog.trace((Object)("Eviction - released: " + id + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
                continue;
            }
            if (!traceEnabled) continue;
            this._lockLog.trace((Object)("Eviction - not acquired: " + id + " [" + Thread.currentThread().getName() + "]" + " : " + sync));
        }
        toDemote = null;
        RankedRWLock.setPriority(0);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("sweep completed (" + (System.currentTimeMillis() - time) + " millis) - expirations:" + expirations + ", demotions:" + demotions));
        }
    }

    public void insert(Evictable evictable) {
    }

    public void remove(Evictable evictable) {
    }

    public void setLastAccessedTime(Evictable evictable, long oldTime, long newTime) {
    }

    public void setMaxInactiveInterval(Evictable evictable, int oldInterval, int newInterval) {
    }

    class BestEffortTask
    extends TimerTask {
        BestEffortTask() {
        }

        public void run() {
            AbstractBestEffortEvicter.this.evict();
        }
    }

    static class TimeToLiveComparator
    implements Comparator {
        protected final long _time;

        public TimeToLiveComparator(long time) {
            this._time = time;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof TimeToLiveComparator && this._time == ((TimeToLiveComparator)obj)._time;
        }

        public int compare(Object o1, Object o2) {
            return (int)(((Evictable)o1).getTimeToLive(this._time) - ((Evictable)o2).getTimeToLive(this._time));
        }
    }
}

