/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import org.codehaus.wadi.Contextualiser;
import org.codehaus.wadi.ContextualiserConfig;
import org.codehaus.wadi.Emoter;
import org.codehaus.wadi.Evicter;
import org.codehaus.wadi.EvicterConfig;
import org.codehaus.wadi.Immoter;
import org.codehaus.wadi.InvocationContext;
import org.codehaus.wadi.InvocationException;
import org.codehaus.wadi.Locker;
import org.codehaus.wadi.Motable;
import org.codehaus.wadi.impl.AbstractMotingContextualiser;
import org.codehaus.wadi.impl.RankedRWLock;
import org.codehaus.wadi.impl.Utils;

public abstract class AbstractExclusiveContextualiser
extends AbstractMotingContextualiser
implements EvicterConfig {
    protected final Map _map;
    protected final Evicter _evicter;
    protected String _stringPrefix = "<" + this.getClass().getName() + ":";
    protected String _stringSuffix = ">";
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractExclusiveContextualiser(Contextualiser next, Locker locker, boolean clean, Evicter evicter, Map map) {
        super(next, locker, clean);
        this._map = map;
        this._evicter = evicter;
    }

    public String toString() {
        return this._stringPrefix + this._map.size() + this._stringSuffix;
    }

    public Motable get(String id) {
        return (Motable)this._map.get(id);
    }

    public boolean handle(InvocationContext invocationContext, String id, Immoter immoter, Sync motionLock) throws InvocationException {
        Motable emotable = this.get(id);
        if (emotable == null) {
            return false;
        }
        if (immoter != null) {
            return this.promote(invocationContext, id, immoter, motionLock, emotable);
        }
        return false;
    }

    public Emoter getEvictionEmoter() {
        return this.getEmoter();
    }

    protected void unload() {
        Emoter emoter = this.getEmoter();
        RankedRWLock.setPriority(3);
        int i = 0;
        while (this._map.size() > 0) {
            try {
                String name;
                Motable emotable = (Motable)this._map.values().iterator().next();
                if (emotable == null || (name = emotable.getName()) == null) continue;
                Immoter immoter = this._next.getSharedDemoter();
                Utils.mote(emoter, immoter, emotable, name);
                ++i;
            }
            catch (Exception e) {
                this._log.warn((Object)"unexpected problem", (Throwable)e);
            }
        }
        RankedRWLock.setPriority(0);
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("unloaded sessions: " + i));
        }
        if (!$assertionsDisabled && this._map.size() != 0) {
            throw new AssertionError();
        }
    }

    public void init(ContextualiserConfig config) {
        super.init(config);
        this._evicter.init(this);
    }

    public void start() throws Exception {
        super.start();
        this._evicter.start();
    }

    public void stop() throws Exception {
        this.unload();
        this._evicter.stop();
        super.stop();
    }

    public void destroy() {
        this._evicter.destroy();
        super.destroy();
    }

    public void load(Emoter emoter, Immoter immoter) {
    }

    public Evicter getEvicter() {
        return this._evicter;
    }

    public Immoter getDemoter(String name, Motable motable) {
        long time = System.currentTimeMillis();
        if (this.getEvicter().test(motable, time, motable.getTimeToLive(time))) {
            return this._next.getDemoter(name, motable);
        }
        return this.getImmoter();
    }

    public int getLocalSessionCount() {
        return this.getSize() + this._next.getLocalSessionCount();
    }

    public int getSize() {
        return this._map.size();
    }

    public Map getMap() {
        return this._map;
    }

    public Timer getTimer() {
        return this._config.getTimer();
    }

    public Sync getEvictionLock(String id, Motable motable) {
        return this._locker.getLock(id, motable);
    }

    public void demote(Motable emotable) {
        String id = emotable.getName();
        if (id == null) {
            return;
        }
        Immoter immoter = this._next.getDemoter(id, emotable);
        Emoter emoter = this.getEvictionEmoter();
        Utils.mote(emoter, immoter, emotable, id);
    }

    public int getMaxInactiveInterval() {
        return this._config.getMaxInactiveInterval();
    }

    public void findRelevantSessionNames(int numPartitions, Collection[] resultSet) {
        super.findRelevantSessionNames(numPartitions, resultSet);
        int matches = 0;
        Iterator i = this._map.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            int key = Math.abs(name.hashCode() % numPartitions);
            Collection c = resultSet[key];
            if (c == null) continue;
            c.add(name);
            ++matches;
        }
        if (matches > 0 && this._log.isDebugEnabled()) {
            this._log.debug((Object)("matches found: " + matches));
        }
    }

    static {
        $assertionsDisabled = !AbstractExclusiveContextualiser.class.desiredAssertionStatus();
    }
}

