/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.wadi.InvocationContext;
import org.codehaus.wadi.InvocationProxy;
import org.codehaus.wadi.ProxiedLocation;
import org.codehaus.wadi.ProxyingException;
import org.codehaus.wadi.http.HTTPProxiedLocation;
import org.codehaus.wadi.impl.WebInvocationContext;

public abstract class AbstractHttpProxy
implements InvocationProxy {
    public static final String _WADI_IsSecure = "WADI-IsSecure";
    protected static final HashSet _DontProxyHeaders = new HashSet();
    protected final String _sessionPathParamKey;

    public AbstractHttpProxy(String sessionPathParamKey) {
        this._sessionPathParamKey = sessionPathParamKey;
    }

    public int copy(InputStream is, OutputStream os, int length) throws IOException {
        int total = 0;
        byte[] buffer = new byte[length];
        int n = 0;
        while ((n = is.read(buffer, 0, length)) >= 0) {
            os.write(buffer, 0, n);
            total += n;
        }
        return total;
    }

    public String getRequestURI(HttpServletRequest hreq) {
        String uri = hreq.getRequestURI();
        if (hreq.isRequestedSessionIdFromURL() && uri.lastIndexOf(59) < 0) {
            uri = uri + ";" + this._sessionPathParamKey + "=" + hreq.getRequestedSessionId();
        }
        return uri;
    }

    public final void proxy(ProxiedLocation location, InvocationContext invocationContext) throws ProxyingException {
        if (!(location instanceof HTTPProxiedLocation)) {
            throw new IllegalArgumentException(HTTPProxiedLocation.class + " is expected.");
        }
        if (!(invocationContext instanceof WebInvocationContext)) {
            throw new IllegalArgumentException(WebInvocationContext.class + " is expected.");
        }
        HTTPProxiedLocation proxiedLocation = (HTTPProxiedLocation)location;
        InetSocketAddress address = proxiedLocation.getInetSocketAddress();
        WebInvocationContext context = (WebInvocationContext)invocationContext;
        this.doProxy(address, context);
    }

    protected abstract void doProxy(InetSocketAddress var1, WebInvocationContext var2) throws ProxyingException;

    static {
        _DontProxyHeaders.add("proxy-connection");
        _DontProxyHeaders.add("connection");
        _DontProxyHeaders.add("keep-alive");
        _DontProxyHeaders.add("transfer-encoding");
        _DontProxyHeaders.add("te");
        _DontProxyHeaders.add("trailer");
        _DontProxyHeaders.add("proxy-authorization");
        _DontProxyHeaders.add("proxy-authenticate");
        _DontProxyHeaders.add("upgrade");
    }
}

