/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.Motable;
import org.codehaus.wadi.impl.SimpleEvictable;

public abstract class AbstractMotable
extends SimpleEvictable
implements Motable,
Serializable {
    protected static Log _log = LogFactory.getLog((Class)AbstractMotable.class);
    protected String _name;

    public void init(long creationTime, long lastAccessedTime, int maxInactiveInterval, String name) {
        this.init(creationTime, lastAccessedTime, maxInactiveInterval);
        this._name = name;
    }

    public void destroy() throws Exception {
        this._name = null;
        super.destroy();
    }

    public void copy(Motable motable) throws Exception {
        super.copy(motable);
        this._name = motable.getName();
        this.setBodyAsByteArray(motable.getBodyAsByteArray());
    }

    public void mote(Motable recipient) throws Exception {
        recipient.copy(this);
        this.destroy();
    }

    public String getName() {
        return this._name;
    }

    public void readContent(ObjectInput oi) throws IOException, ClassNotFoundException {
        super.readContent(oi);
        this._name = (String)oi.readObject();
    }

    public void writeContent(ObjectOutput oo) throws IOException {
        super.writeContent(oo);
        oo.writeObject(this._name);
    }
}

