/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import org.codehaus.wadi.Motable;
import org.codehaus.wadi.RWLockListener;
import org.codehaus.wadi.ReplicableSessionConfig;
import org.codehaus.wadi.Replicater;
import org.codehaus.wadi.impl.DistributableSession;

public abstract class AbstractReplicableSession
extends DistributableSession
implements RWLockListener {
    public AbstractReplicableSession(ReplicableSessionConfig config) {
        super(config);
        this._lock.setListener(this);
    }

    public abstract void readEnded();

    public void init(long creationTime, long lastAccessedTime, int maxInactiveInterval, String name) {
        super.init(creationTime, lastAccessedTime, maxInactiveInterval, name);
        Replicater replicater = ((ReplicableSessionConfig)this._config).getReplicater();
        replicater.create(this);
    }

    public void init2(long creationTime, long lastAccessedTime, int maxInactiveInterval, String name) {
        super.init(creationTime, lastAccessedTime, maxInactiveInterval, name);
        Replicater replicater = ((ReplicableSessionConfig)this._config).getReplicater();
        if (!replicater.getReusingStore()) {
            replicater.create(this);
        }
    }

    public void copy(Motable motable) throws Exception {
        Replicater replicater = ((ReplicableSessionConfig)this._config).getReplicater();
        if (!replicater.getReusingStore()) {
            replicater.create(this);
        }
        super.copy(motable);
    }

    public void mote(Motable recipient) throws Exception {
        Replicater replicater = ((ReplicableSessionConfig)this._config).getReplicater();
        if (replicater.getReusingStore()) {
            recipient.init(this._creationTime, this._lastAccessedTime, this._maxInactiveInterval, this._name);
        } else {
            recipient.copy(this);
        }
        this.destroy(recipient);
    }

    public void destroy() throws Exception {
        ((ReplicableSessionConfig)this._config).getReplicater().destroy(this);
        super.destroy();
    }

    public void destroy(Motable recipient) throws Exception {
        Replicater replicater = ((ReplicableSessionConfig)this._config).getReplicater();
        super.destroy();
        if (!replicater.getReusingStore()) {
            replicater.destroy(this);
        }
    }
}

