/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import java.util.Iterator;
import java.util.Map;
import javax.jms.ObjectMessage;
import org.activecluster.Cluster;
import org.activecluster.ClusterEvent;
import org.activecluster.ClusterListener;
import org.activecluster.LocalNode;
import org.activecluster.Node;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.ClusteredContextualiserConfig;
import org.codehaus.wadi.Collapser;
import org.codehaus.wadi.Contextualiser;
import org.codehaus.wadi.ContextualiserConfig;
import org.codehaus.wadi.Emoter;
import org.codehaus.wadi.Evictable;
import org.codehaus.wadi.Immoter;
import org.codehaus.wadi.InvocationContext;
import org.codehaus.wadi.InvocationException;
import org.codehaus.wadi.InvocationProxy;
import org.codehaus.wadi.Location;
import org.codehaus.wadi.Motable;
import org.codehaus.wadi.ProxiedLocation;
import org.codehaus.wadi.Relocater;
import org.codehaus.wadi.RelocaterConfig;
import org.codehaus.wadi.dindex.StateManager;
import org.codehaus.wadi.dindex.impl.DIndex;
import org.codehaus.wadi.gridstate.Dispatcher;
import org.codehaus.wadi.gridstate.activecluster.ActiveClusterDispatcher;
import org.codehaus.wadi.impl.AbstractChainedEmoter;
import org.codehaus.wadi.impl.AbstractSharedContextualiser;
import org.codehaus.wadi.impl.CollapsingLocker;
import org.codehaus.wadi.impl.HttpProxyLocation;
import org.codehaus.wadi.impl.SimpleMotable;
import org.codehaus.wadi.impl.Utils;

public class ClusterContextualiser
extends AbstractSharedContextualiser
implements RelocaterConfig,
ClusterListener,
StateManager.ImmigrationListener {
    protected static final String _nodeNameKey = "name";
    protected static final String _shuttingDownKey = "shuttingDown";
    protected static final String _evacuatingKey = "evacuating";
    protected final SynchronizedInt _evacuationPartnerCount = new SynchronizedInt(0);
    protected final Collapser _collapser;
    protected final Relocater _relocater;
    protected final Immoter _immoter;
    protected final Emoter _emoter;
    protected final int _resTimeout = 500;
    protected final Log _lockLog = LogFactory.getLog((String)"org.codehaus.wadi.LOCKS");
    protected SynchronizedBoolean _shuttingDown;
    protected String _nodeName;
    protected boolean _evacuating;
    protected ActiveClusterDispatcher _dispatcher;
    protected Cluster _cluster;
    protected HttpProxyLocation _location;
    protected ProxiedLocation _proxiedLocation;
    protected DIndex _dindex;
    protected Contextualiser _top;
    protected int _locationMaxInactiveInterval = 30;

    public ClusterContextualiser(Contextualiser next, Collapser collapser, Relocater relocater) {
        super(next, new CollapsingLocker(collapser), false);
        this._collapser = collapser;
        this._relocater = relocater;
        this._immoter = new EmigrationImmoter();
        this._emoter = null;
    }

    public void init(ContextualiserConfig config) {
        super.init(config);
        ClusteredContextualiserConfig ccc = (ClusteredContextualiserConfig)config;
        this._shuttingDown = ccc.getShuttingDown();
        this._nodeName = ccc.getNodeName();
        this._dispatcher = (ActiveClusterDispatcher)ccc.getDispatcher();
        this._cluster = this._dispatcher.getCluster();
        this._proxiedLocation = ccc.getProxiedLocation();
        this._location = new HttpProxyLocation(this._dispatcher.getLocalDestination(), this._proxiedLocation, ccc.getInvocationProxy());
        this._dindex = ccc.getDIndex();
        this._cluster.addClusterListener((ClusterListener)this);
        this._dindex.getStateManager().setImmigrationListener(this);
        this._top = ccc.getContextualiser();
        this._relocater.init(this);
    }

    public String getStartInfo() {
        return "[" + this._nodeName + "]";
    }

    public void destroy() {
        this._relocater.destroy();
        super.destroy();
    }

    public Immoter getImmoter() {
        return this._immoter;
    }

    public Emoter getEmoter() {
        return this._emoter;
    }

    protected int getEvacuationPartnersCount() {
        return this._evacuationPartnerCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshEvacuationPartnersCount() {
        LocalNode localNode = this._cluster.getLocalNode();
        Map nodes = this._cluster.getNodes();
        int count = 0;
        Map map = nodes;
        synchronized (map) {
            Iterator i = nodes.values().iterator();
            while (i.hasNext()) {
                Node node = (Node)i.next();
                if (node == localNode || node.getState().containsKey(_shuttingDownKey)) continue;
                ++count;
            }
        }
        this._evacuationPartnerCount.set(count);
    }

    public Immoter getDemoter(String name, Motable motable) {
        if (this.getEvacuationPartnersCount() > 0) {
            this.ensureEvacuationQueue();
            return this.getImmoter();
        }
        return this._next.getDemoter(name, motable);
    }

    public Immoter getSharedDemoter() {
        if (this.getEvacuationPartnersCount() > 0) {
            this.ensureEvacuationQueue();
            return this.getImmoter();
        }
        return this._next.getSharedDemoter();
    }

    public boolean handle(InvocationContext invocationContext, String id, Immoter immoter, Sync motionLock) throws InvocationException {
        return this._relocater.relocate(invocationContext, id, immoter, motionLock);
    }

    protected void createEvacuationQueue() throws Exception {
        this._log.trace((Object)"creating evacuation queue");
        ClusteredContextualiserConfig ccc = (ClusteredContextualiserConfig)this._config;
        ccc.putDistributedState(_shuttingDownKey, Boolean.TRUE);
        this._evacuating = true;
        ccc.putDistributedState(_evacuatingKey, Boolean.TRUE);
        ccc.distributeState();
        this._log.info((Object)"ignoring further evacuation appeals");
        Utils.safeSleep(2000L);
    }

    protected void destroyEvacuationQueue() throws Exception {
        ClusteredContextualiserConfig ccc = (ClusteredContextualiserConfig)this._config;
        this._evacuating = false;
        ccc.removeDistributedState(_evacuatingKey);
        ccc.distributeState();
        this._log.trace((Object)"emigration queue destroyed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void ensureEvacuationQueue() {
        SynchronizedBoolean synchronizedBoolean = this._shuttingDown;
        synchronized (synchronizedBoolean) {
            try {
                if (!this._evacuating) {
                    this.createEvacuationQueue();
                }
            }
            catch (Exception e) {
                this._log.error((Object)"emmigration queue initialisation failed", (Throwable)e);
                this._evacuating = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        SynchronizedBoolean synchronizedBoolean = this._shuttingDown;
        synchronized (synchronizedBoolean) {
            if (this._evacuating) {
                this.destroyEvacuationQueue();
            }
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onImmigration(ObjectMessage message, Motable emotable) {
        String name = emotable.getName();
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("EmigrationRequest received: " + name));
        }
        Sync invocationLock = this._locker.getLock(name, emotable);
        boolean invocationLockAcquired = false;
        try {
            try {
                if (this._lockLog.isTraceEnabled()) {
                    this._lockLog.trace((Object)("Invocation - acquiring: " + name + " [" + Thread.currentThread().getName() + "]" + " : " + invocationLock));
                }
                Utils.acquireUninterrupted(invocationLock);
                if (this._lockLog.isTraceEnabled()) {
                    this._lockLog.trace((Object)("Invocation - acquired: " + name + " [" + Thread.currentThread().getName() + "]" + " : " + invocationLock));
                }
                invocationLockAcquired = true;
                ImmigrationEmoter emoter = new ImmigrationEmoter(message);
                if (!emotable.checkTimeframe(System.currentTimeMillis()) && this._log.isWarnEnabled()) {
                    this._log.warn((Object)("immigrating session has come from the future!: " + emotable.getName()));
                }
                Immoter immoter = this._top.getDemoter(name, emotable);
                Utils.mote(emoter, immoter, emotable, name);
                this.notifySessionRelocation(name);
            }
            catch (TimeoutException e) {
                if (this._log.isWarnEnabled()) {
                    this._log.warn((Object)("could not acquire promotion lock for incoming session: " + name));
                }
                Object var9_10 = null;
                if (!invocationLockAcquired) return;
                if (this._lockLog.isTraceEnabled()) {
                    this._lockLog.trace((Object)("Invocation - releasing: " + name + " [" + Thread.currentThread().getName() + "]" + " : " + invocationLock));
                }
                invocationLock.release();
                if (!this._lockLog.isTraceEnabled()) return;
                this._lockLog.trace((Object)("Invocation - released: " + name + " [" + Thread.currentThread().getName() + "]" + " : " + invocationLock));
                return;
            }
            Object var9_9 = null;
            if (!invocationLockAcquired) return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (!invocationLockAcquired) throw throwable;
            if (this._lockLog.isTraceEnabled()) {
                this._lockLog.trace((Object)("Invocation - releasing: " + name + " [" + Thread.currentThread().getName() + "]" + " : " + invocationLock));
            }
            invocationLock.release();
            if (!this._lockLog.isTraceEnabled()) throw throwable;
            this._lockLog.trace((Object)("Invocation - released: " + name + " [" + Thread.currentThread().getName() + "]" + " : " + invocationLock));
            throw throwable;
        }
        if (this._lockLog.isTraceEnabled()) {
            this._lockLog.trace((Object)("Invocation - releasing: " + name + " [" + Thread.currentThread().getName() + "]" + " : " + invocationLock));
        }
        invocationLock.release();
        if (!this._lockLog.isTraceEnabled()) return;
        this._lockLog.trace((Object)("Invocation - released: " + name + " [" + Thread.currentThread().getName() + "]" + " : " + invocationLock));
    }

    public void load(Emoter emoter, Immoter immoter) {
    }

    public void onNodeAdd(ClusterEvent event) {
        this.refreshEvacuationPartnersCount();
        this.onNodeStateChange(event);
    }

    public void onNodeUpdate(ClusterEvent event) {
        this.refreshEvacuationPartnersCount();
        this.onNodeStateChange(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNodeStateChange(ClusterEvent event) {
        boolean evacuating;
        Map state = event.getNode().getState();
        String nodeName = (String)state.get(_nodeNameKey);
        if (nodeName.equals(this._nodeName)) {
            return;
        }
        Boolean tmp = (Boolean)state.get(_evacuatingKey);
        boolean bl = evacuating = tmp == null ? false : tmp;
        if (!evacuating) {
            this.ensureEvacuationLeft(nodeName);
        } else {
            SynchronizedBoolean synchronizedBoolean = this._shuttingDown;
            synchronized (synchronizedBoolean) {
                if (!this._shuttingDown.get()) {
                    this.ensureEvacuationJoined(nodeName);
                }
            }
        }
    }

    protected void ensureEvacuationJoined(String nodeName) {
    }

    protected void ensureEvacuationLeft(String nodeName) {
    }

    public void onNodeRemoved(ClusterEvent event) {
        Map state = event.getNode().getState();
        String nodeName = (String)state.get(_nodeNameKey);
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("node left: " + nodeName));
        }
        this.refreshEvacuationPartnersCount();
        this.ensureEvacuationLeft(nodeName);
    }

    public void onNodeFailed(ClusterEvent event) {
        Map state = event.getNode().getState();
        String nodeName = (String)state.get(_nodeNameKey);
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("node failed: " + nodeName));
        }
        this.refreshEvacuationPartnersCount();
        this.ensureEvacuationLeft(nodeName);
    }

    public void onCoordinatorChanged(ClusterEvent event) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("coordinator changed: " + event.getNode().getState().get(_nodeNameKey)));
        }
    }

    public Collapser getCollapser() {
        return this._collapser;
    }

    public Dispatcher getDispatcher() {
        return this._dispatcher;
    }

    public Location getLocation() {
        return this._location;
    }

    public ProxiedLocation getProxiedLocation() {
        return this._proxiedLocation;
    }

    public Contextualiser getContextualiser() {
        return this._top;
    }

    public String getNodeName() {
        return this._nodeName;
    }

    public SynchronizedBoolean getShuttingDown() {
        return this._shuttingDown;
    }

    public InvocationProxy getInvocationProxy() {
        return ((ClusteredContextualiserConfig)this._config).getInvocationProxy();
    }

    public DIndex getDIndex() {
        return this._dindex;
    }

    public void notifySessionRelocation(String name) {
        this._config.notifySessionRelocation(name);
    }

    public Motable get(String name) {
        throw new UnsupportedOperationException();
    }

    class MyLocation
    implements Evictable {
        protected long _lastAccessedTime;
        protected String _nodeName;

        public MyLocation(long timestamp, String nodeName) {
            this._lastAccessedTime = timestamp;
            this._nodeName = nodeName;
        }

        public void init(long creationTime, long lastAccessedTime, int maxInactiveInterval) {
            this._lastAccessedTime = lastAccessedTime;
        }

        public void destroy() throws Exception {
            throw new UnsupportedOperationException();
        }

        public void copy(Evictable evictable) {
            throw new UnsupportedOperationException();
        }

        public void mote(Evictable recipient) {
            throw new UnsupportedOperationException();
        }

        public long getCreationTime() {
            return this._lastAccessedTime;
        }

        public long getLastAccessedTime() {
            return this._lastAccessedTime;
        }

        public void setLastAccessedTime(long lastAccessedTime) {
            throw new UnsupportedOperationException();
        }

        public int getMaxInactiveInterval() {
            return ClusterContextualiser.this._locationMaxInactiveInterval;
        }

        public void setMaxInactiveInterval(int maxInactiveInterval) {
            throw new UnsupportedOperationException();
        }

        public boolean isNew() {
            throw new UnsupportedOperationException();
        }

        public long getTimeToLive(long time) {
            return this._lastAccessedTime + (long)(ClusterContextualiser.this._locationMaxInactiveInterval * 1000) - time;
        }

        public boolean getTimedOut(long time) {
            return this.getTimeToLive(time) <= 0L;
        }

        public boolean checkTimeframe(long time) {
            throw new UnsupportedOperationException();
        }
    }

    class ImmigrationEmoter
    extends AbstractChainedEmoter {
        protected final ObjectMessage _message;

        public ImmigrationEmoter(ObjectMessage message) {
            this._message = message;
        }

        public boolean prepare(String name, Motable emotable, Motable immotable) {
            if (super.prepare(name, emotable, immotable)) {
                ClusterContextualiser.this._dindex.getStateManager().acceptImmigrant(this._message, ClusterContextualiser.this._location, name, emotable);
                return true;
            }
            return false;
        }

        public void commit(String name, Motable emotable) {
        }

        public void rollback(String name, Motable emotable) {
            throw new RuntimeException("NYI");
        }

        public String getInfo() {
            return "cluster";
        }
    }

    class EmigrationImmoter
    implements Immoter {
        EmigrationImmoter() {
        }

        public Motable nextMotable(String id, Motable emotable) {
            return new SimpleMotable();
        }

        public boolean prepare(String name, Motable emotable, Motable immotable) {
            try {
                immotable.copy(emotable);
            }
            catch (Exception e) {
                if (ClusterContextualiser.this._log.isWarnEnabled()) {
                    ClusterContextualiser.this._log.warn((Object)("problem sending emigration request: " + name), (Throwable)e);
                }
                return false;
            }
            return ClusterContextualiser.this._dindex.getStateManager().offerEmigrant(name, immotable, 500L);
        }

        public void commit(String name, Motable immotable) {
        }

        public void rollback(String name, Motable immotable) {
        }

        public boolean contextualise(InvocationContext invocationContext, String id, Motable immotable, Sync motionLock) throws InvocationException {
            return false;
        }

        public String getInfo() {
            return "cluster";
        }
    }
}

