/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Destination;
import org.activecluster.Node;
import org.codehaus.wadi.AttributesFactory;
import org.codehaus.wadi.ClusteredContextualiserConfig;
import org.codehaus.wadi.Collapser;
import org.codehaus.wadi.Contextualiser;
import org.codehaus.wadi.Immoter;
import org.codehaus.wadi.InvocationContext;
import org.codehaus.wadi.InvocationException;
import org.codehaus.wadi.InvocationProxy;
import org.codehaus.wadi.ManagerConfig;
import org.codehaus.wadi.Motable;
import org.codehaus.wadi.ProxiedLocation;
import org.codehaus.wadi.ReplicaterFactory;
import org.codehaus.wadi.Router;
import org.codehaus.wadi.Session;
import org.codehaus.wadi.SessionIdFactory;
import org.codehaus.wadi.SessionPool;
import org.codehaus.wadi.SessionWrapperFactory;
import org.codehaus.wadi.Streamer;
import org.codehaus.wadi.ValueHelper;
import org.codehaus.wadi.ValuePool;
import org.codehaus.wadi.dindex.PartitionManagerConfig;
import org.codehaus.wadi.dindex.impl.DIndex;
import org.codehaus.wadi.gridstate.Dispatcher;
import org.codehaus.wadi.gridstate.DispatcherConfig;
import org.codehaus.wadi.gridstate.PartitionManager;
import org.codehaus.wadi.impl.DistributableManager;
import org.codehaus.wadi.impl.DistributableSession;
import org.codehaus.wadi.impl.SimplePartitionMapper;

public class ClusteredManager
extends DistributableManager
implements ClusteredContextualiserConfig,
DispatcherConfig,
PartitionManagerConfig {
    protected final Dispatcher _dispatcher;
    protected final PartitionManager _partitionManager;
    protected final Map _distributedState;
    protected final Collapser _collapser;
    protected DIndex _dindex;
    protected final InvocationProxy _proxy;
    protected final ProxiedLocation _location;

    public ClusteredManager(SessionPool sessionPool, AttributesFactory attributesFactory, ValuePool valuePool, SessionWrapperFactory sessionWrapperFactory, SessionIdFactory sessionIdFactory, Contextualiser contextualiser, Map sessionMap, Router router, boolean errorIfSessionNotAcquired, Streamer streamer, boolean accessOnLoad, ReplicaterFactory replicaterFactory, ProxiedLocation location, InvocationProxy proxy, Dispatcher dispatcher, PartitionManager partitionManager, Collapser collapser) {
        super(sessionPool, attributesFactory, valuePool, sessionWrapperFactory, sessionIdFactory, contextualiser, sessionMap, router, errorIfSessionNotAcquired, streamer, accessOnLoad, replicaterFactory);
        this._location = location;
        this._proxy = proxy;
        this._dispatcher = dispatcher;
        this._partitionManager = partitionManager;
        this._distributedState = new HashMap();
        this._collapser = collapser;
    }

    public String getContextPath() {
        return "/";
    }

    public void init(ManagerConfig config) {
        try {
            this._dispatcher.init(this);
            String nodeName = this._dispatcher.getNodeName();
            int numPartitions = this._partitionManager.getNumPartitions();
            this._distributedState.put("name", nodeName);
            this._distributedState.put("http", this._location);
            SimplePartitionMapper mapper = new SimplePartitionMapper(numPartitions);
            this._dindex = new DIndex(nodeName, numPartitions, this._dispatcher.getInactiveTime(), this._dispatcher, this._distributedState, mapper);
            this._dindex.init(this);
        }
        catch (Exception e) {
            this._log.error((Object)"problem starting Cluster", (Throwable)e);
        }
        super.init(config);
    }

    public void start() throws Exception {
        this._dispatcher.setDistributedState(this._distributedState);
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("distributed state updated: " + this._distributedState));
        }
        this._dispatcher.start();
        this._dindex.start();
        super.start();
    }

    public void aboutToStop() throws Exception {
        this._dindex.getPartitionManager().evacuate();
    }

    public void stop() throws Exception {
        this._shuttingDown.set(true);
        super.stop();
        this._dindex.stop();
        this._dispatcher.stop();
    }

    public void destroy(String key) {
        Session session = (Session)this._map.get(key);
        if (null == session) {
            throw new IllegalArgumentException("Provided session id is unknown.");
        }
        this.destroy(session);
    }

    public void destroy(Session session) {
        ArrayList names = new ArrayList(this._attributeListeners.length > 0 ? session.getAttributeNameSet() : ((DistributableSession)session).getListenerNames());
        Iterator i = names.iterator();
        while (i.hasNext()) {
            session.removeAttribute((String)i.next());
        }
        String name = session.getName();
        this.notifySessionDeletion(name);
        this._map.remove(name);
        try {
            session.destroy();
        }
        catch (Exception e) {
            this._log.warn((Object)"unexpected problem destroying session", (Throwable)e);
        }
        this._sessionPool.put(session);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("destroyed: " + name));
        }
    }

    public String getNodeName() {
        return this._dispatcher.getNodeName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDistributedState(Object key) {
        Map map = this._distributedState;
        synchronized (map) {
            return this._distributedState.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putDistributedState(Object key, Object newValue) {
        Map map = this._distributedState;
        synchronized (map) {
            return this._distributedState.put(key, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeDistributedState(Object key) {
        Map map = this._distributedState;
        synchronized (map) {
            return this._distributedState.remove(key);
        }
    }

    public void distributeState() throws Exception {
        this._dispatcher.setDistributedState(this._distributedState);
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("distributed state updated: " + this._distributedState));
        }
    }

    public Map getDistributedState() {
        return this._distributedState;
    }

    public long getInactiveTime() {
        return this._dispatcher.getInactiveTime();
    }

    public int getNumPartitions() {
        return 72;
    }

    public Dispatcher getDispatcher() {
        return this._dispatcher;
    }

    public DIndex getDIndex() {
        return this._dindex;
    }

    public void notifySessionInsertion(String name) {
        super.notifySessionInsertion(name);
    }

    public void notifySessionDeletion(String name) {
        super.notifySessionDeletion(name);
        this._dindex.remove(name);
    }

    public void notifySessionRelocation(String name) {
        super.notifySessionRelocation(name);
        this._dindex.relocate(name);
    }

    protected boolean validateSessionName(String name) {
        return this._dindex.insert(name, this.getInactiveTime());
    }

    public void findRelevantSessionNames(int numPartitions, Collection[] resultSet) {
        this._log.info((Object)"findRelevantSessionNames");
        this._contextualiser.findRelevantSessionNames(numPartitions, resultSet);
    }

    public InvocationProxy getInvocationProxy() {
        return this._proxy;
    }

    public ProxiedLocation getProxiedLocation() {
        return this._location;
    }

    public Node getCoordinatorNode() {
        return this._dindex.getCoordinator();
    }

    public boolean contextualise(InvocationContext invocationContext, String id, Immoter immoter, Sync motionLock, boolean exclusiveOnly) throws InvocationException {
        return this._contextualiser.contextualise(invocationContext, id, immoter, motionLock, exclusiveOnly);
    }

    public Immoter getImmoter(String name, Motable immotable) {
        return this._contextualiser.getDemoter(name, immotable);
    }

    public String getNodeName(Destination destination) {
        return this._dispatcher.getNodeName(destination);
    }

    public Sync getInvocationLock(String name) {
        return this._collapser.getLock(name);
    }

    static class HelperPair {
        final Class _type;
        final ValueHelper _helper;

        HelperPair(Class type, ValueHelper helper) {
            this._type = type;
            this._helper = helper;
        }
    }
}

