/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.ConnectMethod;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.MultipartPostMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.IrrecoverableException;
import org.codehaus.wadi.ProxyingException;
import org.codehaus.wadi.impl.AbstractHttpProxy;
import org.codehaus.wadi.impl.WebInvocationContext;

public class CommonsHttpProxy
extends AbstractHttpProxy {
    protected static final Log _log = LogFactory.getLog((Class)CommonsHttpProxy.class);
    protected static final Map _methods = new HashMap();

    public CommonsHttpProxy(String sessionPathParamKey) {
        super(sessionPathParamKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doProxy(InetSocketAddress location, WebInvocationContext context) throws ProxyingException {
        int server2ClientTotal;
        int code;
        int client2ServerTotal;
        String uri;
        long startTime;
        block36: {
            HttpServletRequest hreq = context.getHreq();
            HttpServletResponse hres = context.getHres();
            startTime = System.currentTimeMillis();
            String m = hreq.getMethod();
            Class clazz = (Class)_methods.get(m);
            if (clazz == null) {
                throw new IrrecoverableException("unsupported http method: " + m);
            }
            HttpMethod hm = null;
            try {
                hm = (HttpMethod)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IrrecoverableException("could not create HttpMethod instance", e);
            }
            uri = this.getRequestURI(hreq);
            hm.setPath(uri);
            String queryString = hreq.getQueryString();
            if (queryString != null) {
                hm.setQueryString(queryString);
                uri = uri + queryString;
            }
            hm.setFollowRedirects(false);
            hm.setStrictMode(false);
            String connectionHdr = hreq.getHeader("Connection");
            if (connectionHdr != null && ((connectionHdr = connectionHdr.toLowerCase()).equals("keep-alive") || connectionHdr.equals("close"))) {
                connectionHdr = null;
            }
            boolean xForwardedFor = false;
            boolean hasContent = false;
            int contentLength = 0;
            Enumeration enm = hreq.getHeaderNames();
            while (enm.hasMoreElements()) {
                String lhdr;
                String hdr;
                block35: {
                    hdr = (String)enm.nextElement();
                    lhdr = hdr.toLowerCase();
                    if (_DontProxyHeaders.contains(lhdr) || connectionHdr != null && connectionHdr.indexOf(lhdr) >= 0) continue;
                    if ("content-length".equals(lhdr)) {
                        try {
                            contentLength = hreq.getIntHeader(hdr);
                            hasContent = contentLength > 0;
                        }
                        catch (NumberFormatException e) {
                            if (!_log.isWarnEnabled()) break block35;
                            _log.warn((Object)("bad Content-Length header value: " + hreq.getHeader(hdr)), (Throwable)e);
                        }
                    }
                }
                if ("content-type".equals(lhdr)) {
                    hasContent = true;
                }
                Enumeration vals = hreq.getHeaders(hdr);
                while (vals.hasMoreElements()) {
                    String val = (String)vals.nextElement();
                    if (val == null) continue;
                    hm.addRequestHeader(hdr, val);
                    xForwardedFor |= "X-Forwarded-For".equalsIgnoreCase(hdr);
                }
            }
            HttpState state = new HttpState();
            javax.servlet.http.Cookie[] cookies = hreq.getCookies();
            if (cookies != null) {
                for (int i = 0; i < cookies.length; ++i) {
                    String cpath;
                    javax.servlet.http.Cookie c = cookies[i];
                    String domain = c.getDomain();
                    if (domain == null) {
                        domain = hreq.getServerName();
                    }
                    if ((cpath = c.getPath()) == null) {
                        cpath = hreq.getContextPath();
                    }
                    Cookie cookie = new Cookie(domain, c.getName(), c.getValue(), cpath, c.getMaxAge(), c.getSecure());
                    state.addCookie(cookie);
                }
            }
            hm.addRequestHeader("Via", "1.1 " + hreq.getLocalName() + ":" + hreq.getLocalPort() + " \"WADI\"");
            if (!xForwardedFor) {
                hm.addRequestHeader("X-Forwarded-For", hreq.getRemoteAddr());
            }
            client2ServerTotal = 0;
            if (hasContent) {
                try {
                    if (hm instanceof EntityEnclosingMethod) {
                        ((EntityEnclosingMethod)hm).setRequestBody((InputStream)hreq.getInputStream());
                    }
                }
                catch (IOException e) {
                    throw new IrrecoverableException("could not pss request input across proxy", e);
                }
            }
            try {
                HttpClient client = new HttpClient();
                HostConfiguration hc = new HostConfiguration();
                String host = location.getHostName();
                hc.setHost(host, location.getPort());
                client.executeMethod(hc, hm, state);
            }
            catch (IOException e) {
                _log.warn((Object)"problem proxying connection:", (Throwable)e);
            }
            InputStream fromServer = null;
            code = 502;
            code = hm.getStatusCode();
            hres.setStatus(code);
            try {
                fromServer = hm.getResponseBodyAsStream();
            }
            catch (IOException e) {
                _log.warn((Object)"problem acquiring http client output", (Throwable)e);
            }
            hres.setHeader("Date", null);
            hres.setHeader("Server", null);
            Header[] headers = hm.getResponseHeaders();
            for (int i = 0; i < headers.length; ++i) {
                String h = headers[i].toExternalForm();
                int index = h.indexOf(58);
                String key = h.substring(0, index).trim().toLowerCase();
                String val = h.substring(index + 1, h.length()).trim();
                if (val == null || _DontProxyHeaders.contains(key)) continue;
                hres.addHeader(key, val);
            }
            hres.addHeader("Via", "1.1 (WADI)");
            server2ClientTotal = 0;
            if (fromServer != null) {
                ServletOutputStream toClient = hres.getOutputStream();
                server2ClientTotal += this.copy(fromServer, (OutputStream)toClient, 8192);
                Object var29_39 = null;
                try {
                    fromServer.close();
                }
                catch (IOException e2) {
                    _log.warn((Object)"problem closing server response stream", (Throwable)e2);
                }
                break block36;
                {
                    catch (IOException e) {
                        _log.warn((Object)"problem proxying server response back to client", (Throwable)e);
                        Object var29_40 = null;
                        try {
                            fromServer.close();
                        }
                        catch (IOException e2) {
                            _log.warn((Object)"problem closing server response stream", (Throwable)e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var29_41 = null;
                    try {
                        fromServer.close();
                    }
                    catch (IOException e2) {
                        _log.warn((Object)"problem closing server response stream", (Throwable)e2);
                    }
                    throw throwable;
                }
            }
        }
        long endTime = System.currentTimeMillis();
        long elapsed = endTime - startTime;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("in:" + client2ServerTotal + ", out:" + server2ClientTotal + ", status:" + code + ", time:" + elapsed + ", url:http://" + location.getHostName() + ":" + location.getPort() + uri));
        }
    }

    static {
        _methods.put("CONNECT", ConnectMethod.class);
        _methods.put("DELETE", DeleteMethod.class);
        _methods.put("GET", GetMethod.class);
        _methods.put("HEAD", HeadMethod.class);
        _methods.put("OPTIONS", OptionsMethod.class);
        _methods.put("TRACE", TraceMethod.class);
        _methods.put("POST", MultipartPostMethod.class);
        _methods.put("PUT", PutMethod.class);
    }
}

