/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.DatabaseMotableConfig;
import org.codehaus.wadi.Motable;
import org.codehaus.wadi.StoreMotable;
import org.codehaus.wadi.StoreMotableConfig;
import org.codehaus.wadi.impl.AbstractMotable;

public class DatabaseMotable
extends AbstractMotable
implements StoreMotable {
    protected static final Log _log = LogFactory.getLog((Class)DatabaseMotable.class);
    protected DatabaseMotableConfig _config;
    protected Connection _connection;

    public void init(StoreMotableConfig config) {
        this._config = (DatabaseMotableConfig)config;
    }

    public void init(StoreMotableConfig config, String name) throws Exception {
        this._config = (DatabaseMotableConfig)config;
        this._name = name;
        this._config.loadHeader(this._connection, this);
    }

    public Connection getConnection() {
        return this._connection;
    }

    public void setConnection(Connection connection) {
        this._connection = connection;
    }

    public byte[] getBodyAsByteArray() throws Exception {
        return (byte[])this._config.loadBody(this._connection, this);
    }

    public void setBodyAsByteArray(byte[] body) throws Exception {
        this.store(body);
    }

    public ByteBuffer getBodyAsByteBuffer() throws Exception {
        throw new UnsupportedOperationException("NYI");
    }

    public void setBodyAsByteBuffer(ByteBuffer body) throws Exception {
        throw new UnsupportedOperationException("NYI");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(Motable motable) throws Exception {
        try {
            this._connection = this._config.getDataSource().getConnection();
            super.copy(motable);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var3_3 = null;
                try {
                    this._connection.close();
                    this._connection = null;
                }
                catch (SQLException e) {
                    if (!_log.isWarnEnabled()) break block7;
                    _log.warn((Object)"load (database) problem releasing connection", (Throwable)e);
                }
            }
            throw throwable;
        }
        try {
            this._connection.close();
            this._connection = null;
        }
        catch (SQLException e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"load (database) problem releasing connection", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mote(Motable recipient) throws Exception {
        try {
            this._connection = this._config.getDataSource().getConnection();
            recipient.copy(this);
            this.destroy(recipient);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var3_3 = null;
                try {
                    this._connection.close();
                    this._connection = null;
                }
                catch (SQLException e) {
                    if (!_log.isWarnEnabled()) break block7;
                    _log.warn((Object)"load (database) problem releasing connection", (Throwable)e);
                }
            }
            throw throwable;
        }
        try {
            this._connection.close();
            this._connection = null;
        }
        catch (SQLException e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"load (database) problem releasing connection", (Throwable)e);
            }
        }
    }

    public void destroy() throws Exception {
        this._config.delete(this._connection, this);
        super.destroy();
    }

    public void destroy(Motable recipient) throws Exception {
        super.destroy();
        if (!this._config.getReusingStore()) {
            this._config.delete(this._connection, this);
        }
    }

    protected void store(Object body) throws Exception {
        this._config.insert(this._connection, this, body);
    }
}

