/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.DatabaseMotableConfig;
import org.codehaus.wadi.Motable;
import org.codehaus.wadi.Store;
import org.codehaus.wadi.StoreMotable;
import org.codehaus.wadi.impl.DatabaseMotable;

public class DatabaseStore
implements Store,
DatabaseMotableConfig {
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected final String _label;
    protected final DataSource _dataSource;
    protected final String _table;
    protected final boolean _useNIO;
    protected final boolean _reusingStore;
    protected final boolean _build;

    public DatabaseStore(String label, DataSource dataSource, String table, boolean useNIO, boolean reusingStore, boolean build) {
        this._label = label;
        this._dataSource = dataSource;
        this._table = table;
        this._useNIO = useNIO;
        this._reusingStore = reusingStore;
        this._build = build;
        if (this._build) {
            try {
                this.init();
            }
            catch (SQLException e) {
                this._log.warn((Object)"unexpected exception", (Throwable)e);
            }
        }
    }

    public String getLabel() {
        return this._label;
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public Connection getConnection() throws SQLException {
        return this._dataSource.getConnection();
    }

    public String getTable() {
        return this._table;
    }

    public boolean getReusingStore() {
        return this._reusingStore;
    }

    public void init() throws SQLException {
        Connection c = this._dataSource.getConnection();
        Statement s = c.createStatement();
        try {
            s.execute("CREATE TABLE " + this._table + "(Name varchar(50), CreationTime long, LastAccessedTime long, MaxInactiveInterval int, Body varbinary(" + 716800 + "))");
        }
        catch (SQLException e) {
            this._log.warn((Object)e);
        }
        s.close();
        c.close();
    }

    public void destroy() throws SQLException {
        Connection c = this._dataSource.getConnection();
        Statement s = c.createStatement();
        try {
            s.execute("DROP TABLE " + this._table);
        }
        catch (SQLException e) {
            this._log.warn((Object)e);
        }
        s.close();
        c.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void clean() {
        block21: {
            Statement s;
            Connection connection;
            block19: {
                connection = null;
                s = null;
                connection = this._dataSource.getConnection();
                s = connection.createStatement();
                s.executeUpdate("DELETE FROM " + this._table);
                if (!this._log.isTraceEnabled()) break block19;
                this._log.trace((Object)"removed (database) sessions from last run");
            }
            Object var5_3 = null;
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (SQLException e2) {
                this._log.warn((Object)"problem closing database statement", (Throwable)e2);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
                break block21;
            }
            catch (SQLException e2) {
                this._log.warn((Object)"problem closing database connection", (Throwable)e2);
            }
            break block21;
            {
                catch (SQLException e) {
                    if (this._log.isErrorEnabled()) {
                        this._log.error((Object)"remove (database) failed", (Throwable)e);
                    }
                    Object var5_4 = null;
                    try {
                        if (s != null) {
                            s.close();
                        }
                    }
                    catch (SQLException e2) {
                        this._log.warn((Object)"problem closing database statement", (Throwable)e2);
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block21;
                    }
                    catch (SQLException e2) {
                        this._log.warn((Object)"problem closing database connection", (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (SQLException e2) {
                    this._log.warn((Object)"problem closing database statement", (Throwable)e2);
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e2) {
                    this._log.warn((Object)"problem closing database connection", (Throwable)e2);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void load(Store.Putter putter, boolean accessOnLoad) {
        block34: {
            block32: {
                time = System.currentTimeMillis();
                s = null;
                count = 0;
                connection = null;
                try {
                    block31: {
                        connection = this._dataSource.getConnection();
                        s = connection.createStatement();
                        rs = s.executeQuery("SELECT Name, CreationTime, LastAccessedTime, MaxInactiveInterval FROM " + this._table);
                        name = null;
                        while (rs.next()) {
                            try {
                                i = 1;
                                motable = new DatabaseMotable();
                                name = (String)rs.getObject(i++);
                                creationTime = rs.getLong(i++);
                                lastAccessedTime = rs.getLong(i++);
                                lastAccessedTime = accessOnLoad != false ? time : lastAccessedTime;
                                maxInactiveInterval = rs.getInt(i++);
                                motable.init(creationTime, lastAccessedTime, maxInactiveInterval, name);
                                motable.init(this);
                                if (motable.getTimedOut(time) && this._log.isWarnEnabled()) {
                                    this._log.warn((Object)("LOADED DEAD SESSION: " + motable.getName()));
                                }
                                putter.put(name, motable);
                                ++count;
                            }
                            catch (Exception e) {
                                if (!this._log.isErrorEnabled()) continue;
                                this._log.error((Object)("load (shared database) failed: " + name), (Throwable)e);
                            }
                        }
                        if (!this._log.isInfoEnabled()) break block31;
                        this._log.info((Object)("loaded sessions: " + count));
                    }
                    var18_17 = null;
                    ** if (s == null) goto lbl-1000
                }
                catch (Throwable var17_23) {
                    block33: {
                        var18_19 = null;
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (SQLException e) {
                                if (!this._log.isWarnEnabled()) break block33;
                                this._log.warn((Object)"load (shared database) problem", (Throwable)e);
                            }
                        }
                    }
                    throw var17_23;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        s.close();
                    }
                    catch (SQLException e) {
                        if (this._log.isWarnEnabled()) {
                            this._log.warn((Object)"load (shared database) problem", (Throwable)e);
                        }
                    }
                }
lbl-1000:
                // 4 sources

                {
                    break block32;
                    catch (SQLException e) {
                        this._log.warn((Object)"list (shared database) failed", (Throwable)e);
                        var18_18 = null;
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (SQLException e) {
                                if (this._log.isWarnEnabled()) {
                                    this._log.warn((Object)"load (shared database) problem", (Throwable)e);
                                }
                            }
                        }
                    }
                }
            }
            if (!this._reusingStore) {
                try {
                    s = connection.createStatement();
                    s.executeUpdate("DELETE FROM " + this._table);
                    var21_24 = null;
                    ** if (s == null) goto lbl-1000
                }
                catch (Throwable var20_30) {
                    block35: {
                        var21_26 = null;
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (SQLException e) {
                                if (!this._log.isWarnEnabled()) break block35;
                                this._log.warn((Object)"load (shared database) problem", (Throwable)e);
                            }
                        }
                    }
                    throw var20_30;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        s.close();
                    }
                    catch (SQLException e) {
                        if (this._log.isWarnEnabled()) {
                            this._log.warn((Object)"load (shared database) problem", (Throwable)e);
                        }
                    }
                }
lbl-1000:
                // 4 sources

                {
                    break block34;
                    catch (SQLException e) {
                        this._log.warn((Object)"removal (shared database) failed", (Throwable)e);
                        var21_25 = null;
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (SQLException e) {
                                if (this._log.isWarnEnabled()) {
                                    this._log.warn((Object)"load (shared database) problem", (Throwable)e);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadHeader(Connection connection, Motable motable) {
        Statement s;
        String name;
        block10: {
            name = motable.getName();
            s = null;
            s = connection.createStatement();
            ResultSet rs = s.executeQuery("SELECT CreationTime, LastAccessedTime, MaxInactiveInterval FROM " + this._table + " WHERE Name='" + name + "'");
            int i = 1;
            if (!rs.next()) break block10;
            long creationTime = rs.getLong(i++);
            long lastAccessedTime = rs.getLong(i++);
            int maxInactiveInterval = rs.getInt(i++);
            motable.init(creationTime, lastAccessedTime, maxInactiveInterval);
            if (!motable.checkTimeframe(System.currentTimeMillis()) && this._log.isWarnEnabled()) {
                this._log.warn((Object)("loaded (database [" + this._table + "]) from the future!: " + name));
            }
            if (!this._log.isTraceEnabled()) break block10;
            this._log.trace((Object)("loaded (database [" + this._table + "]): " + name));
        }
        Object var13_11 = null;
        if (s == null) return;
        try {
            s.close();
            return;
        }
        catch (SQLException e2) {
            if (!this._log.isWarnEnabled()) return;
            this._log.warn((Object)("load (database [" + this._table + "]) problem: " + name), (Throwable)e2);
        }
        return;
        {
            catch (SQLException e) {
                if (this._log.isWarnEnabled()) {
                    this._log.warn((Object)("load (database [" + this._table + "]) failed: " + name), (Throwable)e);
                }
                Object var13_12 = null;
                if (s == null) return;
                try {
                    s.close();
                    return;
                }
                catch (SQLException e2) {
                    if (!this._log.isWarnEnabled()) return;
                    this._log.warn((Object)("load (database [" + this._table + "]) problem: " + name), (Throwable)e2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (s == null) throw throwable;
            try {
                s.close();
                throw throwable;
            }
            catch (SQLException e2) {
                if (!this._log.isWarnEnabled()) throw throwable;
                this._log.warn((Object)("load (database [" + this._table + "]) problem: " + name), (Throwable)e2);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public Object loadBody(Connection connection, Motable motable) throws Exception {
        Object var8_10;
        Statement s;
        String name;
        block14: {
            block12: {
                Object object;
                block13: {
                    name = motable.getName();
                    s = null;
                    Object body = null;
                    s = connection.createStatement();
                    ResultSet rs = s.executeQuery("SELECT Body FROM " + this._table + " WHERE Name='" + name + "'");
                    int i = 1;
                    if (!rs.next()) break block12;
                    if (this._useNIO) {
                        throw new UnsupportedOperationException("NYI");
                    }
                    body = rs.getObject(i++);
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("loaded (database): " + this._label + "/" + this._table + "/" + name + ": " + ((byte[])body).length + " bytes"));
                    }
                    object = body;
                    Object var10_11 = null;
                    if (s == null) break block13;
                    try {
                        s.close();
                    }
                    catch (SQLException e2) {
                        if (!this._log.isWarnEnabled()) break block13;
                        this._log.warn((Object)("load (database [" + this._table + "]) problem: " + name), (Throwable)e2);
                    }
                }
                return object;
            }
            var8_10 = null;
            Object var10_12 = null;
            if (s == null) break block14;
            try {
                s.close();
            }
            catch (SQLException e2) {
                if (!this._log.isWarnEnabled()) break block14;
                this._log.warn((Object)("load (database [" + this._table + "]) problem: " + name), (Throwable)e2);
            }
        }
        return var8_10;
        catch (SQLException e) {
            try {
                if (this._log.isWarnEnabled()) {
                    this._log.warn((Object)("load (database [" + this._table + "]) failed: " + name), (Throwable)e);
                }
                throw e;
            }
            catch (Throwable throwable) {
                block15: {
                    Object var10_13 = null;
                    if (s == null) break block15;
                    try {
                        s.close();
                    }
                    catch (SQLException e2) {
                        if (!this._log.isWarnEnabled()) break block15;
                        this._log.warn((Object)("load (database [" + this._table + "]) problem: " + name), (Throwable)e2);
                    }
                }
                throw throwable;
            }
        }
    }

    public void update(Connection connection, Motable motable) throws Exception {
        Statement ps = null;
        String name = motable.getName();
        byte[] body = motable.getBodyAsByteArray();
        try {
            ps = connection.prepareStatement("UPDATE " + this._table + " SET LastAccessedTime=?, MaxInactiveInterval=?, Body=? where Name=?");
            int i = 1;
            ps.setLong(i++, motable.getLastAccessedTime());
            ps.setInt(i++, motable.getMaxInactiveInterval());
            if (this._useNIO) {
                ++i;
                throw new UnsupportedOperationException("NYI");
            }
            ps.setObject(i++, body);
            ps.setString(i++, name);
            ps.executeUpdate();
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("updated (database): " + this._label + "/" + this._table + "/" + name + ": " + body.length + " bytes"));
            }
        }
        catch (SQLException e) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)("update (database) failed: " + name), (Throwable)e);
            }
            throw e;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public void insert(Connection connection, Motable motable, Object body) throws Exception {
        Statement ps = null;
        String name = motable.getName();
        try {
            ps = connection.prepareStatement("INSERT INTO " + this._table + " (Name, CreationTime, LastAccessedTime, MaxInactiveInterval, Body) VALUES (?, ?, ?, ?, ?)");
            int i = 1;
            ps.setString(i++, name);
            ps.setLong(i++, motable.getCreationTime());
            ps.setLong(i++, motable.getLastAccessedTime());
            ps.setInt(i++, motable.getMaxInactiveInterval());
            if (this._useNIO) {
                ++i;
                throw new UnsupportedOperationException("NYI");
            }
            ps.setObject(i++, body);
            ps.executeUpdate();
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("stored (database): " + this._label + "/" + this._table + "/" + name + ": " + ((byte[])body).length + " bytes"));
            }
        }
        catch (SQLException e) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)("store (database) failed: " + name), (Throwable)e);
            }
            throw e;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void delete(Connection connection, Motable motable) {
        block13: {
            Statement s;
            block12: {
                s = null;
                s = connection.createStatement();
                s.executeUpdate("DELETE FROM " + this._table + " WHERE Name='" + motable.getName() + "'");
                if (!this._log.isTraceEnabled()) break block12;
                this._log.trace((Object)("removed (database ): " + this._label + "/" + this._table + "/" + motable));
            }
            Object var6_4 = null;
            try {
                if (s != null) {
                    s.close();
                }
                break block13;
            }
            catch (SQLException e2) {
                this._log.warn((Object)"problem closing database connection", (Throwable)e2);
            }
            break block13;
            {
                catch (SQLException e) {
                    if (this._log.isErrorEnabled()) {
                        this._log.error((Object)("remove (database [" + this._table + "]) failed: " + motable), (Throwable)e);
                    }
                    Object var6_5 = null;
                    try {
                        if (s != null) {
                            s.close();
                        }
                        break block13;
                    }
                    catch (SQLException e2) {
                        this._log.warn((Object)"problem closing database connection", (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (SQLException e2) {
                    this._log.warn((Object)"problem closing database connection", (Throwable)e2);
                }
                throw throwable;
            }
        }
    }

    public String getStartInfo() {
        return this._dataSource.toString();
    }

    public String getDescription() {
        return "[" + this._label + "/" + this._table + "]";
    }

    public StoreMotable create() {
        return new DatabaseMotable();
    }

    public boolean getUseNIO() {
        return this._useNIO;
    }
}

