/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.DiscMotableConfig;
import org.codehaus.wadi.Motable;
import org.codehaus.wadi.StoreMotable;
import org.codehaus.wadi.StoreMotableConfig;
import org.codehaus.wadi.impl.AbstractMotable;

public class DiscMotable
extends AbstractMotable
implements StoreMotable {
    protected static final Log _log;
    protected DiscMotableConfig _config;
    protected File _file;
    protected int _bodyLength;
    protected long _offset;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void init(StoreMotableConfig config) {
        this._config = (DiscMotableConfig)config;
    }

    public void init(StoreMotableConfig config, String name) throws Exception {
        this._config = (DiscMotableConfig)config;
        this._name = name;
        this._offset = this.loadHeader();
        if (!$assertionsDisabled && !name.equals(this._name)) {
            throw new AssertionError();
        }
    }

    public byte[] getBodyAsByteArray() throws Exception {
        this.ensureFile();
        return (byte[])this.loadBody(false);
    }

    public void setBodyAsByteArray(byte[] body) throws Exception {
        this.ensureFile();
        this._bodyLength = body.length;
        this.store(false, body);
    }

    public ByteBuffer getBodyAsByteBuffer() throws Exception {
        this.ensureFile();
        return (ByteBuffer)this.loadBody(true);
    }

    public void setBodyAsByteBuffer(ByteBuffer body) throws Exception {
        this.ensureFile();
        this._bodyLength = body.capacity();
        this.store(true, body);
    }

    public void destroy() throws Exception {
        super.destroy();
        if (this._file != null && this._file.exists()) {
            this._file.delete();
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("removed (exclusive disc): " + this._file + ": " + this._bodyLength + " bytes"));
            }
        }
    }

    public void destroy(Motable recipient) throws Exception {
        super.destroy();
        if (!this._config.getReusingStore() && this._file != null && this._file.exists()) {
            this._file.delete();
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("removed (exclusive disc): " + this._file + ": " + this._bodyLength + " bytes"));
            }
        }
    }

    protected void ensureFile() {
        if (this._file == null) {
            this._file = new File(this._config.getDirectory(), this._name + this._config.getSuffix());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long loadHeader() {
        long l;
        this.ensureFile();
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            try {
                fis = new FileInputStream(this._file);
                ois = new ObjectInputStream(fis);
                this._creationTime = ois.readLong();
                this._lastAccessedTime = ois.readLong();
                this._maxInactiveInterval = ois.readInt();
                this._name = (String)ois.readObject();
                this._bodyLength = ois.readInt();
                if (!this.checkTimeframe(System.currentTimeMillis()) && _log.isWarnEnabled()) {
                    _log.warn((Object)("loaded (exclusive disc) from the future!: " + this._name));
                }
                l = fis.getChannel().position();
                Object var7_5 = null;
                if (ois == null) return l;
            }
            catch (Exception e) {
                if (_log.isErrorEnabled()) {
                    _log.warn((Object)("load (exclusive disc) failed: " + this._file), (Throwable)e);
                }
                long l2 = -1L;
                Object var7_6 = null;
                if (ois == null) return l2;
                try {
                    ois.close();
                    return l2;
                }
                catch (IOException e2) {
                    if (!_log.isWarnEnabled()) return l2;
                    _log.warn((Object)("load (exclusive disc) problem: " + this._file), (Throwable)e2);
                }
                return l2;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (ois == null) throw throwable;
            try {}
            catch (IOException e2) {
                if (!_log.isWarnEnabled()) throw throwable;
                _log.warn((Object)("load (exclusive disc) problem: " + this._file), (Throwable)e2);
                throw throwable;
            }
            ois.close();
            throw throwable;
        }
        try {}
        catch (IOException e2) {
            if (!_log.isWarnEnabled()) return l;
            _log.warn((Object)("load (exclusive disc) problem: " + this._file), (Throwable)e2);
            return l;
        }
        ois.close();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object loadBody(boolean useNIO) throws Exception {
        Object object;
        this.ensureFile();
        FileInputStream fis = null;
        try {
            try {
                Object body;
                fis = new FileInputStream(this._file);
                FileChannel channel = fis.getChannel();
                channel.position(this._offset);
                if (useNIO) {
                    ByteBuffer buffer = this._config.take(this._bodyLength);
                    channel.read(buffer);
                    buffer.flip();
                    body = buffer;
                } else {
                    byte[] array = new byte[this._bodyLength];
                    fis.read(array);
                    body = array;
                }
                long position = channel.position();
                long bytesLoaded = position - this._offset;
                if (!$assertionsDisabled && bytesLoaded != (long)this._bodyLength) {
                    throw new AssertionError();
                }
                if (_log.isTraceEnabled()) {
                    _log.trace((Object)("loaded (" + (useNIO ? "NIO " : "") + "exclusive disc): " + this._file + ": " + bytesLoaded + " bytes"));
                }
                object = body;
                Object var11_10 = null;
            }
            catch (Exception e) {
                if (!_log.isErrorEnabled()) throw e;
                _log.error((Object)("load (" + (useNIO ? "NIO " : "") + "exclusive disc) failed: " + this._file));
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            try {
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            catch (IOException e2) {
                if (!_log.isWarnEnabled()) throw throwable;
                _log.warn((Object)("load (" + (useNIO ? "NIO " : "") + "exclusive disc) problem: " + this._file), (Throwable)e2);
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            if (!_log.isWarnEnabled()) return object;
            _log.warn((Object)("load (" + (useNIO ? "NIO " : "") + "exclusive disc) problem: " + this._file), (Throwable)e2);
            return object;
        }
        if (fis == null) return object;
        fis.close();
        return object;
    }

    /*
     * Loose catch block
     */
    protected void store(boolean useNIO, Object body) throws Exception {
        block16: {
            ObjectOutputStream oos;
            block15: {
                this.ensureFile();
                oos = null;
                FileOutputStream fos = null;
                fos = new FileOutputStream(this._file);
                oos = new ObjectOutputStream(fos);
                oos.writeLong(this._creationTime);
                oos.writeLong(this._lastAccessedTime);
                oos.writeInt(this._maxInactiveInterval);
                oos.writeObject(this._name);
                oos.writeInt(this._bodyLength);
                oos.flush();
                FileChannel channel = fos.getChannel();
                this._offset = channel.position();
                if (this._bodyLength > 0) {
                    if (useNIO) {
                        ByteBuffer buffer = (ByteBuffer)body;
                        channel.write(buffer);
                        this._config.put(buffer);
                    } else {
                        fos.write((byte[])body);
                    }
                }
                long bytesStored = channel.position() - this._offset;
                if (!$assertionsDisabled && (long)this._bodyLength != bytesStored) {
                    throw new AssertionError();
                }
                if (!_log.isTraceEnabled()) break block15;
                _log.trace((Object)("stored (" + (useNIO ? "NIO " : "") + "exclusive disc): " + this._file + ": " + bytesStored + " bytes"));
            }
            Object var9_9 = null;
            try {
                if (oos != null) {
                    oos.close();
                }
                break block16;
            }
            catch (IOException e) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("store (" + (useNIO ? "NIO " : "") + "exclusive disc) problem: " + this._file), (Throwable)e);
                }
                break block16;
            }
            {
                catch (Exception e) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("store (" + (useNIO ? "NIO " : "") + "exclusive disc) failed: " + this._file));
                    }
                    throw e;
                }
            }
            catch (Throwable throwable) {
                block17: {
                    Object var9_10 = null;
                    try {
                        if (oos != null) {
                            oos.close();
                        }
                    }
                    catch (IOException e) {
                        if (!_log.isWarnEnabled()) break block17;
                        _log.warn((Object)("store (" + (useNIO ? "NIO " : "") + "exclusive disc) problem: " + this._file), (Throwable)e);
                    }
                }
                throw throwable;
            }
        }
    }

    static {
        $assertionsDisabled = !DiscMotable.class.desiredAssertionStatus();
        _log = LogFactory.getLog((Class)DiscMotable.class);
    }
}

