/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.DiscMotableConfig;
import org.codehaus.wadi.Store;
import org.codehaus.wadi.StoreMotable;
import org.codehaus.wadi.Streamer;
import org.codehaus.wadi.impl.DirectByteBufferCache;
import org.codehaus.wadi.impl.DiscMotable;

public class DiscStore
implements Store,
DiscMotableConfig {
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected final Streamer _streamer;
    protected final File _dir;
    protected final boolean _useNIO;
    protected final DirectByteBufferCache _cache = new DirectByteBufferCache();
    protected final boolean _reusingStore;

    public DiscStore(Streamer streamer, File dir, boolean useNIO, boolean reusingStore) throws Exception {
        this._streamer = streamer;
        this._dir = dir;
        this._useNIO = useNIO;
        this._reusingStore = reusingStore;
        if (!dir.exists()) {
            this._log.info((Object)("Creating directory: " + this._dir.getCanonicalPath()));
            if (!dir.mkdirs()) {
                throw new IOException("Couldn't create directory " + this._dir.getCanonicalPath());
            }
        }
        try {
            File.createTempFile("DiscStore_WriteTest", null, this._dir).delete();
        }
        catch (IOException e) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)("bad directory: " + this._dir), (Throwable)e);
            }
            throw e;
        }
    }

    public void clean() {
        File[] files = this._dir.listFiles();
        int l = files.length;
        for (int i = 0; i < l; ++i) {
            files[i].delete();
        }
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("removed (exclusive disc): " + l + " files"));
        }
    }

    public void load(Store.Putter putter, boolean accessOnLoad) {
        long time = System.currentTimeMillis();
        String[] list = this._dir.list();
        int l = list.length;
        int suffixLength = ".".length() + this._streamer.getSuffix().length();
        for (int i = 0; i < l; ++i) {
            String name = list[i];
            String id = name.substring(0, name.length() - suffixLength);
            DiscMotable motable = new DiscMotable();
            try {
                motable.init(this, id);
                if (accessOnLoad) {
                    motable.setLastAccessedTime(time);
                } else if (motable.getTimedOut(time) && this._log.isWarnEnabled()) {
                    this._log.warn((Object)("LOADED DEAD SESSION: " + motable.getName()));
                }
                putter.put(id, motable);
                continue;
            }
            catch (Exception e) {
                if (!this._log.isErrorEnabled()) continue;
                this._log.error((Object)("failed to load: " + name));
            }
        }
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("loaded (exclusive disc): " + list.length));
        }
    }

    public StoreMotable create() {
        return new DiscMotable();
    }

    public String getStartInfo() {
        return this._dir.toString();
    }

    public String getDescription() {
        return "exclusive disc";
    }

    public File getDirectory() {
        return this._dir;
    }

    public String getSuffix() {
        return this._streamer.getSuffixWithDot();
    }

    public boolean getUseNIO() {
        return this._useNIO;
    }

    public ByteBuffer take(int size) {
        return this._cache.take(size);
    }

    public void put(ByteBuffer buffer) {
        this._cache.put(buffer);
    }

    public boolean getReusingStore() {
        return this._reusingStore;
    }
}

