/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import org.codehaus.wadi.AttributesConfig;
import org.codehaus.wadi.DistributableAttributesConfig;
import org.codehaus.wadi.DistributableValueConfig;
import org.codehaus.wadi.SerializableContent;
import org.codehaus.wadi.Streamer;
import org.codehaus.wadi.ValueHelper;
import org.codehaus.wadi.impl.DistributableValue;
import org.codehaus.wadi.impl.StandardAttributes;

public class DistributableAttributes
extends StandardAttributes
implements SerializableContent,
DistributableValueConfig {
    protected Set _listenerNames = new HashSet();

    public DistributableAttributes(AttributesConfig config, Map map) {
        super(config, map);
    }

    public Set getListenerNames() {
        return this._listenerNames;
    }

    public Object remove(Object key) {
        Object oldValue = super.remove(key);
        if (this.isListener(oldValue)) {
            this._listenerNames.remove(key);
        }
        return oldValue;
    }

    public Object put(Object key, Object newValue) {
        boolean isListener;
        Object oldValue = super.put(key, newValue);
        boolean wasListener = this.isListener(oldValue);
        boolean bl = isListener = newValue == oldValue ? wasListener : this.isListener(newValue);
        if (wasListener == isListener) {
            return oldValue;
        }
        if (wasListener) {
            this._listenerNames.remove(key);
        }
        if (isListener) {
            this._listenerNames.add(key);
        }
        return oldValue;
    }

    protected boolean isListener(Object o) {
        return !((DistributableAttributesConfig)this._config).getHttpSessionAttributeListenersRegistered() && (o instanceof HttpSessionActivationListener || o instanceof HttpSessionBindingListener);
    }

    public void readContent(ObjectInput oi) throws IOException, ClassNotFoundException {
        this._listenerNames = (Set)oi.readObject();
        int size = oi.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = oi.readObject();
            DistributableValue val = (DistributableValue)this._config.getValuePool().take(this);
            val.readContent(oi);
            this._map.put(key, val);
        }
    }

    public void writeContent(ObjectOutput oo) throws IOException {
        oo.writeObject(this._listenerNames);
        oo.writeInt(this.size());
        Iterator i = this._map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            Object key = e.getKey();
            oo.writeObject(key);
            DistributableValue val = (DistributableValue)e.getValue();
            val.writeContent(oo);
        }
    }

    public ValueHelper findHelper(Class type) {
        return ((DistributableAttributesConfig)this._config).findHelper(type);
    }

    public boolean getHttpSessionAttributeListenersRegistered() {
        return ((DistributableAttributesConfig)this._config).getHttpSessionAttributeListenersRegistered();
    }

    public HttpSessionEvent getHttpSessionEvent() {
        return ((DistributableAttributesConfig)this._config).getHttpSessionEvent();
    }

    public Streamer getStreamer() {
        return ((DistributableAttributesConfig)this._config).getStreamer();
    }
}

