/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import javax.servlet.http.HttpSessionActivationListener;
import org.codehaus.wadi.DistributableValueConfig;
import org.codehaus.wadi.SerializableContent;
import org.codehaus.wadi.ValueHelper;
import org.codehaus.wadi.impl.StandardValue;

public class DistributableValue
extends StandardValue
implements SerializableContent {
    protected ValueHelper _helper;

    public DistributableValue(DistributableValueConfig config) {
        super(config);
    }

    public synchronized Object setValue(Object newValue) {
        if (newValue != null && !(newValue instanceof Serializable) && (this._helper = ((DistributableValueConfig)this._config).findHelper(newValue.getClass())) == null) {
            throw new IllegalArgumentException("Distributable HttpSession attribute values must be Serializable or of other designated type (see SRV.7.7.2)");
        }
        return super.setValue(newValue);
    }

    public synchronized void writeContent(ObjectOutput oo) throws IOException {
        if (this._value != null && this._value instanceof HttpSessionActivationListener) {
            ((HttpSessionActivationListener)this._value).sessionWillPassivate(this._config == null ? null : ((DistributableValueConfig)this._config).getHttpSessionEvent());
        }
        Object value = this._helper == null ? this._value : this._helper.replace(this._value);
        oo.writeObject(value);
    }

    public synchronized void readContent(ObjectInput oi) throws IOException, ClassNotFoundException {
        this._value = oi.readObject();
        if (this._value != null && !(this._value instanceof Serializable)) {
            this._helper = ((DistributableValueConfig)this._config).findHelper(this._value.getClass());
        }
        if (this._value != null && this._value instanceof HttpSessionActivationListener) {
            ((HttpSessionActivationListener)this._value).sessionDidActivate(this._config == null ? null : ((DistributableValueConfig)this._config).getHttpSessionEvent());
        }
    }
}

