/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import java.io.File;
import java.util.Map;
import org.codehaus.wadi.Collapser;
import org.codehaus.wadi.Contextualiser;
import org.codehaus.wadi.ContextualiserConfig;
import org.codehaus.wadi.DistributableContextualiserConfig;
import org.codehaus.wadi.Emoter;
import org.codehaus.wadi.Evicter;
import org.codehaus.wadi.Immoter;
import org.codehaus.wadi.Motable;
import org.codehaus.wadi.Session;
import org.codehaus.wadi.Store;
import org.codehaus.wadi.StoreMotable;
import org.codehaus.wadi.Streamer;
import org.codehaus.wadi.impl.AbstractExclusiveContextualiser;
import org.codehaus.wadi.impl.AbstractMappedEmoter;
import org.codehaus.wadi.impl.AbstractMappedImmoter;
import org.codehaus.wadi.impl.CollapsingLocker;
import org.codehaus.wadi.impl.DiscStore;

public class ExclusiveStoreContextualiser
extends AbstractExclusiveContextualiser {
    protected final Store _store;
    protected final Immoter _immoter;
    protected final Emoter _emoter;

    public ExclusiveStoreContextualiser(Contextualiser next, Collapser collapser, boolean clean, Evicter evicter, Map map, Streamer streamer, File dir) throws Exception {
        super(next, new CollapsingLocker(collapser), clean, evicter, map);
        this._store = new DiscStore(streamer, dir, true, false);
        this._immoter = new ExclusiveStoreImmoter(this._map);
        this._emoter = new ExclusiveStoreEmoter(this._map);
    }

    public void init(ContextualiserConfig config) {
        super.init(config);
        if (this._clean) {
            this._store.clean();
        }
    }

    public String getStartInfo() {
        return "[" + this._store.getStartInfo() + "]";
    }

    public boolean isExclusive() {
        return true;
    }

    public Immoter getImmoter() {
        return this._immoter;
    }

    public Emoter getEmoter() {
        return this._emoter;
    }

    public void start() throws Exception {
        Store.Putter putter = new Store.Putter(){

            public void put(String name, Motable motable) {
                ExclusiveStoreContextualiser.this._map.put(name, motable);
            }
        };
        this._store.load(putter, ((DistributableContextualiserConfig)this._config).getAccessOnLoad());
        super.start();
    }

    public void expire(Motable motable) {
        Session loaded;
        boolean needsLoading = true;
        String id = motable.getName();
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("expiring from disc: " + id));
        }
        if (needsLoading) {
            this._map.remove(id);
            loaded = this._config.getSessionPool().take();
            try {
                loaded.copy(motable);
                motable = null;
                this._config.expire(loaded);
            }
            catch (Exception e) {
                this._log.error((Object)"unexpected problem expiring from disc", (Throwable)e);
            }
        } else {
            throw new UnsupportedOperationException();
        }
        loaded = null;
    }

    class ExclusiveStoreEmoter
    extends AbstractMappedEmoter {
        public ExclusiveStoreEmoter(Map map) {
            super(map);
        }

        public String getInfo() {
            return ExclusiveStoreContextualiser.this._store.getDescription();
        }
    }

    public class ExclusiveStoreImmoter
    extends AbstractMappedImmoter {
        public ExclusiveStoreImmoter(Map map) {
            super(map);
        }

        public Motable nextMotable(String name, Motable emotable) {
            StoreMotable motable = ExclusiveStoreContextualiser.this._store.create();
            motable.init(ExclusiveStoreContextualiser.this._store);
            return motable;
        }

        public String getInfo() {
            return ExclusiveStoreContextualiser.this._store.getDescription();
        }
    }
}

