/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.Contextualiser;
import org.codehaus.wadi.InvocationContext;
import org.codehaus.wadi.InvocationException;
import org.codehaus.wadi.PoolableInvocationWrapper;
import org.codehaus.wadi.PoolableInvocationWrapperPool;
import org.codehaus.wadi.Router;
import org.codehaus.wadi.impl.DummyStatefulHttpServletRequestWrapperPool;
import org.codehaus.wadi.impl.StandardManager;
import org.codehaus.wadi.impl.WebInvocationContext;

public class Filter
implements javax.servlet.Filter {
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected StandardManager _manager;
    protected boolean _distributable;
    protected Contextualiser _contextualiser;
    protected Router _router;
    protected PoolableInvocationWrapperPool _pool = new DummyStatefulHttpServletRequestWrapperPool();
    protected boolean _errorIfSessionNotAcquired;
    protected SynchronizedBoolean _acceptingSessions;

    public void init(FilterConfig filterConfig) throws ServletException {
        this._manager = (StandardManager)filterConfig.getServletContext().getAttribute(StandardManager.class.getName());
        if (this._manager == null) {
            this._log.fatal((Object)"Manager not found");
        } else if (this._log.isInfoEnabled()) {
            this._log.info((Object)("Manager found: " + this._manager));
        }
        this._manager.setFilter(this);
        this._distributable = this._manager.getDistributable();
        this._contextualiser = this._manager.getContextualiser();
        this._router = this._manager.getRouter();
        this._errorIfSessionNotAcquired = this._manager.getErrorIfSessionNotAcquired();
        this._acceptingSessions = this._manager.getAcceptingSessions();
    }

    public void setManager(StandardManager manager) {
        this._manager = manager;
    }

    public void destroy() {
        this._pool = null;
        this._contextualiser = null;
        this._distributable = false;
        this._manager = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String sessionId = request.getRequestedSessionId();
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("potentially stateful request: " + sessionId));
        }
        WebInvocationContext invocationContext = new WebInvocationContext(request, response, chain);
        try {
            if (sessionId == null) {
                this.processSessionlessRequest(invocationContext);
            } else {
                String name = this._router.strip(sessionId);
                if (!this._contextualiser.contextualise(invocationContext, name, null, null, false)) {
                    if (this._log.isErrorEnabled()) {
                        this._log.error((Object)("could not acquire session: " + name));
                    }
                    if (this._errorIfSessionNotAcquired) {
                        response.sendError(503, "session " + name + " is not known");
                    } else {
                        this.processSessionlessRequest(invocationContext);
                    }
                }
            }
        }
        catch (InvocationException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof ServletException) {
                throw (ServletException)throwable;
            }
            throw new ServletException((Throwable)e);
        }
    }

    public void processSessionlessRequest(InvocationContext invocationContext) throws InvocationException {
        if (!this._acceptingSessions.get()) {
            this._log.warn((Object)"sessionless request has arived during shutdown - permitting");
        }
        PoolableInvocationWrapper wrapper = this._pool.take();
        wrapper.init(invocationContext, null);
        invocationContext.invoke(wrapper);
        wrapper.destroy();
        this._pool.put(wrapper);
    }
}

