/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.impl;

import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.SessionIdFactory;
import org.codehaus.wadi.gridstate.PartitionMapper;

public class FixedWidthSessionIdFactory
implements SessionIdFactory,
PartitionMapper {
    protected final Log _log = LogFactory.getLog((String)this.getClass().getName());
    protected static final char[] _defaultChars;
    protected final char[] _divider = "-".toCharArray();
    protected Random _random = new Random();
    protected final int[] _lookup = new int[65535];
    protected final int _keyLength;
    protected final char[] _chars;
    protected final int _base;
    protected final int _sectLength;
    protected final int _numPartitions;
    protected final int _partitionLength;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String create() {
        int width = this._keyLength;
        char[] buffer = new char[width];
        int offset = width - 1;
        while ((offset = this.encode(Math.abs(this._random.nextLong()), this._sectLength, buffer, offset)) >= 0) {
        }
        return new String(buffer);
    }

    public int getSessionIdLength() {
        return this._keyLength + this._divider.length + this._partitionLength;
    }

    public void setSessionIdLength(int l) {
    }

    public FixedWidthSessionIdFactory(int width, int numPartitions) {
        this(width, _defaultChars, numPartitions);
    }

    public FixedWidthSessionIdFactory(int width, char[] chars, int numPartitions) {
        this._keyLength = width;
        this._chars = chars;
        this._base = this._chars.length;
        this._numPartitions = numPartitions;
        this._partitionLength = this.size(this._numPartitions);
        for (int i = 0; i < this._base; ++i) {
            this._lookup[this._chars[i]] = i;
        }
        this._sectLength = this.size(Long.MAX_VALUE);
    }

    public String create(int partition) {
        int width = this._keyLength + this._divider.length + this._partitionLength;
        char[] buffer = new char[width];
        int offset = width - 1;
        offset = this.encode(partition, this._partitionLength, buffer, offset);
        for (int i = this._divider.length - 1; i >= 0; --i) {
            buffer[offset--] = this._divider[i];
        }
        while ((offset = this.encode(Math.abs(this._random.nextLong()), this._sectLength, buffer, offset)) >= 0) {
        }
        return new String(buffer);
    }

    protected int encode(long sect, int iters, char[] buffer, int offset) {
        for (int i = 0; i < iters && offset >= 0; ++i) {
            buffer[offset--] = this._chars[(int)(sect % (long)this._base)];
            sect /= (long)this._base;
        }
        return offset;
    }

    public int getPartition(String key) {
        return this.decode(key.toCharArray(), key.length() - this._partitionLength, this._partitionLength);
    }

    protected int decode(char[] buffer, int from, int length) {
        int result = 0;
        int multiplier = 1;
        for (int i = from + length - 1; i >= from; --i) {
            result += this._lookup[buffer[i]] * multiplier;
            multiplier *= this._base;
        }
        return result;
    }

    protected int size(long l) {
        int i = 0;
        while (l != 0L) {
            l /= (long)this._base;
            ++i;
        }
        return i;
    }

    protected int size(int n) {
        int i = 0;
        while (n != 0) {
            n /= this._base;
            ++i;
        }
        return i;
    }

    public static void main(String[] args) {
        int numPartitions = 1024;
        FixedWidthSessionIdFactory factory = new FixedWidthSessionIdFactory(32, numPartitions);
        Random r = new Random();
        for (int i = 0; i < numPartitions; ++i) {
            int partition = Math.abs(r.nextInt()) % numPartitions;
            String key = factory.create(partition);
            System.out.println(key + " - " + partition);
            if (!$assertionsDisabled && partition != factory.getPartition(key)) {
                throw new AssertionError();
            }
        }
    }

    public int map(Object key) {
        int index = this.getPartition((String)key);
        this._log.info((Object)("mapped " + key + " -> " + index));
        return index;
    }

    static {
        $assertionsDisabled = !FixedWidthSessionIdFactory.class.desiredAssertionStatus();
        _defaultChars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    }
}

